/*
 * Decompiled with CFR 0.152.
 */
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;

public class Start {
    protected static String[] fArgv;
    protected static String[] fSplashCmd;

    public static void main(String[] argv) {
        Start.handleArguments(argv);
        boolean lockingState = false;
        try {
            lockingState = Toolkit.getDefaultToolkit().getLockingKeyState(20);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (lockingState) {
            Toolkit.getDefaultToolkit().setLockingKeyState(20, false);
            Start.executeVersionChooser();
        } else {
            Start.startApplication(fArgv);
            Start.closeSplash();
        }
    }

    private static void startApplication(String[] argv) {
        try {
            Application.main(argv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void closeSplash() {
        if (fSplashCmd != null) {
            try {
                Runtime.getRuntime().exec(fSplashCmd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static void handleArguments(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            argv[i] = argv[i].replace('?', ' ');
        }
        int startIndex = 0;
        for (int index = 0; index < argv.length; ++index) {
            if (argv[index].equals(" ")) {
                ++startIndex;
            }
            if (!argv[index].equals("-endsplash") || index + 1 >= argv.length) continue;
            fSplashCmd = new String[3];
            Start.fSplashCmd[0] = Language.getString("app.fileName", "LOGOComfort") + ".exe";
            Start.fSplashCmd[1] = argv[index];
            Start.fSplashCmd[2] = argv[index + 1];
            if (argv[0].indexOf(".exe") != -1) {
                ++startIndex;
            }
            String[] arr = new String[argv.length - 2 - startIndex];
            if (argv.length - 2 - startIndex > 0) {
                System.arraycopy(argv, startIndex, arr, 0, argv.length - 2 - startIndex);
                if (argv.length > index + 2) {
                    System.arraycopy(argv, index + 2, arr, index, argv.length - index - 2);
                }
            }
            fArgv = arr;
        }
        if (fArgv == null) {
            fArgv = argv;
        }
    }

    protected static void executeVersionChooser() {
        VersionChooser chooser = new VersionChooser();
        File result = chooser.chooseVersion();
        System.out.println("Choosed version: " + result);
        if (result != null) {
            chooser.changeVersionTo(result);
            try {
                String[] command = new String[fArgv.length + 1];
                command[0] = "Start.exe";
                for (int i = 0; i < fArgv.length; ++i) {
                    command[i + 1] = fArgv[i];
                }
                Runtime.getRuntime().exec(command);
                System.out.println("Start again....");
                System.exit(0);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            Start.startApplication(fArgv);
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        BufferedInputStream fromStream = new BufferedInputStream(new FileInputStream(from));
        BufferedOutputStream toStream = new BufferedOutputStream(new FileOutputStream(to));
        byte[] buffer = new byte[8192];
        int bytesRead = 0;
        while ((bytesRead = fromStream.read(buffer)) != -1) {
            toStream.write(buffer, 0, bytesRead);
        }
        fromStream.close();
        toStream.close();
        to.setLastModified(from.lastModified());
    }

    static {
        fSplashCmd = null;
    }

    private static class VersionChooser {
        File result = null;
        private File[] fAvailableVersions;

        private VersionChooser() {
        }

        public File chooseVersion() {
            ClassesFilter filter = new ClassesFilter();
            this.fAvailableVersions = new File("lib").listFiles(filter);
            Arrays.sort(this.fAvailableVersions);
            final JDialog frame = new JDialog();
            frame.setTitle("Choose Version");
            frame.setModal(true);
            JPanel panel = new JPanel(new BorderLayout());
            frame.setContentPane(panel);
            final JList<File> list = new JList<File>(this.fAvailableVersions);
            list.setCellRenderer(new VersionListCellRenderer());
            for (int i = 0; i < this.fAvailableVersions.length; ++i) {
                if (!this.fAvailableVersions[i].getName().equals("classes.jar")) continue;
                list.setSelectedIndex(i);
                break;
            }
            panel.add(list, "Center");
            JPanel control = new JPanel(new FlowLayout(2));
            panel.add((Component)control, "South");
            JButton okButton = new JButton("OK");
            JButton cancelButton = new JButton("Cancel");
            control.add(okButton);
            control.add(cancelButton);
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (!list.isSelectionEmpty()) {
                        VersionChooser.this.result = (File)list.getSelectedValue();
                        frame.dispose();
                    }
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    frame.dispose();
                }
            });
            Start.closeSplash();
            frame.pack();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            int x = (dim.width - frame.getWidth()) / 2;
            int y = (dim.height - frame.getHeight()) / 2;
            frame.setLocation(x, y);
            frame.setVisible(true);
            frame.toFront();
            return this.result;
        }

        public void changeVersionTo(File result) {
            if (result.getName().equals("classes.jar")) {
                System.out.println("Ausgew\u00e4hlte version entspricht der aktuellen.");
                return;
            }
            String newNameForOrg = null;
            File orgFile = null;
            for (int i = 0; i < this.fAvailableVersions.length; ++i) {
                orgFile = this.fAvailableVersions[i];
                if (!orgFile.getName().equals("classes.jar")) continue;
                newNameForOrg = "classes_" + this.getVersion(orgFile) + ".jar";
                newNameForOrg = newNameForOrg.replace(' ', '_');
                newNameForOrg = newNameForOrg.replace('/', '_');
                newNameForOrg = newNameForOrg.replace(':', '-');
                break;
            }
            try {
                String path = this.fAvailableVersions[0].getParent();
                File newFile = null;
                if (newNameForOrg == null) {
                    System.err.println("Kein lib/classes.jar gefunden");
                } else {
                    newFile = new File(path, newNameForOrg);
                    System.out.print("copying " + orgFile.getPath() + " to " + newFile.getPath() + "...");
                    Start.copyFile(orgFile, newFile);
                    System.out.println("ok");
                }
                newFile = new File(path, "classes.jar");
                System.out.print("copying " + result.getPath() + " to " + newFile.getPath() + "...");
                Start.copyFile(result, newFile);
                System.out.println("ok");
                result.delete();
            }
            catch (IOException ioe) {
                System.out.println("Exeption while renaming update-files in finishing update:");
                ioe.printStackTrace();
            }
        }

        private String getVersion(File path) {
            String stringResult = null;
            try {
                DirectClassLoader cl = new DirectClassLoader(path);
                Object obj = null;
                try {
                    Class<?> clazz = Class.forName("DE.siemens.ad.logo.util.Version", true, cl);
                    obj = clazz.getMethod("getCurrentVersion", new Class[0]);
                    obj = ((Method)obj).invoke((Object)this, (Object[])null);
                    Field idField = clazz.getDeclaredField("MAJOR_VERSION");
                    idField.setAccessible(true);
                    int id = idField.getInt(null);
                    String major = String.valueOf(id);
                    idField = clazz.getDeclaredField("MINOR_VERSION");
                    idField.setAccessible(true);
                    id = idField.getInt(null);
                    String minor = String.valueOf(id);
                    idField = clazz.getDeclaredField("BUILD_VERSION");
                    idField.setAccessible(true);
                    id = idField.getInt(null);
                    String buildVersion = String.valueOf(id);
                    idField = clazz.getDeclaredField("BUILD_TIME");
                    idField.setAccessible(true);
                    String buildTime = (String)idField.get(null);
                    buildTime = this.formatBuildTime(buildTime);
                    buildTime = String.valueOf(buildTime);
                    StringBuffer buff = new StringBuffer(50);
                    buff.append(major).append(".").append(minor).append(".").append(buildVersion).append("(").append(this.getConfiguration(path)).append(")").append(" vom ").append(buildTime);
                    stringResult = buff.toString();
                }
                catch (Exception iae) {
                    System.out.println(iae);
                    System.out.println("Load class and getCurrentVersion() failed..");
                }
            }
            catch (Exception e) {
                System.out.println("Check Version: Exception");
                System.out.println(e.getClass().getName());
                e.printStackTrace();
            }
            return stringResult;
        }

        private String formatBuildTime(String buildTime) {
            StringBuffer buff = new StringBuffer(14);
            buff.append(buildTime.substring(0, 2)).append('.');
            buff.append(buildTime.substring(3, 5)).append('.');
            buff.append(buildTime.substring(6, 10));
            buff.append('/');
            buff.append(buildTime.substring(11, 13)).append(':');
            buff.append(buildTime.substring(14, 16));
            return buff.toString();
        }

        private String getConfiguration(File path) {
            String result = "";
            DirectClassLoader cl = new DirectClassLoader(path);
            try {
                Class<?> clazz = Class.forName("DE.siemens.ad.logo.util.Configuration", true, cl);
                Object obj = clazz.getMethod("getCurrentConfiguration", new Class[0]);
                obj = ((Method)obj).invoke((Object)this, (Object[])null);
                Field idField = clazz.getDeclaredField("ID");
                idField.setAccessible(true);
                int id = idField.getInt(null);
                result = id == -1 ? "Full" : (id == 0 ? "Demo" : (id == 1 ? "Test" : "Unkonwn"));
            }
            catch (ClassNotFoundException e) {
                System.err.println("getConfiguration(" + path + ") " + e.getMessage());
            }
            catch (NoSuchMethodException ie) {
                System.err.println("getConfiguration(" + path + ") " + ie.getMessage());
            }
            catch (IllegalAccessException e) {
                System.err.println("getConfiguration(" + path + ") " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            return result;
        }

        private static class ClassesFilter
        implements FileFilter {
            private ClassesFilter() {
            }

            public boolean accept(File pathname) {
                return pathname.getName().startsWith("classes");
            }
        }

        private class VersionListCellRenderer
        extends DefaultListCellRenderer {
            private VersionListCellRenderer() {
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                File file = (File)value;
                String version = VersionChooser.this.getVersion(file);
                if (version == null) {
                    this.setText(file.getName());
                } else {
                    this.setText(version);
                }
                return this;
            }
        }

        private class DirectClassLoader
        extends ClassLoader {
            private Hashtable classes = new Hashtable();
            private File fPath;
            private boolean debug = false;

            public DirectClassLoader() {
            }

            public DirectClassLoader(File path) {
                this.fPath = path;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte[] getClassFromJar(String className) {
                byte[] result = null;
                if (this.debug) {
                    System.out.println("        >>>>>> Fetching the implementation of " + className + " from " + this.fPath);
                }
                if (className.indexOf(46) > 0) {
                    className = className.replace('.', '/') + ".class";
                }
                try {
                    JarFile zip;
                    block14: {
                        zip = new JarFile(this.fPath);
                        try {
                            JarEntry entry = zip.getJarEntry(className);
                            if (entry == null) break block14;
                            InputStream in = null;
                            try {
                                int len;
                                in = new BufferedInputStream(zip.getInputStream(entry));
                                result = new byte[len];
                                int off = 0;
                                for (len = (int)entry.getSize(); len > 0; len -= off) {
                                    off += in.read(result, off, len);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                        }
                        catch (EOFException e) {
                            System.err.println("Class not found in zipFile!");
                        }
                    }
                    zip.close();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return result;
            }

            public Class loadClass(String className) throws ClassNotFoundException {
                return this.loadClass(className, true);
            }

            public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
                byte[] classData;
                Class<?> result;
                block15: {
                    if (this.debug) {
                        System.out.println("        >>>>>> Load class : " + className);
                    }
                    if ((result = (Class<?>)this.classes.get(className)) != null) {
                        if (this.debug) {
                            System.out.println("        >>>>>> returning cached result.");
                        }
                        return result;
                    }
                    if (!className.startsWith("DE")) {
                        try {
                            result = super.findSystemClass(className);
                            if (this.debug) {
                                System.out.println("        >>>>>> returning system class (in CLASSPATH).");
                            }
                            return result;
                        }
                        catch (ClassNotFoundException e) {
                            if (!this.debug) break block15;
                            System.out.println("        >>>>>> Not a system class.");
                        }
                    }
                }
                if ((classData = this.getClassFromJar(className)) == null) {
                    throw new ClassNotFoundException();
                }
                try {
                    result = this.defineClass(className, classData, 0, classData.length);
                }
                catch (ClassFormatError cfe) {
                }
                catch (Exception e) {
                    System.err.println("Exception defining class!");
                    e.printStackTrace();
                }
                catch (Error err) {
                    System.err.println("Error defining class!");
                    err.printStackTrace();
                }
                if (result == null) {
                    throw new ClassFormatError();
                }
                if (resolveIt) {
                    this.resolveClass(result);
                }
                this.classes.put(className, result);
                if (this.debug) {
                    System.out.println("        >>>>>> Returning newly loaded class.");
                }
                return result;
            }
        }
    }
}

