/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Painter;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class PageLinePainter
implements Painter {
    public void draw(Graphics g, DrawingView view) {
        int x;
        int y;
        int pageNumber;
        LogoDrawing logoDrawing = (LogoDrawing)view.drawing();
        double zoomFactor = (double)((LogoDrawingView)view).getZoomManager().getZoom() / 100.0;
        double printZoom = logoDrawing.getPrintZoom();
        double imageableX = logoDrawing.getPageDimension().getWidth();
        double imageableY = logoDrawing.getPageDimension().getHeight();
        g.setColor(Global.MARGIN_COLOR);
        int maxX = logoDrawing.getWiringDiagram().getDrawingProperties().getPagesHorizontal();
        for (int i = 1; i < maxX; ++i) {
            g.drawLine((int)((double)i * imageableX * zoomFactor / printZoom), 0, (int)((double)i * imageableX * zoomFactor / printZoom), (int)view.getPreferredSize().getHeight());
        }
        int maxY = logoDrawing.getWiringDiagram().getDrawingProperties().getPagesVertical();
        for (int i = 1; i < maxY; ++i) {
            g.drawLine(0, (int)((double)i * imageableY * zoomFactor / printZoom), (int)view.getPreferredSize().getWidth(), (int)((double)i * imageableY * zoomFactor / printZoom));
        }
        if (zoomFactor <= 0.25) {
            Font f = g.getFont().deriveFont((float)(150.0 * zoomFactor));
            g.setFont(f);
            g.setColor(Color.gray);
            pageNumber = 1;
            for (y = 0; y < maxY; ++y) {
                for (x = 0; x < maxX; ++x) {
                    g.drawString(Integer.toString(pageNumber++), (int)(((double)x + 0.5) * imageableX * zoomFactor / printZoom), (int)(((double)y + 0.5) * imageableY * zoomFactor / printZoom));
                }
            }
        }
        if (zoomFactor <= 0.25) {
            Font font = g.getFont();
            g.setFont(new Font(font.getName(), font.getStyle(), (int)(150.0 * zoomFactor)));
            g.setColor(Color.gray);
            pageNumber = 1;
            for (y = 0; y < maxY; ++y) {
                for (x = 0; x < maxX; ++x) {
                    g.drawString(Integer.toString(pageNumber++), (int)(((double)x + 0.5) * imageableX * zoomFactor / printZoom), (int)(((double)y + 0.5) * imageableY * zoomFactor / printZoom));
                }
            }
        }
    }
}

