/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import DE.siemens.ad.logo.app.StatusLine;
import DE.siemens.ad.logo.comm.Modem;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.pdraw.action.ConnectModemToolAction;
import DE.siemens.ad.pdraw.app.ModemManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class LogoComfortStatusLine
extends StatusLine {
    protected Statusfield fZoom;
    protected Statusfield fModified;
    protected Statusfield fPage;
    protected JLabel fHardware;
    protected JLabel fModemConnectStatus = new JLabel();
    protected String fOldMessage;
    protected String fTempMessage;
    protected Color fOldColor;
    protected Vector fHardwareClickedListeners;

    public LogoComfortStatusLine() {
        this.fModemConnectStatus.setToolTipText(Language.getString("modem.statusLine.tooltip", "Modem connection status"));
        this.fModemConnectStatus.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    if (Modem.isModemConnected()) {
                        if (new LogoError(null, "modem.statusLine.disconnectNotify", "Ready to disconnect modem", 1, 1).display() == 0) {
                            LogoComfortStatusLine.this.setCursor(Cursor.getPredefinedCursor(3));
                            ModemManager.disconnect();
                            LogoComfortStatusLine.this.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    } else if (ConnectModemToolAction.getInstance().isEnabled()) {
                        ModemManager.connect();
                    }
                }
            }
        });
        this.add(this.fModemConnectStatus);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.fHardware = new JLabel();
        this.fHardware.setToolTipText(Language.getString("dialog.messageDisplay.tooltip.doubleClickToEdit", "Doubleclick to select device"));
        this.add(this.fHardware);
        this.fModified = new Statusfield("", 5);
        this.add(this.fModified);
        this.fZoom = new Statusfield("100%", 5);
        this.fZoom.setToolTipText(Language.getString("dialog.zoom.title", "Zoom value"));
        this.add(this.fZoom);
        this.fPage = new Statusfield("", 4);
        this.fHardware.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    LogoComfortStatusLine.this.setCursor(Cursor.getPredefinedCursor(3));
                    LogoComfortStatusLine.this.hardwareClicked();
                    LogoComfortStatusLine.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.add(this.fPage);
    }

    public void addHardwareClickedListener(HardwareClickedListener hcl) {
        if (!this.getHardwareClickedListeners().contains(hcl)) {
            this.getHardwareClickedListeners().add(hcl);
        }
    }

    protected Vector getHardwareClickedListeners() {
        if (this.fHardwareClickedListeners == null) {
            this.fHardwareClickedListeners = new Vector(5);
        }
        return this.fHardwareClickedListeners;
    }

    private void hardwareClicked() {
        Vector clone = (Vector)this.getHardwareClickedListeners().clone();
        HardwareClickedEvent hce = new HardwareClickedEvent(this);
        for (int i = 0; i < clone.size(); ++i) {
            ((HardwareClickedListener)clone.elementAt(i)).hardwareClicked(hce);
        }
    }

    public void removeHardwareClickedListener(HardwareClickedListener hcl) {
        this.getHardwareClickedListeners().remove(hcl);
    }

    public void setHardware(Hardware hw) {
        this.fHardware.setIcon(hw.getIcon());
        String hardwareName = hw.getLocalizedPath() + hw.getLocalizedName();
        this.fHardware.setText(hardwareName);
    }

    public void setModemStatus(int modemStatus) {
        if (modemStatus == 2) {
            this.fModemConnectStatus.setIcon(Global.getIcon("modemConnected.gif"));
            this.fModemConnectStatus.setText(Language.getString("modem.statusLine.connected", "Modem connected"));
        } else if (modemStatus == 1) {
            this.fModemConnectStatus.setIcon(Global.getIcon("modemDisconnected.gif"));
            this.fModemConnectStatus.setText(Language.getString("modem.statusLine.connecting", "Modem connecting..."));
        } else if (modemStatus == 3) {
            this.fModemConnectStatus.setIcon(Global.getIcon("modemConnected.gif"));
            this.fModemConnectStatus.setText(Language.getString("modem.statusLine.disconnecting", "Modem disconnecting..."));
        } else {
            this.fModemConnectStatus.setIcon(Global.getIcon("modemDisconnected.gif"));
            this.fModemConnectStatus.setText(Language.getString("modem.statusLine.disconnected", "Modem disconnected"));
        }
    }

    public void setModified(boolean isModified) {
        if (isModified) {
            this.fModified.setText("mod");
        } else {
            this.fModified.setText("");
        }
    }

    public void setPage(int pageNumber) {
        if (pageNumber > 0) {
            this.fPage.setText(Language.getString("page.shortcut", "P.") + " " + pageNumber);
        } else {
            this.fPage.setText("");
        }
    }

    public void setPageRange(int pageNumberMin, int pageNumberMax) {
        this.fPage.setText(Language.getString("page.shortcut", "P.") + " " + pageNumberMin + "-" + pageNumberMax);
    }

    public void setZoom(String zoom) {
        this.fZoom.setText(zoom + "%");
    }

    public static interface HardwareClickedListener
    extends EventListener {
        public void hardwareClicked(HardwareClickedEvent var1);
    }

    public static class HardwareClickedEvent
    extends EventObject {
        public HardwareClickedEvent(Object source) {
            super(source);
        }
    }

    public static class Statusfield
    extends JTextField {
        public Statusfield(String s, int i) {
            super(s, i);
            this.setBackground(UIManager.getColor("Panel.background"));
            this.setRequestFocusEnabled(false);
            this.setEditable(false);
        }

        public boolean isFocusable() {
            return false;
        }

        public Dimension getMaximumSize() {
            Dimension d = super.getPreferredSize();
            return d;
        }
    }
}

