/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Painter;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.util.GridInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;

public class GridPainter
implements Painter {
    protected GridInfo fGridInfo;
    transient int fX;
    transient int fY;
    transient int fZoom;
    transient int fIndexX;
    transient int fIndexY;

    public GridPainter(GridInfo gi) {
        this.fGridInfo = gi;
        this.fX = gi.getHorizontalDistance();
        this.fY = gi.getVerticalDistance();
    }

    public void draw(Graphics g, DrawingView view) {
        if (this.fGridInfo.gridIsVisible()) {
            Dimension d = view.getSize();
            this.fX = this.fGridInfo.getHorizontalDistance();
            this.fY = this.fGridInfo.getVerticalDistance();
            this.fZoom = ((LogoDrawingView)view).getZoomManager().getZoom();
            if ((double)this.fX * ((double)this.fZoom / 100.0) < 5.0) {
                return;
            }
            this.fIndexX = 0;
            this.fIndexY = 0;
            g.setColor(Color.black);
            Rectangle clipBounds = g.getClip().getBounds();
            double xInc = this.fX * this.fZoom / 100;
            double yInc = this.fY * this.fZoom / 100;
            double xStart = Math.ceil(clipBounds.getX() / xInc) * xInc;
            double yStart = Math.ceil(clipBounds.getY() / yInc) * yInc;
            double xEnd = clipBounds.width + clipBounds.x;
            double yEnd = clipBounds.height + clipBounds.y;
            for (double y = yStart - (double)(1 * this.fZoom / 100); y < yEnd; y += yInc) {
                for (double x = xStart; x < xEnd; x += xInc) {
                    g.drawLine((int)x, (int)y, (int)x, (int)y);
                }
            }
        }
    }
}

