/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.util;

import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import DE.siemens.ad.pdraw.util.GridIfc;

public class GridInfo
implements GridIfc {
    private DrawingView fView;
    int fHorizontalDistance = 10;
    int fVerticalDistance = 10;
    boolean fAttraction = true;
    boolean fConnectionAttraction = true;
    boolean fVisibility = true;
    boolean fModified = true;

    public GridInfo(DrawingView view) {
        this.fView = view;
        this.loadValuesFromIni();
    }

    public GridInfo(DrawingView view, int horizontalDistance, int verticalDistance) {
        this(view);
        this.fHorizontalDistance = horizontalDistance;
        this.fVerticalDistance = verticalDistance;
    }

    public int getDistance() {
        return this.fHorizontalDistance;
    }

    public int getHorizontalDistance() {
        return this.fHorizontalDistance;
    }

    public int getVerticalDistance() {
        return this.fVerticalDistance;
    }

    public boolean gridAttractionIsOn() {
        return this.fAttraction;
    }

    public boolean gridConnectionAttractionIsOn() {
        return this.fConnectionAttraction;
    }

    public boolean gridIsVisible() {
        return this.fVisibility;
    }

    public boolean gridModified() {
        if (this.fModified) {
            this.fModified = false;
            return true;
        }
        return this.fModified;
    }

    public void setDistance(int distance) {
        if (this.fHorizontalDistance != distance) {
            this.fModified = true;
            this.fHorizontalDistance = distance;
            this.fVerticalDistance = distance;
        }
    }

    public void setGridAttraction(boolean mode) {
        this.fAttraction = mode;
    }

    public void setGridConnectionAttraction(boolean mode) {
        this.fConnectionAttraction = mode;
    }

    public void setGridVisibility(boolean mode) {
        if (this.fVisibility != mode) {
            this.fModified = true;
        }
        this.fVisibility = mode;
    }

    private void loadValuesFromIni() {
        LogoProperties logoProperties = LogoProperties.instance();
        String editorClassName = ((LogoDrawingView)this.fView).getEditor().getEditorInfo().getEditorClassName();
        this.fHorizontalDistance = this.fVerticalDistance = logoProperties.getIntProperty(editorClassName + ".grid.distance", 10);
        this.fAttraction = logoProperties.getBooleanProperty(editorClassName + ".grid.attraction", true);
        this.fConnectionAttraction = logoProperties.getBooleanProperty(editorClassName + ".grid.connectionAttraction", true);
        this.fVisibility = logoProperties.getBooleanProperty(editorClassName + ".grid.visibility", true);
    }

    public void saveAsDefault() {
        LogoProperties logoProperties = LogoProperties.instance();
        String editorClassName = ((LogoDrawingView)this.fView).getEditor().getEditorInfo().getEditorClassName();
        logoProperties.setIntProperty(editorClassName + ".grid.distance", this.fHorizontalDistance);
        logoProperties.setBooleanProperty(editorClassName + ".grid.attraction", this.fAttraction);
        logoProperties.setBooleanProperty(editorClassName + ".grid.connectionAttraction", this.fConnectionAttraction);
        logoProperties.setBooleanProperty(editorClassName + ".grid.visibility", this.fVisibility);
    }

    private void updateDrawingView() {
        ((LogoDrawingView)this.fView).setConstrainer(new LogoGridConstrainer(this));
        ((LogoDrawing)this.fView.drawing()).updateConnections();
    }
}

