/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.NegateConnectorAction;
import DE.siemens.ad.pdraw.figures.CommentTextFigure;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.standard.BlockConnectionTool;
import DE.siemens.ad.pdraw.standard.IconTextTooltip;
import DE.siemens.ad.pdraw.standard.LogoAbstractTool;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.MouseInteractor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class LogoSelectionTool
extends LogoAbstractTool
implements MouseInteractor {
    private BlockConnectionTool fConnectionInteractor = null;
    private Tool fInteractor = null;
    private IconTextTooltip fNegatedTooltip;

    public void mouseDown(MouseEvent e, int x, int y, DrawingView view) {
        if (this.handleDoubleClicked(e, view)) {
            return;
        }
        if (this.fInteractor != null) {
            return;
        }
        view.freezeView();
        Handle handle = view.findHandle(e.getX(), e.getY());
        if (handle != null) {
            this.fInteractor = new HandleTracker(handle);
        } else {
            Figure figure = view.drawing().findFigure(e.getX(), e.getY());
            if (figure != null && figure.isSelectable()) {
                this.fInteractor = new DragTracker(figure);
            } else {
                if (!e.isControlDown()) {
                    view.clearSelection();
                }
                this.fInteractor = new SelectAreaTracker();
            }
        }
        if (this.fInteractor != null) {
            this.fInteractor.mouseDown(e, x, y, view);
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y, DrawingView view) {
        this.checkViewport(x, y, view);
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        if (this.fInteractor != null) {
            this.fInteractor.mouseDrag(e, x, y, view);
        }
    }

    public void mouseUp(MouseEvent e, int x, int y, DrawingView view) {
        view.unfreezeView();
        if (this.fInteractor != null) {
            this.fInteractor.mouseUp(e, x, y, view);
        }
        this.fInteractor = null;
        this.handleRightMouse(e, view);
    }

    public void mouseMove(MouseEvent evt, int x, int y, DrawingView view) {
        if (this.fConnectionInteractor != null) {
            this.fConnectionInteractor.mouseMove(evt, x, y, view);
        }
    }

    public boolean handleDoubleClicked(MouseEvent e, DrawingView view) {
        if (e.getClickCount() >= 2) {
            InputIfcFigure inputFigure;
            Figure insideFigure;
            Figure figure = view.drawing().findFigure(e.getX(), e.getY());
            if (figure instanceof CommentTextFigure) {
                Editor editor = (Editor)((Object)view.editor());
                LogoAction changeFontAction = editor.getActionFactory().getAction("ChangeFiguresFontAttributesAction");
                editor.getActionManager().invokeAction(changeFontAction);
            }
            if ((insideFigure = view.drawing().findFigureInside(e.getX(), e.getY())) instanceof InputIfcFigure && (inputFigure = (InputIfcFigure)insideFigure).getBlockConnector().isNegatable()) {
                view.clearSelection();
                view.addToSelection(inputFigure);
                Editor editor = ((LogoDrawingView)view).getEditor();
                NegateConnectorAction negateConnectorAction = (NegateConnectorAction)editor.getActionFactory().getAction("NegateConnectorAction");
                editor.getActionManager().invokeAction(negateConnectorAction);
                this.showConnectorNegatedTooltip(e, view, inputFigure.getBlockConnector());
                view.clearSelection();
                return true;
            }
        }
        return super.handleDoubleClicked(e, view);
    }

    private void showConnectorNegatedTooltip(MouseEvent e, DrawingView view, BlockConnector blockConnector) {
        boolean newNegated = blockConnector.isNegated();
        if (this.fNegatedTooltip == null) {
            this.fNegatedTooltip = new IconTextTooltip();
        }
        String negatedText = null;
        negatedText = newNegated ? Language.getString("global.negated", "negated") : Language.getString("global.notNegated", "not negated");
        this.fNegatedTooltip.setText(blockConnector.getLocalizedName(false) + " " + negatedText);
        Point tooltipLocation = ((LogoDrawingView)view).getZoomManager().convertModelToDisplayCoordinates(e.getPoint());
        this.fNegatedTooltip.setLocation(new Point(tooltipLocation.x + 15, tooltipLocation.y));
        this.fNegatedTooltip.pack();
        ((JComponent)((Object)view)).add(this.fNegatedTooltip);
        ((JComponent)((Object)view)).repaint();
        this.fNegatedTooltip.revalidate();
        this.fNegatedTooltip.setAutoHideTimeout(1000);
        this.fNegatedTooltip.startAutoHide();
    }

    public void keyDown(KeyEvent evt, int key, DrawingView view) {
        Tool interactor = this.fInteractor;
        int code = evt.getKeyCode();
        if ((interactor == null && code == 40 || code == 38 || code == 39 || code == 37) && !view.selection().isEmpty()) {
            Figure anchorFigure = (Figure)view.selection().get(0);
            interactor = new DragTracker(anchorFigure);
        }
        if (interactor != null) {
            interactor.keyDown(evt, key, view);
        }
    }
}

