/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.PointConstrainer;
import DE.siemens.ad.pdraw.util.GridIfc;
import java.awt.Point;

public class LogoGridConstrainer
implements PointConstrainer {
    static final long serialVersionUID = -1235373480874235359L;
    private int logoGridConstrainerSerializedDataVersion = 1;
    protected GridIfc fGridIfc;

    public LogoGridConstrainer(GridIfc gi) {
        this.fGridIfc = gi;
    }

    public Point constrainPoint(Point p) {
        Point returnPoint = new Point();
        returnPoint.x = this.getConstrainX(p.x);
        returnPoint.y = this.getConstrainY(p.y);
        return returnPoint;
    }

    public Point constrainX(Point p) {
        return new Point(this.getConstrainX(p.x), p.y);
    }

    public Point constrainY(Point p) {
        return new Point(p.x, this.getConstrainY(p.y));
    }

    protected int getConstrainX(int x) {
        int grid = this.fGridIfc.getDistance();
        return (int)(Math.floor(x / grid) * (double)grid);
    }

    protected int getConstrainY(int y) {
        int grid = this.fGridIfc.getDistance();
        int ret = (int)(Math.floor((y + 1) / grid) * (double)grid) - 1;
        return ret > 0 ? ret : 0;
    }

    public int getStepX() {
        return this.fGridIfc.getDistance();
    }

    public int getStepY() {
        return this.fGridIfc.getDistance();
    }

    public GridIfc getGridIfc() {
        return this.fGridIfc;
    }
}

