/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.util.ColorMap;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.standard.FontAttributes;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Hashtable;

public class FontAttributesObject
implements FontAttributes {
    protected String fFontColor;
    protected String fFontName;
    protected int fFontSize;
    protected int fFontStyle;
    protected boolean fUseAsDefault;
    protected TextFigure textFigure;

    public FontAttributesObject(TextFigure textFigure) {
        this.textFigure = textFigure;
        if (textFigure != null) {
            Color color = (Color)textFigure.getAttribute("TextColor");
            this.fFontColor = ColorMap.name(color);
            this.fFontName = (String)textFigure.getAttribute("FontName");
            this.fFontStyle = (Integer)textFigure.getAttribute("FontStyle");
            this.fFontSize = (Integer)textFigure.getAttribute("FontSize");
        }
    }

    public String getDefaultFontColor() {
        Color color = TextFigure.getCurrentFontColor();
        return ColorMap.name(color);
    }

    public String getDefaultFontName() {
        return TextFigure.getCurrentFontName();
    }

    public int getDefaultFontSize() {
        return TextFigure.getCurrentFontSize();
    }

    public int getDefaultFontStyle() {
        return TextFigure.getCurrentFontStyle();
    }

    public Hashtable getFontAttributes() {
        Hashtable<String, Object> attributes = new Hashtable<String, Object>(20);
        attributes.put("FontName", this.getFontName());
        attributes.put("FontSize", new Integer(this.getFontSize()));
        attributes.put("FontStyle", new Integer(this.getFontStyle()));
        attributes.put("TextColor", ColorMap.color(this.getFontColor()));
        return attributes;
    }

    public String getFontColor() {
        if (this.textFigure == null) {
            return this.getDefaultFontColor();
        }
        return this.fFontColor;
    }

    public String[] getFontColors() {
        return ColorMap.colorKeys();
    }

    public String getFontName() {
        if (this.textFigure == null) {
            return TextFigure.getCurrentFontName();
        }
        return this.fFontName;
    }

    public String[] getFontNames() {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        return fonts;
    }

    public int getFontSize() {
        if (this.textFigure == null) {
            return this.getDefaultFontSize();
        }
        return this.fFontSize;
    }

    public int[] getFontSizes() {
        int[] sizes = new int[]{8, 9, 10, 12, 14, 18, 24, 36, 48, 72};
        return sizes;
    }

    public int getFontStyle() {
        if (this.textFigure == null) {
            return this.getDefaultFontStyle();
        }
        return this.fFontStyle;
    }

    public void setFontColor(String fontColor) {
        this.fFontColor = fontColor;
    }

    public void setFontName(String fontName) {
        this.fFontName = fontName;
    }

    public void setFontSize(int fontSize) {
        this.fFontSize = fontSize;
    }

    public void setFontStyle(int fontStyle) {
        this.fFontStyle = fontStyle;
    }

    public void setUseAsDefault(boolean useAsDefault) {
        this.fUseAsDefault = useAsDefault;
    }

    public boolean isUseAsDefault() {
        return this.fUseAsDefault;
    }

    public void storeDefaults() {
        Color fontColor = ColorMap.color(this.fFontColor);
        TextFigure.setCurrentFontStyle(this.fFontStyle);
        TextFigure.setCurrentFontSize(this.fFontSize);
        TextFigure.setCurrentFontName(this.fFontName);
        TextFigure.setCurrentFontColor(fontColor);
        LogoProperties properties = LogoProperties.instance();
        properties.setIntProperty("font.default.style", this.fFontStyle);
        properties.setIntProperty("font.default.size", this.fFontSize);
        properties.setProperty("font.default.name", this.fFontName);
        properties.setIntProperty("font.default.color", fontColor.getRGB());
    }

    private String encodeFont(Font font) {
        String strStyle = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
        return font.getName() + "-" + strStyle + "-" + font.getSize();
    }
}

