/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.figures.BlockConnectorOwner;
import DE.siemens.ad.pdraw.standard.IconTextTooltip;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ConnectionValidator {
    private Point fTooltipLocation;
    private DrawingView fView;
    protected IconTextTooltip fToolTip = null;

    protected boolean areAlreadyConnected(BlockConnectorOwner inputConnectorOwner, BlockConnectorOwner outputConnectorOwner) {
        InBlockConnector inBlockConnector = (InBlockConnector)inputConnectorOwner.getBlockConnector();
        OutBlockConnector outBlockConnector = (OutBlockConnector)outputConnectorOwner.getBlockConnector();
        return inBlockConnector.getLinkedConnectorsList().contains(outBlockConnector);
    }

    protected boolean checkSignalTypeCompatible(Connector start, Connector end) {
        boolean compatible = true;
        if (start == null || end == null) {
            return false;
        }
        BlockConnector startBlockConnector = ((BlockConnectorOwner)((Object)start.owner())).getBlockConnector();
        BlockConnector endBlockConnector = ((BlockConnectorOwner)((Object)end.owner())).getBlockConnector();
        compatible = this.checkSignalTypeCompatible(startBlockConnector, endBlockConnector);
        return compatible;
    }

    protected boolean checkSignalTypeCompatible(BlockConnectorOwner owner1, BlockConnectorOwner owner2) {
        return this.checkSignalTypeCompatible(owner1.getBlockConnector(), owner2.getBlockConnector());
    }

    protected boolean checkSignalTypeCompatible(BlockConnector connector1, BlockConnector connector2) {
        boolean compatible;
        boolean bl = compatible = connector1.getSignalType() == connector2.getSignalType();
        if (!compatible) {
            this.showTooltip("msg.incompatibleConnectors", "The connectors are incompatible (binary-analog)", 2);
        }
        return compatible;
    }

    public void showTooltip(String textKey, String defaultText, int tooltipType) {
        Point tooltipLocation;
        if (this.fView == null) {
            return;
        }
        IconTextTooltip tooltip = this.getToolTip();
        tooltip.setText(Language.getString(textKey, defaultText));
        switch (tooltipType) {
            case 2: {
                tooltip.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
                tooltip.setBackground(IconTextTooltip.WARNING);
                break;
            }
            default: {
                tooltip.setIcon(null);
                tooltip.setBackground(IconTextTooltip.DEFAULT);
            }
        }
        tooltip.setAutoHideTimeout(2000);
        tooltip.pack();
        Point point = tooltipLocation = this.fTooltipLocation != null ? this.fTooltipLocation : new Point(100, 100);
        if (this.fView instanceof LogoDrawingView) {
            LogoDrawingView logoDrawingView = (LogoDrawingView)this.fView;
            tooltipLocation = logoDrawingView.getZoomManager().convertModelToDisplayCoordinates(tooltipLocation);
        }
        tooltip.setLocation(tooltipLocation);
        tooltip.setVisible(true);
        ((JComponent)((Object)this.fView)).add(tooltip);
        ((JComponent)((Object)this.fView)).repaint();
        tooltip.startAutoHide();
    }

    public void hideTooltip() {
        this.getToolTip().hideTooltip();
    }

    protected boolean checkRecursionFree(BlockConnectorOwner iF, BlockConnectorOwner oF) {
        if (oF.getBlockConnector().getInputOutputType() != 1) {
            BlockConnectorOwner ablage = oF;
            oF = iF;
            iF = ablage;
        }
        InBlockConnector inConnector = (InBlockConnector)iF.getBlockConnector();
        OutBlockConnector outConnector = (OutBlockConnector)oF.getBlockConnector();
        if (iF.getBlockConnector().getOwner().getWiringDiagram().getProgrammingLanguage().isBinaryInConnectorMultiConnectable()) {
            int i;
            List outConnectors = outConnector.findParallelOutBlockConnectors();
            outConnectors.add(outConnector);
            if (inConnector.getLinkedConnector() != null) {
                if (!outConnectors.contains(inConnector.getLinkedConnector())) {
                    outConnectors.add(inConnector.getLinkedConnector());
                }
                List parals = inConnector.getLinkedConnector().findParallelOutBlockConnectors();
                for (i = 0; i < parals.size(); ++i) {
                    if (outConnectors.contains(parals.get(i))) continue;
                    outConnectors.add(parals.get(i));
                }
            }
            ArrayList<InBlockConnector> inConnectors = new ArrayList<InBlockConnector>();
            inConnectors.add(inConnector);
            for (i = 0; i < outConnectors.size(); ++i) {
                InBlockConnectorEnumeration ins = ((OutBlockConnector)outConnectors.get(i)).getLinkedConnectors();
                while (ins.hasMoreElements()) {
                    InBlockConnector next = ins.nextElement();
                    if (inConnectors.contains(next)) continue;
                    inConnectors.add(next);
                }
            }
            for (i = 0; i < inConnectors.size(); ++i) {
                for (int j = 0; j < outConnectors.size(); ++j) {
                    InBlockConnector inTmp = (InBlockConnector)inConnectors.get(i);
                    OutBlockConnector outTmp = (OutBlockConnector)outConnectors.get(j);
                    if (inTmp.getLinkedConnectorsList().contains(outTmp) || this.checkRecursiveFree(inTmp, outTmp)) continue;
                    return false;
                }
            }
            return true;
        }
        return this.checkRecursiveFree(inConnector, outConnector);
    }

    protected boolean checkRecursiveFree(InBlockConnector inBlockConnector, OutBlockConnector outBlockConnector) {
        Block inputBlock = inBlockConnector.getOwner();
        boolean recursionFree = inputBlock.getWiringDiagram().canConnectWithoutRecursion(outBlockConnector, inBlockConnector);
        if (!recursionFree) {
            this.showTooltip("msg.recursion", "Recursions only allowed via outputs and memory bits", 2);
        }
        return recursionFree;
    }

    private IconTextTooltip getToolTip() {
        if (this.fToolTip == null) {
            this.fToolTip = new IconTextTooltip();
        }
        return this.fToolTip;
    }

    protected boolean checkInputOutputTypeCompatible(Connector start, Connector end) {
        boolean compatible = true;
        if (start == null || end == null) {
            compatible = false;
        } else {
            BlockConnector startBlockConnector = ((BlockConnectorOwner)((Object)start.owner())).getBlockConnector();
            BlockConnector endBlockConnector = ((BlockConnectorOwner)((Object)end.owner())).getBlockConnector();
            boolean bl = compatible = startBlockConnector.getInputOutputType() != endBlockConnector.getInputOutputType();
        }
        if (!compatible) {
            this.showTooltip("msg.incompatibleConnectors", "The connectors are not compatible", 2);
        }
        return compatible;
    }

    public DrawingView getView() {
        return this.fView;
    }

    public void setView(DrawingView view) {
        this.fView = view;
    }

    public void setTooltipLocation(Point tooltipLocation) {
        this.fTooltipLocation = tooltipLocation;
    }
}

