/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.standard.ConnectionSplitter;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class AdvancedConnectionSplitter
extends ConnectionSplitter {
    public static final transient int DISTANCE_Y = 20;
    public static final transient int DISTANCE_X = 17;

    public Point determinCutConnectFigurePosition(CutConnectFigure cutConnectFigure, Point blockConnectorPoint, int labelPosition, DrawingView drawingView) {
        int xPosition = blockConnectorPoint.x + labelPosition * cutConnectFigure.displayBox().width;
        Point startPoint = new Point(xPosition, blockConnectorPoint.y);
        Rectangle testRectangle = cutConnectFigure.displayBox();
        testRectangle.translate(startPoint.x, startPoint.y);
        Vector freePositions = new Vector();
        Point p = null;
        for (int distance = 0; distance <= 8; ++distance) {
            for (int x = 0; x <= distance && (p = this.testPoint(startPoint, x, -distance, labelPosition, testRectangle, drawingView)) == null && (p = this.testPoint(startPoint, x, distance, labelPosition, testRectangle, drawingView)) == null && (p = this.testPoint(startPoint, distance, -x, labelPosition, testRectangle, drawingView)) == null && (p = this.testPoint(startPoint, distance, x, labelPosition, testRectangle, drawingView)) == null; ++x) {
            }
            if (p != null) break;
        }
        Point bestPoint = p == null ? startPoint : p;
        cutConnectFigure.moveBy(bestPoint.x, bestPoint.y);
        return bestPoint;
    }

    protected boolean justContainsLines(Vector intersectedFigures) {
        Enumeration e = intersectedFigures.elements();
        boolean justContainsLines = true;
        while (e.hasMoreElements()) {
            if (e.nextElement() instanceof ConnectionFigure) continue;
            justContainsLines = false;
            break;
        }
        return justContainsLines;
    }

    public boolean testArea(Rectangle testRectangle, Drawing drawing) {
        LogoDrawing logoDrawing = (LogoDrawing)drawing;
        Vector intersected = logoDrawing.getFiguresIntersectRectangle(testRectangle);
        return intersected.isEmpty();
    }

    protected boolean testBounds(Rectangle testRectangle, DrawingView drawingView) {
        Rectangle drawingViewBounds = new Rectangle(0, 0, drawingView.getSize().width, drawingView.getSize().height);
        return SwingUtilities.isRectangleContainingRectangle(drawingViewBounds, testRectangle);
    }

    public boolean testLine(Point startPoint, Point endPoint, Drawing drawing) {
        return true;
    }

    public Point testPoint(Point startPoint, int dx, int dy, int labelPosition, Rectangle testRectangle, DrawingView drawingView) {
        Point tempPoint = new Point(startPoint.x + dx * 17 * labelPosition, startPoint.y + dy * 20);
        testRectangle.translate(dx * 17 * labelPosition, dy * 20);
        if (this.testBounds(testRectangle, drawingView) && this.testArea(testRectangle, drawingView.drawing()) && this.testLine(startPoint, tempPoint, drawingView.drawing())) {
            testRectangle.translate(-dx * 17 * labelPosition, -dy * 20);
            return tempPoint;
        }
        testRectangle.translate(-dx * 17 * labelPosition, -dy * 20);
        return null;
    }
}

