/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.block.AnalogInputBlock;
import DE.siemens.ad.logo.model.block.AnalogMarkerBlock;
import DE.siemens.ad.logo.model.block.AnalogOutputBlock;
import DE.siemens.ad.logo.model.block.HighBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.KeyInputBlock;
import DE.siemens.ad.logo.model.block.LowBlock;
import DE.siemens.ad.logo.model.block.MarkerBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterInputBlock;
import DE.siemens.ad.logo.model.block.TDFunctionKeyInputBlock;
import DE.siemens.ad.logo.util.Util;
import java.util.Dictionary;
import java.util.Hashtable;

public class ProcessImageParser {
    protected int[] fProcessImage;
    protected int[] fBlockResultImage;
    protected Dictionary fOffsetDictionary;

    public ProcessImageParser(Hardware hardware) {
        this.setHardware(hardware);
    }

    protected Dictionary createOffsetDictionary(Hardware hardware) {
        Hashtable<Class<AnalogMarkerBlock>, Integer> offsetDictionary = new Hashtable<Class<AnalogMarkerBlock>, Integer>(10);
        int index = 0;
        offsetDictionary.put(InputBlock.class, new Integer(index));
        index += 3;
        if (hardware.isBlockNameAvailable("TDFunctionKeyInput")) {
            offsetDictionary.put(TDFunctionKeyInputBlock.class, new Integer(index));
            ++index;
        }
        offsetDictionary.put(OutputBlock.class, new Integer(index));
        offsetDictionary.put(MarkerBlock.class, new Integer(index += 2));
        offsetDictionary.put(ShiftRegisterInputBlock.class, new Integer(index += (hardware.getMaxResource(10) + 7) / 8));
        offsetDictionary.put(KeyInputBlock.class, new Integer(++index));
        offsetDictionary.put(AnalogInputBlock.class, new Integer(++index));
        offsetDictionary.put(AnalogOutputBlock.class, new Integer(index += 16));
        offsetDictionary.put(AnalogMarkerBlock.class, new Integer(index += 4));
        index += 12;
        return offsetDictionary;
    }

    public void setProcessImage(int[] ProcessImage) {
        this.fProcessImage = ProcessImage;
    }

    protected int getOffsetInProcessImage(Block block) {
        Class<?> blockClass;
        for (blockClass = block.getClass(); this.fOffsetDictionary.get(blockClass) == null && blockClass != Object.class; blockClass = blockClass.getSuperclass()) {
        }
        int offset = -1;
        if (blockClass != Object.class) {
            offset = (Integer)this.fOffsetDictionary.get(blockClass);
        }
        return offset;
    }

    protected boolean getDigitalValue(Block block) {
        boolean value = false;
        int offsetInImage = this.getOffsetInProcessImage(block);
        if (offsetInImage == -1) {
            value = this.getBlockValue(block);
        }
        if (offsetInImage >= 0) {
            value = this.getProcessImageValue(block, offsetInImage);
        }
        return value;
    }

    protected boolean getProcessImageValue(Block block, int offsetInImage) {
        int bitNr;
        int blockIndex = block.getNumber() - 1;
        int byteNr = blockIndex / 8 + offsetInImage;
        boolean value = (this.fProcessImage[byteNr] & 1 << (bitNr = blockIndex % 8)) != 0;
        return value;
    }

    public double getAnalogValue(Block block) {
        int offsetInImage = this.getOffsetInProcessImage(block);
        int byteNr = (block.getNumber() - 1) * 2 + offsetInImage;
        double value = Util.makeSignedWord(this.fProcessImage[byteNr + 1], this.fProcessImage[byteNr]);
        return value;
    }

    private void dumpProcessImage() {
        int i;
        System.out.println("Proze\u00dfabbild:");
        for (i = 0; i < this.fProcessImage.length; ++i) {
            System.out.print(Util.addLeadingZeros(Integer.toString(i), 2) + "  ");
        }
        System.out.println();
        for (i = 0; i < this.fProcessImage.length; ++i) {
            System.out.print(Util.addLeadingZeros(Integer.toString(this.fProcessImage[i]), 3) + " ");
        }
        System.out.println();
    }

    public void setBlockResultImage(int[] blockResultImage) {
        this.fBlockResultImage = blockResultImage;
    }

    protected boolean getBlockValue(Block block) {
        int bitNr;
        if (block.getClass() == HighBlock.class) {
            return true;
        }
        if (block.getClass() == LowBlock.class) {
            return false;
        }
        int byteNr = (block.getNumber() - 1) / 8;
        boolean value = (this.fBlockResultImage[byteNr] & 1 << (bitNr = (block.getNumber() - 1) % 8)) != 0;
        return value;
    }

    public void setHardware(Hardware hardware) {
        this.fOffsetDictionary = this.createOffsetDictionary(hardware);
    }
}

