/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.kop.app.KopProcessImageParser;
import DE.siemens.ad.kop.model.WiringDiagramKop;
import DE.siemens.ad.kop.model.block.ContactBlock;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.AnalogInputSimulationParameter;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.InputSimulationParameter;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.util.DataExchange;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.pdraw.simulation.ActualValueVisitor;
import DE.siemens.ad.pdraw.simulation.OnlineTestProtocolHandler;
import DE.siemens.ad.pdraw.simulation.ProcessImageParser;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class OnlineTestInterpreter
extends Interpreter {
    private DataTransfer fDataTransfer;
    protected List fOutputBlocks;
    protected List fIMOutputBlocks;
    protected List fInputBlocks;
    public static final int TRANSMISSION_ERROR = 1;
    protected Vector fObservedBinaryConnectors = new Vector();
    protected ValueDispatcher fValueDispatcher;
    protected OnlineTestProtocolHandler fOnlineTestProtocolHandler;
    protected DataExchange fTelegramBuffer;

    public void prepareInterpreter() {
        this.fOutputBlocks = this.fWiringDiagram.getOutputBlocks();
        this.fIMOutputBlocks = this.fWiringDiagram instanceof WiringDiagramKop ? ((WiringDiagramKop)this.fWiringDiagram).getIMOutputBlocks() : new Vector();
        this.fInputBlocks = this.fWiringDiagram.getInputBlocks();
        this.fObservedBinaryConnectors.removeAllElements();
        Enumeration enumeration = this.fWiringDiagram.getAllOutConnectors().elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof BinaryOutBlockConnector)) continue;
            this.fObservedBinaryConnectors.add(o);
        }
        if (this.fWiringDiagram instanceof WiringDiagramKop) {
            this.fObservedBinaryConnectors.add(((WiringDiagramKop)this.fWiringDiagram).getLeftPowerRailBlock().getOutConnector(0));
        }
        Hardware hardware = this.fWiringDiagram.getHardware();
        int checksum = -1;
        try {
            checksum = ((Logo)hardware).getChecksum(this.fWiringDiagram);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fOnlineTestProtocolHandler.setChecksum(checksum);
        this.fWiringDiagram.netOn(this, true);
    }

    public OnlineTestInterpreter(WiringDiagram wiringDiagram) {
        this.init(wiringDiagram);
    }

    private void init(WiringDiagram wiringDiagram) {
        this.fWiringDiagram = wiringDiagram;
        this.fTelegramBuffer = new DataExchange();
        this.fOnlineTestProtocolHandler = new OnlineTestProtocolHandler(this.fTelegramBuffer);
    }

    public void setWiringDiagram(WiringDiagram wiringDiagram) {
        this.fWiringDiagram = wiringDiagram;
    }

    public StateMachine getStateMachine() {
        return this.fOnlineTestProtocolHandler.getStateMachine();
    }

    public void start() {
        this.fOnlineTestProtocolHandler.setRequestedBlocks(new Vector());
        this.fOnlineTestProtocolHandler.setDataTransfer(this.fDataTransfer);
        this.fOnlineTestProtocolHandler.getStateMachine().start();
        new Thread((Runnable)this.getValueDispatcher(), "ValueDispatcher").start();
    }

    public long getCurrentSimulationClockTime() {
        return 0L;
    }

    public long getCurrentSimulationTimerTime() {
        return 0L;
    }

    public DataTransfer getDataTransfer() {
        return this.fDataTransfer;
    }

    public void setDataTransfer(DataTransfer dataTransfer) {
        this.fDataTransfer = dataTransfer;
    }

    public ValueDispatcher getValueDispatcher() {
        if (this.fValueDispatcher == null) {
            this.fValueDispatcher = new ValueDispatcher(this.fTelegramBuffer, this.fDataTransfer.getHardware(), this.fWiringDiagram);
        } else {
            this.fValueDispatcher.init(this.fTelegramBuffer, this.fDataTransfer.getHardware(), this.fWiringDiagram);
        }
        return this.fValueDispatcher;
    }

    public void setRequestedBlocks(List requestedBlocks) {
        this.fOnlineTestProtocolHandler.setRequestedBlocks(requestedBlocks);
    }

    public class ValueDispatcher
    extends Thread {
        protected DataExchange fTelegramExchange;
        protected OnlineTestTelegramBuffer fTelegram;
        protected ProcessImageParser fProcessImageParser;
        protected ProcessImageParser fProcessImageParserFup;
        protected KopProcessImageParser fProcessImageParserKop;
        protected ActualValueVisitor fActualValueVisitor;

        public ValueDispatcher(DataExchange telegramBuffer, Hardware hardware, WiringDiagram wd) {
            this.init(telegramBuffer, hardware, wd);
        }

        public void init(DataExchange telegramBuffer, Hardware hardware, WiringDiagram wd) {
            this.fTelegramExchange = telegramBuffer;
            if (wd instanceof WiringDiagramKop) {
                if (this.fProcessImageParserKop == null) {
                    this.fProcessImageParserKop = new KopProcessImageParser(hardware);
                } else {
                    this.fProcessImageParserKop.setHardware(hardware);
                }
                this.fProcessImageParser = this.fProcessImageParserKop;
            } else {
                if (this.fProcessImageParserFup == null) {
                    this.fProcessImageParserFup = new ProcessImageParser(hardware);
                } else {
                    this.fProcessImageParserFup.setHardware(hardware);
                }
                this.fProcessImageParser = this.fProcessImageParserFup;
            }
            if (this.fActualValueVisitor == null) {
                this.fActualValueVisitor = new ActualValueVisitor();
            }
        }

        public void run() {
            int[] buffer = null;
            while (OnlineTestInterpreter.this.getStateMachine().isRunning()) {
                if (this != OnlineTestInterpreter.this.fValueDispatcher) {
                    return;
                }
                this.fTelegram = (OnlineTestTelegramBuffer)this.fTelegramExchange.getData();
                buffer = this.fTelegram.getBytes();
                if (buffer == null) continue;
                this.parseSimulationTelegram(buffer);
                this.dispatchValues();
                OnlineTestInterpreter.this.fireCycleFinishedEvent(true);
            }
        }

        private void dispatchValues() {
            boolean findChanged;
            for (BinaryOutBlockConnector outBlockConnector : OnlineTestInterpreter.this.fObservedBinaryConnectors) {
                boolean binaryValue = this.fProcessImageParser.getDigitalValue(outBlockConnector.getOwner());
                outBlockConnector.setBinaryValue(binaryValue);
            }
            for (OutputBlock outputBlock : OnlineTestInterpreter.this.fOutputBlocks) {
                if (outputBlock.getOutConnectorCount() <= 0) continue;
                if (outputBlock.getOutConnector(0).getSignalType() == 0) {
                    boolean binaryValue = this.fProcessImageParser.getDigitalValue(outputBlock);
                    outputBlock.setBinaryValue(binaryValue);
                }
                if (outputBlock.getOutConnector(0).getSignalType() != 1) continue;
                double analogValue = this.fProcessImageParser.getAnalogValue(outputBlock);
                outputBlock.setAnalogValue(analogValue);
            }
            for (InputBlock inputBlock : OnlineTestInterpreter.this.fInputBlocks) {
                AbstractInputSimulationParameter simulationParameter = (AbstractInputSimulationParameter)inputBlock.getSimulationParameter();
                if (simulationParameter instanceof InputSimulationParameter) {
                    boolean binaryValue = this.fProcessImageParser.getDigitalValue(inputBlock);
                    simulationParameter.setBinaryValue(binaryValue);
                }
                if (!(simulationParameter instanceof AnalogInputSimulationParameter)) continue;
                double analogValue = this.fProcessImageParser.getAnalogValue(inputBlock);
                simulationParameter.setInternAnalogValue(analogValue);
            }
            int times = 0;
            do {
                boolean binaryValue;
                Iterator i = OnlineTestInterpreter.this.fIMOutputBlocks.iterator();
                findChanged = false;
                while (i.hasNext()) {
                    OutputBlock outputBlock = (OutputBlock)i.next();
                    if (outputBlock.getOutConnectorCount() <= 0) continue;
                    binaryValue = ((KopProcessImageParser)this.fProcessImageParser).getIMOutputValue(outputBlock);
                    if (outputBlock.getBinaryValue() == binaryValue) continue;
                    outputBlock.setBinaryValue(binaryValue);
                    findChanged = true;
                    break;
                }
                for (BinaryOutBlockConnector outBlockConnector : OnlineTestInterpreter.this.fObservedBinaryConnectors) {
                    if (!(outBlockConnector.getOwner() instanceof ContactBlock) || !((KopProcessImageParser)this.fProcessImageParser).isInternalMarker(((ContactBlock)outBlockConnector.getOwner()).getReferencedOutConnector().getOwner())) continue;
                    binaryValue = this.fProcessImageParser.getDigitalValue(outBlockConnector.getOwner());
                    if (outBlockConnector.getBinaryValue() == binaryValue) continue;
                    outBlockConnector.setBinaryValue(binaryValue);
                    findChanged = true;
                }
                if (++times <= 32) continue;
                System.err.println("Dispatch Values for IM exit. Too deep recursion.");
                break;
            } while (findChanged);
            HashMap watchedPIDBlockRefMap = new HashMap();
            for (Block watchedBlock : this.fTelegram.getWatchedBlocks()) {
                AnalogOrBlockReference ref;
                if (!(watchedBlock instanceof PIDBlock) || !(ref = ((PIDParameter)((PIDBlock)watchedBlock).getParameter()).getSetpoint()).isReference()) continue;
                if (watchedPIDBlockRefMap.containsKey(ref.getReferenceToBlock())) {
                    ((List)watchedPIDBlockRefMap.get(ref.getReferenceToBlock())).add(watchedBlock);
                    continue;
                }
                ArrayList<Block> list = new ArrayList<Block>();
                list.add(watchedBlock);
                watchedPIDBlockRefMap.put(ref.getReferenceToBlock(), list);
            }
            for (Block watchedBlock : this.fTelegram.getWatchedBlocks()) {
                String currentParameterString = (String)watchedBlock.acceptVisitor(this.fActualValueVisitor);
                watchedBlock.getParameter().setCurrentParameterText(currentParameterString);
                if (!watchedPIDBlockRefMap.containsKey(watchedBlock)) continue;
                List refPIDBlock = (List)watchedPIDBlockRefMap.get(watchedBlock);
                Iterator PIDBlockIter = refPIDBlock.iterator();
                while (PIDBlockIter.hasNext()) {
                    ((PIDBlock)PIDBlockIter.next()).setOnlineTestSP(Integer.valueOf(currentParameterString.trim()));
                }
            }
        }

        protected void parseSimulationTelegram(int[] buffer) {
            int blockResultValuesLength = buffer[2];
            int processImageLength = buffer[3];
            int actValueLength = buffer[4];
            int[] blockResultBuffer = new int[blockResultValuesLength];
            System.arraycopy(buffer, 5, blockResultBuffer, 0, blockResultValuesLength);
            int[] processImageBuffer = new int[processImageLength];
            System.arraycopy(buffer, 5 + blockResultValuesLength, processImageBuffer, 0, processImageLength);
            int[] actValueBuffer = new int[actValueLength];
            System.arraycopy(buffer, 5 + blockResultValuesLength + processImageLength, actValueBuffer, 0, actValueLength);
            this.fProcessImageParser.setProcessImage(processImageBuffer);
            this.fProcessImageParser.setBlockResultImage(blockResultBuffer);
            this.fActualValueVisitor.setBuffer(actValueBuffer);
        }
    }

    public static class OnlineTestTelegramBuffer {
        private int[] fBytes;
        private List fWatchedBlocks;

        public OnlineTestTelegramBuffer(int[] bytes, List watchedBlocks) {
            this.fBytes = bytes;
            this.fWatchedBlocks = watchedBlocks;
        }

        public int[] getBytes() {
            return this.fBytes;
        }

        public List getWatchedBlocks() {
            return this.fWatchedBlocks;
        }
    }
}

