/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.app.ActionOwner;
import DE.siemens.ad.logo.app.action.ActionFactory;
import DE.siemens.ad.logo.app.action.ActionManager;
import DE.siemens.ad.logo.app.action.LogoToggleAction;
import DE.siemens.ad.logo.app.comp.RolloverButtonToolBar;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.StateMachine;
import DE.siemens.ad.pdraw.simulation.OnlineTestInterpreter;
import DE.siemens.ad.pdraw.simulation.OnlineTestProtocolHandler;
import DE.siemens.ad.pdraw.simulation.SimulationManager;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JToolBar;

public class OnlineTestControl
implements ActionOwner {
    private SimulationManager fSimulationManager;
    private ActionFactory fActionFactory;
    private ActionManager fActionManager;
    private JToolBar fToolbar;
    private JLabel fConnectedLabel;

    public OnlineTestControl(SimulationManager simulationManager) {
        this.fSimulationManager = simulationManager;
        this.createToolbar();
        this.getInterpreter().getStateMachine().addStateChangedListener(new InterpreterStateChangedHandler());
    }

    public ActionFactory getActionFactory() {
        if (this.fActionFactory == null) {
            this.fActionFactory = new ActionFactory(this);
        }
        return this.fActionFactory;
    }

    public ActionManager getActionManager() {
        if (this.fActionManager == null) {
            this.fActionManager = new ActionManager(this);
        }
        return this.fActionManager;
    }

    public Window getWindow() {
        return null;
    }

    private void createToolbar() {
        ActionFactory actionFactory = this.getActionFactory();
        this.fToolbar = new RolloverButtonToolBar();
        this.fConnectedLabel = new JLabel(Global.getIcon("OnlineTest.gif"));
        this.fConnectedLabel.setEnabled(false);
        this.fToolbar.add(actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StartStopWatchingAction"));
        this.fToolbar.addSeparator();
        this.fToolbar.add(actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StartDeviceAction"));
        this.fToolbar.add(actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StopDeviceAction"));
    }

    public JToolBar getToolbar() {
        return this.fToolbar;
    }

    public OnlineTestInterpreter getInterpreter() {
        return (OnlineTestInterpreter)this.fSimulationManager.getInterpreter();
    }

    protected class InterpreterStateChangedHandler
    implements StateMachine.StateChangedListener {
        protected InterpreterStateChangedHandler() {
        }

        public void finalStateReached(StateMachine stateMachine, StateMachine.State finalState) {
        }

        public void stateChanged(StateMachine stateMachine, StateMachine.State newState) {
            ActionFactory actionFactory = OnlineTestControl.this.getActionFactory();
            if (newState == stateMachine.getState(OnlineTestProtocolHandler.ConnectedNotTestingRunning.class) || newState == stateMachine.getState(OnlineTestProtocolHandler.ConnectedNotTestingStop.class) || newState == stateMachine.getState(OnlineTestProtocolHandler.ConnectedTesting.class)) {
                OnlineTestControl.this.fConnectedLabel.setEnabled(true);
                OnlineTestControl.this.fConnectedLabel.setToolTipText(Language.getString("onlineTestControl.connected"));
                actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StartStopWatchingAction").setActivated(true);
            } else {
                OnlineTestControl.this.fConnectedLabel.setEnabled(false);
                OnlineTestControl.this.fConnectedLabel.setToolTipText(Language.getString("onlineTestControl.noConnection"));
                actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StartStopWatchingAction").setActivated(false);
            }
            boolean runningEnabled = newState == stateMachine.getState(OnlineTestProtocolHandler.ConnectedNotTestingStop.class);
            boolean stopEnabled = newState == stateMachine.getState(OnlineTestProtocolHandler.ConnectedNotTestingRunning.class) || newState == stateMachine.getState(OnlineTestProtocolHandler.ConnectedTesting.class);
            actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StartDeviceAction").setActivated(runningEnabled);
            actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StopDeviceAction").setActivated(stopEnabled);
            boolean testing = newState == stateMachine.getState(OnlineTestProtocolHandler.ConnectedTesting.class);
            ((LogoToggleAction)actionFactory.getAction("DE.siemens.ad.pdraw.simulation.StartStopWatchingAction")).setSelected(testing);
        }
    }
}

