/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.model.AnalogOutBlockConnector;
import DE.siemens.ad.logo.model.BinaryOutBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.Timer;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.HiResTimer;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.StateMachine;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class OfflineInterpreter
extends Interpreter {
    protected List fOutputBlocks;
    protected Vector fObservedBinaryConnectors = new Vector();
    protected Vector fObservedAnalogConnectors = new Vector();
    protected boolean[] fBinaryValues = null;
    protected double[] fAnalogValues = null;
    protected Vector fBlockParameterVector = new Vector();
    protected Vector fParameterStringVector = new Vector();
    protected transient boolean fNotifyListener = true;
    public static final int INCREMENTAL_TIME = 0;
    private int fCyclesToRun;
    private Timer fStepTimer;
    private SimulationTimeManagement fTimerTimeManagement;
    private SimulationTimeManagement fClockTimeManagement;
    public static final int ABSOLUTE_TIME = 1;
    private int fCycles;

    public OfflineInterpreter(WiringDiagram wiringDiagram) {
        this.fWiringDiagram = wiringDiagram;
        this.fInterpreterListeners = new Vector();
        this.fTimerTimeManagement = new SimulationTimeManagement();
        this.fClockTimeManagement = new SimulationTimeManagement();
        Running running = new Running();
        TimerStepping timerStepping = new TimerStepping();
        CycleStepping cycleStepping = new CycleStepping();
        Suspended suspended = new Suspended();
        Stopped stopped = new Stopped();
        RunningNetOff runningNetOff = new RunningNetOff();
        SuspendedNetOff suspendedNetOff = new SuspendedNetOff();
        CycleSteppingNetOff cycleSteppingNetOff = new CycleSteppingNetOff();
        TimerSteppingNetOff timerSteppingNetOff = new TimerSteppingNetOff();
        Terminated terminated = new Terminated();
        StoppedNetOff stoppedNetOff = new StoppedNetOff();
        StateMachine.State[] states = new OfflineInterpreterState[]{running, timerStepping, cycleStepping, suspended, stopped, runningNetOff, suspendedNetOff, cycleSteppingNetOff, timerSteppingNetOff, terminated, stoppedNetOff};
        ArrayList<Terminated> endStates = new ArrayList<Terminated>(1);
        endStates.add(terminated);
        this.fStateMachine = new StateMachine("OfflineInterpreter", states, running, endStates, true);
        this.fStateMachine.setParallelPriority(1);
        this.fStateMachine.setInputHandler(new InputHandler());
    }

    protected void checkParameterValues() {
        int count = this.fBlockParameterVector.size();
        for (int loop = 0; !this.fNotifyListener && loop < count; ++loop) {
            BlockParameter blockParameter = (BlockParameter)this.fBlockParameterVector.elementAt(loop);
            String currentParameterText = blockParameter.getCurrentParameterText();
            if (((String)this.fParameterStringVector.elementAt(loop)).equals(currentParameterText)) continue;
            this.fParameterStringVector.set(loop, currentParameterText);
            this.fNotifyListener = true;
        }
    }

    protected void initBlockParameter() {
        Vector blocks = this.fWiringDiagram.getBlocks();
        int count = blocks.size();
        for (int i = 0; i < count; ++i) {
            BlockParameter blockParameter;
            Block block = (Block)blocks.elementAt(i);
            if (!(block instanceof SpecialBlock) || (blockParameter = block.getParameter()) == null) continue;
            this.fBlockParameterVector.addElement(blockParameter);
            this.fParameterStringVector.addElement("");
        }
    }

    protected StateMachine.State getInitialInterpreterState() {
        if (LogoProperties.instance().getBooleanProperty("simulation.startAutomatically", false)) {
            return this.getStateMachine().getState(Running.class);
        }
        return this.getStateMachine().getState(Stopped.class);
    }

    private boolean runOneCycle() {
        int i;
        boolean someValueChanged = false;
        this.fWiringDiagram.invalidateOutConnectors();
        ++this.fCycles;
        Iterator outputIterator = this.fOutputBlocks.iterator();
        for (i = 0; i < this.fObservedBinaryConnectors.size(); ++i) {
            boolean binaryValue = ((BinaryOutBlockConnector)this.fObservedBinaryConnectors.elementAt(i)).calculateBinaryValue();
            if (binaryValue != this.fBinaryValues[i]) {
                someValueChanged = true;
            }
            this.fBinaryValues[i] = binaryValue;
        }
        for (i = 0; i < this.fObservedAnalogConnectors.size(); ++i) {
            double analogValue = ((AnalogOutBlockConnector)this.fObservedAnalogConnectors.elementAt(i)).calculateAnalogValue();
            if (analogValue != this.fAnalogValues[i]) {
                someValueChanged = true;
            }
            this.fAnalogValues[i] = analogValue;
        }
        for (OutputBlock outputBlock : this.fOutputBlocks) {
            outputBlock.endCalculation();
        }
        if (!someValueChanged) {
            this.checkParameterValues();
        }
        this.fireCycleFinishedEvent(someValueChanged || this.fNotifyListener);
        return someValueChanged;
    }

    public long getCurrentSimulationTimerTime() {
        return this.fTimerTimeManagement.getCurrentSimulationTime();
    }

    public void prepareInterpreter() {
        this.fOutputBlocks = this.fWiringDiagram.getOutputBlocks();
        this.fObservedBinaryConnectors.removeAllElements();
        this.fObservedAnalogConnectors.removeAllElements();
        Enumeration enumeration = this.fWiringDiagram.getAllOutConnectors().elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (o instanceof BinaryOutBlockConnector) {
                this.fObservedBinaryConnectors.add(o);
                continue;
            }
            if (!(o instanceof AnalogOutBlockConnector)) continue;
            this.fObservedAnalogConnectors.add(o);
        }
        this.initBlockParameter();
        this.setShiftRegisterValue((byte)0);
    }

    public long getCurrentSimulationClockTime() {
        return this.fClockTimeManagement.getCurrentSimulationTime();
    }

    public int getCyclesToRun() {
        return this.fCyclesToRun;
    }

    public void setCyclesToRun(int cyclesToRun) {
        this.fCyclesToRun = cyclesToRun;
    }

    public Timer getStepTimer() {
        return this.fStepTimer;
    }

    public void setStepTimer(Timer stepTimer) {
        this.fStepTimer = stepTimer;
    }

    public void setTimeFactor(double timeFactor) {
        this.fClockTimeManagement.setTimeFactor(timeFactor);
        this.fTimerTimeManagement.setTimeFactor(timeFactor);
    }

    public double getTimeFactor() {
        return this.fClockTimeManagement.getTimeFactor();
    }

    public void setCurrentSimulationTime(long currentSimulationTime) {
        this.fClockTimeManagement.setCurrentSimulationTime(currentSimulationTime);
        this.fireCycleFinishedEvent(false);
    }

    public void start() {
        this.fNotifyListener = true;
        this.fBinaryValues = new boolean[this.fObservedBinaryConnectors.size()];
        this.fAnalogValues = new double[this.fObservedAnalogConnectors.size()];
        this.fWiringDiagram.netOn(this, true);
        this.fTimerTimeManagement.initTimeManagement();
        this.fClockTimeManagement.initTimeManagement();
        this.fStateMachine.setStartState(this.getInitialInterpreterState());
        this.fStateMachine.start();
    }

    public static class SimulationTimeManagement {
        private long fCurrentRealTime;
        private long fCurrentSimulationTime;
        private HiResTimer fHiResTimer;
        private long fRealTimeOffset;
        private long fStartRealTime;
        private long fStartVirtualTime;
        private long fSuspendedRealTime;
        private long fSuspendRealTime;
        private double fTimeFactor = 1.0;
        protected int fTimeMode;

        public SimulationTimeManagement() {
            this.initTimeManagement();
        }

        private synchronized void calculateCurrentTimes() {
            if (this.fTimeMode == 0) {
                int increment = (int)(10.0 / this.fTimeFactor);
                this.fCurrentRealTime += (long)increment;
                this.fSuspendedRealTime -= (long)increment;
            } else {
                this.fCurrentRealTime = this.getSystemTime() - this.fSuspendedRealTime + this.fRealTimeOffset;
            }
            this.fCurrentSimulationTime = (long)((double)(this.fCurrentRealTime - this.fStartRealTime) * this.fTimeFactor) + this.fStartVirtualTime;
        }

        public synchronized long getCurrentSimulationTime() {
            return this.fCurrentSimulationTime;
        }

        private long getSystemTime() {
            if (this.fHiResTimer == null) {
                this.fHiResTimer = new HiResTimer();
                this.fHiResTimer.start();
            }
            return this.fHiResTimer.getCurrentTime();
        }

        public double getTimeFactor() {
            return this.fTimeFactor;
        }

        public void initTimeManagement() {
            this.fStartRealTime = this.fCurrentRealTime = this.getSystemTime();
            this.fStartVirtualTime = this.fCurrentRealTime;
            this.fSuspendedRealTime = 0L;
            this.fTimeFactor = 1.0;
            this.fTimeMode = 1;
            this.calculateCurrentTimes();
        }

        public int getTimeMode() {
            return this.fTimeMode;
        }

        public void setCurrentSimulationTime(long newTime) {
            this.fRealTimeOffset += (long)((double)(newTime - this.getCurrentSimulationTime()) / this.fTimeFactor);
            this.calculateCurrentTimes();
        }

        public void setTimeFactor(double factor) {
            if (factor < 0.0) {
                throw new IllegalArgumentException("Simulation time factor must be greater or equal 0.");
            }
            this.fStartVirtualTime = this.getCurrentSimulationTime();
            this.fStartRealTime = this.fCurrentRealTime;
            this.fTimeFactor = Math.max(factor, 0.0);
        }

        public void setTimeMode(int timeMode) {
            this.fTimeMode = timeMode;
        }

        public void suspend() {
            this.fSuspendRealTime = this.fCurrentRealTime;
        }

        public void resume() {
            this.calculateCurrentTimes();
            this.fSuspendedRealTime += this.fCurrentRealTime - this.fSuspendRealTime;
        }
    }

    public static class InputHandler
    extends StateMachine.InputHandler {
        public static final String TERMINATE = "terminate";
        public static final String CYCLE_STEP = "cycleStep";
        public static final String NET_OFF = "netOff";
        public static final String NET_ON = "netOn";
        public static final String RESUME = "resume";
        public static final String START = "start";
        public static final String STOP = "stop";
        public static final String SUSPEND = "suspend";
        public static final String TIMER_STEP = "timerStep";

        public Object[] getInputSymbols() {
            return new Object[]{CYCLE_STEP, NET_OFF, NET_ON, RESUME, START, STOP, SUSPEND, TERMINATE, TIMER_STEP};
        }

        public StateMachine.State handleInput(Object input, StateMachine.State currentState) {
            OfflineInterpreterState offlineInterpreterState = (OfflineInterpreterState)currentState;
            StateMachine.State nextState = null;
            if (input == CYCLE_STEP) {
                nextState = offlineInterpreterState.cycleStep();
            } else if (input == TIMER_STEP) {
                nextState = offlineInterpreterState.timerStep();
            } else if (input == NET_ON) {
                nextState = offlineInterpreterState.netOn();
            } else if (input == NET_OFF) {
                nextState = offlineInterpreterState.netOff();
            } else if (input == START) {
                nextState = offlineInterpreterState.start();
            } else if (input == STOP) {
                nextState = offlineInterpreterState.stop();
            } else if (input == SUSPEND) {
                nextState = offlineInterpreterState.suspend();
            } else if (input == RESUME) {
                nextState = offlineInterpreterState.resume();
            } else if (input == TERMINATE) {
                nextState = offlineInterpreterState.terminate();
            } else if (input == null) {
                nextState = offlineInterpreterState.emptyInput();
            }
            return nextState;
        }
    }

    public class TimerSteppingNetOff
    extends OfflineInterpreterState {
        public StateMachine.State netOn() {
            OfflineInterpreter.this.fTimerTimeManagement.resume();
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(TimerStepping.class);
        }

        public StateMachine.State emptyInput() {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this;
        }
    }

    public class CycleSteppingNetOff
    extends OfflineInterpreterState {
        public StateMachine.State netOn() {
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(CycleStepping.class);
        }

        public StateMachine.State emptyInput() {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this;
        }
    }

    public class StoppedNetOff
    extends OfflineInterpreterState {
        public StateMachine.State netOn() {
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(Stopped.class);
        }

        public StateMachine.State emptyInput() {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this;
        }
    }

    public class SuspendedNetOff
    extends OfflineInterpreterState {
        public StateMachine.State netOn() {
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(Suspended.class);
        }

        public StateMachine.State emptyInput() {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this;
        }
    }

    public class RunningNetOff
    extends OfflineInterpreterState {
        public StateMachine.State netOn() {
            OfflineInterpreter.this.fTimerTimeManagement.resume();
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(Running.class);
        }

        public StateMachine.State emptyInput() {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this;
        }
    }

    public class Stopped
    extends OfflineInterpreterState {
        public StateMachine.State start() {
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(Running.class);
        }

        public StateMachine.State timerStep() {
            OfflineInterpreter.this.fTimerTimeManagement.setTimeMode(1);
            OfflineInterpreter.this.fTimerTimeManagement.calculateCurrentTimes();
            OfflineInterpreter.this.fStepTimer.start();
            return this.getState(TimerStepping.class);
        }

        public StateMachine.State cycleStep() {
            OfflineInterpreter.this.fWiringDiagram.initParameter(OfflineInterpreter.this, false);
            OfflineInterpreter.this.fTimerTimeManagement.setTimeMode(0);
            return this.getState(CycleStepping.class);
        }

        public StateMachine.State emptyInput() {
            OfflineInterpreter.this.fClockTimeManagement.calculateCurrentTimes();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this;
        }

        public StateMachine.State netOff() {
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(StoppedNetOff.class);
        }
    }

    public class Suspended
    extends OfflineInterpreterState {
        public StateMachine.State stop() {
            return this.getState(Stopped.class);
        }

        public StateMachine.State resume() {
            OfflineInterpreter.this.fTimerTimeManagement.setTimeMode(1);
            OfflineInterpreter.this.fTimerTimeManagement.resume();
            return this.getState(Running.class);
        }

        public StateMachine.State netOff() {
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(SuspendedNetOff.class);
        }

        public StateMachine.State timerStep() {
            OfflineInterpreter.this.fStepTimer.start();
            OfflineInterpreter.this.fTimerTimeManagement.resume();
            return this.getState(TimerStepping.class);
        }

        public StateMachine.State cycleStep() {
            OfflineInterpreter.this.fTimerTimeManagement.setTimeMode(0);
            return this.getState(CycleStepping.class);
        }

        public StateMachine.State emptyInput() {
            OfflineInterpreter.this.fClockTimeManagement.calculateCurrentTimes();
            this.sleep(50L);
            return this;
        }
    }

    public class CycleStepping
    extends OfflineInterpreterState {
        public StateMachine.State stop() {
            return this.getState(Stopped.class);
        }

        public StateMachine.State suspend() {
            OfflineInterpreter.this.fTimerTimeManagement.suspend();
            return this.getState(Suspended.class);
        }

        public StateMachine.State terminate() {
            return this.getState(Terminated.class);
        }

        public StateMachine.State netOff() {
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(CycleSteppingNetOff.class);
        }

        public StateMachine.State emptyInput() {
            StateMachine.State nextState = this;
            OfflineInterpreter.this.fTimerTimeManagement.calculateCurrentTimes();
            OfflineInterpreter.this.fClockTimeManagement.calculateCurrentTimes();
            OfflineInterpreter.this.runOneCycle();
            OfflineInterpreter.this.fCyclesToRun--;
            if (OfflineInterpreter.this.fCyclesToRun == 0) {
                OfflineInterpreter.this.fTimerTimeManagement.setTimeMode(1);
                OfflineInterpreter.this.fTimerTimeManagement.suspend();
                nextState = this.getState(Suspended.class);
            }
            this.sleep(5L);
            return nextState;
        }
    }

    public class Terminated
    extends OfflineInterpreterState {
    }

    public class TimerStepping
    extends OfflineInterpreterState {
        public StateMachine.State stop() {
            return this.getState(Stopped.class);
        }

        public StateMachine.State suspend() {
            OfflineInterpreter.this.fTimerTimeManagement.suspend();
            return this.getState(Suspended.class);
        }

        public StateMachine.State terminate() {
            return this.getState(Terminated.class);
        }

        public StateMachine.State netOff() {
            OfflineInterpreter.this.fTimerTimeManagement.suspend();
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(TimerSteppingNetOff.class);
        }

        public StateMachine.State emptyInput() {
            StateMachine.State nextState = this;
            OfflineInterpreter.this.fTimerTimeManagement.calculateCurrentTimes();
            OfflineInterpreter.this.fClockTimeManagement.calculateCurrentTimes();
            OfflineInterpreter.this.runOneCycle();
            if (OfflineInterpreter.this.fStepTimer.isFinished()) {
                OfflineInterpreter.this.fTimerTimeManagement.suspend();
                nextState = this.getState(Suspended.class);
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return nextState;
        }
    }

    public class Running
    extends OfflineInterpreterState {
        public StateMachine.State stop() {
            return this.getState(Stopped.class);
        }

        public StateMachine.State suspend() {
            OfflineInterpreter.this.fTimerTimeManagement.suspend();
            return this.getState(Suspended.class);
        }

        public StateMachine.State netOff() {
            OfflineInterpreter.this.fTimerTimeManagement.suspend();
            OfflineInterpreter.this.fWiringDiagram.netOn(OfflineInterpreter.this, false);
            return this.getState(RunningNetOff.class);
        }

        public StateMachine.State emptyInput() {
            OfflineInterpreter.this.fClockTimeManagement.calculateCurrentTimes();
            OfflineInterpreter.this.fTimerTimeManagement.calculateCurrentTimes();
            OfflineInterpreter.this.runOneCycle();
            this.sleep(10L);
            return this;
        }
    }

    public abstract class OfflineInterpreterState
    extends StateMachine.State {
        public StateMachine.State start() {
            return this;
        }

        public StateMachine.State stop() {
            return this;
        }

        public StateMachine.State netOff() {
            return this;
        }

        public StateMachine.State netOn() {
            return this;
        }

        public StateMachine.State suspend() {
            return this;
        }

        public StateMachine.State resume() {
            return this;
        }

        public StateMachine.State cycleStep() {
            return this;
        }

        public StateMachine.State timerStep() {
            return this;
        }

        public StateMachine.State emptyInput() {
            return this;
        }

        public StateMachine.State terminate() {
            return this.getState(Terminated.class);
        }
    }
}

