/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.block.AmplifierBlock;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogDeltaTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.AnalogMuxBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.AsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.OffDelayBlock;
import DE.siemens.ad.logo.model.block.OnDelayBlock;
import DE.siemens.ad.logo.model.block.OnOffDelayBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.block.PWMBlock;
import DE.siemens.ad.logo.model.block.RampControlBlock;
import DE.siemens.ad.logo.model.block.RandomBlock;
import DE.siemens.ad.logo.model.block.RetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterBlock;
import DE.siemens.ad.logo.model.block.SoftkeyBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.WipingRelayBlock;
import DE.siemens.ad.logo.model.block.WipingRelayPECBlock;
import DE.siemens.ad.logo.model.hardware.Logo6;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo4;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Util;

public class ActualValueVisitor
extends Visitor {
    protected int[] fBuffer;
    protected int fBufferPointer;
    protected CompilerFromLogo4 fCompiler = new CompilerFromLogo4();

    public Object visit(OnDelayBlock onDelayBlock) {
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(AsymPulseGeneratorBlock asymPulseGeneratorBlock) {
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(RandomBlock randomBlock) {
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(OnOffDelayBlock onOffDelayBlock) {
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(StairsSwitchBlock stairsSwitchBlock) {
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(ComfortSwitchBlock comfortSwitchBlock) {
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(WipingRelayPECBlock wipingRelayPECBlock) {
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(ShiftRegisterBlock shiftRegisterBlock) {
        this.getByte();
        this.getByte();
        return "";
    }

    public Object visit(AnalogTriggerBlock analogTriggerBlock) {
        this.getByte();
        int ax = this.parseAnalogValue();
        String value = Double.toString(ax);
        value = "       ".substring(value.length()) + value;
        this.getByte();
        this.getByte();
        return value;
    }

    public Object visit(AnalogDeltaTriggerBlock analogDeltaTriggerBlock) {
        this.getByte();
        int ax = this.parseAnalogValue();
        String value = Double.toString(ax);
        value = "       ".substring(value.length()) + value;
        this.getByte();
        this.getByte();
        return value;
    }

    public Object visit(AnalogWatchdogBlock analogWatchdogBlock) {
        this.getByte();
        int ax = this.parseAnalogValue();
        int aen = this.parseAnalogValue();
        StringBuffer value = new StringBuffer();
        this.getByte();
        this.getByte();
        try {
            if (!(analogWatchdogBlock.getHardware() instanceof Logo6)) {
                this.getByte();
                this.getByte();
                value.append(Util.addLeadingZeros(Double.toString(ax), 6)).append("\n");
                value.append(Util.addLeadingZeros(Double.toString(aen), 6));
            } else {
                int temp = ax;
                ax = aen;
                aen = temp;
                value.append(Double.toString(ax)).append("\n");
                value.append(Double.toString(aen));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return value.toString();
    }

    public Object visit(AnalogComparatorBlock analogComparatorBlock) {
        this.getByte();
        int ax = this.parseAnalogValue();
        int ay = this.parseAnalogValue();
        int delta = this.parseAnalogValue();
        String axValue = Integer.toString(ax);
        axValue = "       ".substring(axValue.length()) + axValue;
        String ayValue = Integer.toString(ay);
        ayValue = "       ".substring(ayValue.length()) + ayValue;
        String deltaValue = Integer.toString(delta);
        deltaValue = "       ".substring(deltaValue.length()) + deltaValue;
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        return axValue + "\n" + ayValue + "\n" + deltaValue;
    }

    public Object visit(AmplifierBlock amplifierBlock) {
        int ax = this.parseAnalogValue();
        String axValue = Integer.toString(ax);
        axValue = "       ".substring(axValue.length()) + axValue;
        this.getByte();
        this.getByte();
        return axValue;
    }

    public Object visit(OffDelayBlock offDelayBlock) {
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(RetentiveOnDelayBlock retentiveOnDelayBlock) {
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(HoursCounterBlock hoursCounterBlock) {
        this.getByte();
        int mn = 0;
        mn += this.getByte();
        mn += this.getByte() << 8;
        mn += this.getByte() << 16;
        mn += (this.getByte() & 0x3F) << 24;
        int ot = 0;
        ot += this.getByte();
        ot += this.getByte() << 8;
        ot += this.getByte() << 16;
        this.getByte();
        this.getByte();
        return "OT=" + this.formatHoursCounterTime(ot += this.getByte() << 24) + "\nMN=" + this.formatHoursCounterTime(mn);
    }

    private String formatHoursCounterTime(int minutes) {
        int hour = minutes / 60;
        int min = minutes % 60;
        String minuteString = Util.addLeadingZeros(Integer.toString(min), 2);
        return hour + ":" + minuteString;
    }

    public Object visit(WipingRelayBlock wipingRelayBlock) {
        this.getByte();
        this.getByte();
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(CounterBlock counterBlock) {
        int cnt = 0;
        cnt += this.getByte();
        cnt += this.getByte() << 8;
        cnt += this.getByte() << 16;
        String value = Integer.toString(cnt += this.getByte() << 24);
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        return value;
    }

    public Object visit(TriggerBlock triggerBlock) {
        this.getByte();
        this.getByte();
        int fa = 0;
        fa += this.getByte();
        this.getByte();
        this.getByte();
        String value = Integer.toString(fa += this.getByte() << 8);
        value = "      ".substring(value.length()) + value;
        this.getByte();
        this.getByte();
        return value;
    }

    public Object visit(AnalogMuxBlock block) {
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        aqValue = "       ".substring(aqValue.length()) + aqValue;
        this.getByte();
        this.getByte();
        return aqValue;
    }

    public Object visit(AnalogMathsBlock block) {
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        aqValue = "       ".substring(aqValue.length()) + aqValue;
        this.getByte();
        this.getByte();
        return aqValue;
    }

    public Object visit(MathDetectionBlock block) {
        int state = this.getByte();
        this.getByte();
        this.getByte();
        return MathDetectionParameter.getStateText((state & 2) > 0, (state & 1) > 0);
    }

    public Object visit(PWMBlock block) {
        this.getByte();
        int ax = this.parseAnalogValue();
        TimeUnit timeUnit = this.parseTimer();
        StringBuffer value = new StringBuffer();
        value.append(Double.toString(ax)).append("\n");
        value.append(timeUnit.getTimeAsString());
        this.getByte();
        this.getByte();
        return value.toString();
    }

    public Object visit(RampControlBlock block) {
        this.getByte();
        this.getByte();
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        aqValue = "       ".substring(aqValue.length()) + aqValue;
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        return aqValue;
    }

    public Object visit(PIDBlock block) {
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        this.getByte();
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        aqValue = "       ".substring(aqValue.length()) + aqValue;
        int pv = this.parseAnalogValue();
        this.getByte();
        this.getByte();
        block.setOnlineTestAQ(aq);
        block.setOnlineTestPV(pv);
        return aqValue;
    }

    public Object visit(SoftkeyBlock shiftRegisterBlock) {
        int state = this.getByte();
        String stateString = state > 0 ? "On" : "Off";
        this.getByte();
        this.getByte();
        this.getByte();
        return stateString;
    }

    public void setBuffer(int[] buffer) {
        this.fBuffer = buffer;
        this.fBufferPointer = 0;
    }

    protected int getByte() {
        return this.fBuffer[this.fBufferPointer++] & 0xFF;
    }

    protected TimeUnit parseTimer() {
        int lowByte = this.getByte();
        int highByte = this.getByte();
        TimeUnit timeUnit = null;
        timeUnit = lowByte == 0 && highByte == 0 ? new UnitlessTimeUnit() : this.fCompiler.getNewTimeObject(highByte, lowByte);
        return timeUnit;
    }

    protected int parseAnalogValue() {
        int lowByte = this.getByte();
        int highByte = this.getByte();
        int ax = Util.makeSignedWord(highByte, lowByte);
        return ax;
    }

    protected static class UnitlessTimeUnit
    extends TimeUnit {
        public static final String UNIT_KEY = "dialog.timeParameter.noUnit";

        protected UnitlessTimeUnit() {
        }

        public String getDefaultUnitString() {
            return "";
        }

        public IntValueProperties getHigh() {
            return new IntValueProperties(0, 0, 0, 0, "error.dialog.invalidValue", "Invalid value");
        }

        public int getHighValue() {
            return 0;
        }

        public int[] getLogoTime() {
            return new int[]{0, 0};
        }

        public IntValueProperties getLow() {
            return new IntValueProperties(0, 0, 0, 0, "error.dialog.invalidValue", "Invalid value");
        }

        public int getLowValue() {
            return 0;
        }

        public String getUnitAbbreviation() {
            return " ";
        }

        public String getUnitKey() {
            return UNIT_KEY;
        }

        public void setTime(int high, int low) {
        }

        public TimeUnit setTime(int value) {
            return null;
        }

        public String getLowValueUnitKey() {
            return "";
        }

        public String getLowValueUnitAbbreviation() {
            return "";
        }
    }
}

