/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.standard.FigureDrawInfo;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class PrintImageFigure
extends ImageFigure {
    private static final long serialVersionUID = 1L;
    private int printImageFigureSerializedDataVersion = 3;
    private static final int LAD_GRID_POS = 15;
    public static final Color fImageColor = new Color(255, 222, 140);
    static int[][] asympulsegenerator = new int[][]{{3, 24, 4, 24}, {4, 24, 4, 15}, {4, 15, 6, 15}, {6, 15, 6, 24}, {6, 24, 14, 24}, {14, 24, 14, 15}, {14, 15, 16, 15}, {16, 15, 16, 24}, {16, 24, 21, 24}, {10, 24, 10, 15}, {20, 24, 20, 15}};
    static int[][] clock = new int[][]{{12, 15, 12, 9}, {12, 15, 16, 15}};
    static int[][] counter = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 5}, {6, 5, 21, 5}, {4, 7, 6, 5}, {6, 5, 8, 7}, {3, 20, 9, 20}, {6, 16, 6, 23}, {11, 25, 15, 16}, {17, 20, 21, 20}};
    static int[][] hourcounter = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 5}, {6, 5, 15, 5}, {3, 25, 16, 25}, {16, 25, 16, 16}, {16, 16, 23, 16}, {16, 12, 16, 7}, {16, 9, 19, 9}, {19, 9, 19, 12}};
    static int[][] offdelay = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 9, 4}, {9, 4, 9, 12}, {9, 12, 21, 12}, {3, 25, 6, 25}, {6, 25, 6, 16}, {6, 16, 19, 16}, {19, 16, 19, 25}, {19, 25, 21, 25}, {9, 25, 9, 22}, {9, 20, 9, 16}};
    static int[][] ondelay = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 19, 4}, {19, 4, 19, 12}, {19, 12, 22, 12}, {3, 23, 16, 23}, {16, 23, 16, 16}, {16, 16, 19, 16}, {19, 16, 19, 23}, {19, 23, 22, 23}, {6, 23, 6, 20}, {6, 18, 6, 16}};
    static int[][] pulserelay = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 9, 4}, {9, 4, 9, 12}, {9, 12, 16, 12}, {16, 12, 16, 4}, {16, 4, 19, 4}, {19, 4, 19, 12}, {19, 12, 22, 12}, {3, 24, 6, 24}, {6, 24, 6, 16}, {6, 16, 16, 16}, {16, 16, 16, 24}, {16, 24, 22, 24}};
    static int[][] retentiveondelay = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 9, 4}, {9, 4, 9, 12}, {9, 12, 21, 12}, {3, 24, 16, 24}, {16, 24, 16, 16}, {16, 16, 22, 16}, {6, 24, 6, 21}, {6, 19, 6, 16}};
    static int[][] sympulsegenerator = new int[][]{{3, 23, 5, 23}, {5, 23, 5, 15}, {5, 15, 10, 15}, {10, 15, 10, 23}, {10, 23, 15, 23}, {15, 23, 15, 15}, {15, 15, 20, 15}, {20, 15, 20, 23}, {20, 23, 22, 23}};
    static int[][] trigger = new int[][]{{5, 11, 12, 4}, {12, 4, 19, 11}, {4, 23, 7, 23}, {7, 23, 7, 15}, {7, 15, 17, 15}, {17, 15, 17, 23}, {17, 23, 21, 23}};
    static int[][] wipingrelay = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 19, 4}, {19, 4, 19, 12}, {19, 12, 22, 12}, {3, 23, 6, 23}, {6, 23, 6, 16}, {6, 16, 9, 16}, {9, 16, 9, 23}, {9, 23, 22, 23}};
    static int[][] wipingrelaypec = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 16, 4}, {16, 4, 16, 12}, {16, 12, 22, 12}, {3, 23, 6, 23}, {6, 23, 6, 16}, {6, 16, 19, 16}, {19, 16, 19, 23}, {19, 23, 22, 23}, {3, 7, 6, 4}, {6, 4, 9, 7}};
    static int[][] nor = new int[][]{{6, 16, 12, 16}};
    static int[][] or = new int[][]{{6, 16, 12, 16}};
    static int[][] analogtrigger = new int[][]{{5, 11, 12, 4}, {4, 23, 7, 23}, {7, 23, 7, 15}, {7, 15, 17, 15}, {17, 15, 17, 23}, {17, 23, 21, 23}};
    static int[][] analogcomparator = new int[][]{{3, 12, 8, 4}, {8, 4, 13, 12}, {13, 12, 3, 12}, {3, 23, 16, 23}, {16, 23, 16, 16}, {16, 16, 19, 16}, {19, 16, 19, 23}, {19, 23, 22, 23}};
    static int[][] analogWatchdog = new int[][]{{13, 22, 18, 14}, {18, 14, 23, 22}, {23, 22, 13, 22}, {4, 11, 7, 11}, {7, 11, 7, 4}, {7, 4, 9, 4}, {7, 14, 7, 20}, {4, 17, 10, 17}, {4, 22, 10, 22}};
    static int[][] analogDeltaTrigger = new int[][]{{4, 22, 9, 14}, {9, 14, 14, 22}, {14, 22, 4, 22}, {5, 10, 12, 4}, {14, 15, 17, 15}, {17, 15, 17, 22}, {17, 22, 20, 22}};
    static int[][] amplifier = new int[][]{{14, 11, 20, 11}, {20, 11, 17, 8}, {20, 11, 17, 14}, {5, 21, 8, 21}, {8, 17, 8, 25}, {8, 25, 12, 21}, {12, 21, 8, 17}, {12, 21, 15, 21}};
    static int[][] pid = new int[][]{{5, 13, 10, 8}, {10, 8, 14, 10}, {14, 10, 20, 10}, {14, 20, 20, 20}, {20, 20, 17, 17}, {20, 20, 17, 23}};
    static int[][] rampControl = new int[][]{{5, 12, 9, 7}, {9, 7, 13, 7}, {13, 7, 13, 12}, {13, 12, 20, 12}, {14, 20, 20, 20}, {20, 20, 17, 17}, {20, 20, 17, 23}};
    static int[][] analogMux = new int[][]{{5, 7, 8, 7}, {5, 9, 8, 9}, {5, 11, 8, 11}, {5, 13, 8, 13}, {11, 8, 13, 8}, {11, 12, 13, 12}, {16, 10, 20, 10}, {14, 20, 20, 20}, {20, 20, 17, 17}, {20, 20, 17, 23}};
    static int[][] analogMaths = new int[][]{{5, 8, 11, 8}, {8, 5, 8, 11}, {13, 7, 19, 7}, {13, 9, 19, 9}, {14, 20, 20, 20}, {20, 20, 17, 17}, {20, 20, 17, 23}};
    static int[][] mathDetection = new int[][]{{5, 8, 11, 8}, {8, 5, 8, 11}, {13, 7, 19, 7}, {13, 9, 19, 9}, {14, 20, 20, 20}, {20, 20, 17, 17}, {20, 20, 17, 23}};
    static int[][] PWM = new int[][]{{3, 25, 6, 25}, {6, 25, 6, 18}, {6, 18, 9, 18}, {9, 18, 9, 25}, {9, 25, 12, 25}, {12, 25, 15, 25}, {15, 25, 15, 18}, {15, 18, 18, 18}, {18, 18, 18, 25}, {18, 25, 20, 25}, {14, 10, 20, 10}, {20, 10, 17, 7}, {20, 10, 17, 13}};
    static int[][] stairsswitch = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 9, 4}, {9, 4, 9, 12}, {9, 12, 22, 12}, {3, 23, 6, 23}, {6, 23, 6, 15}, {6, 15, 19, 15}, {19, 15, 19, 23}, {19, 23, 22, 23}};
    static int[][] comfortswitch = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 9, 4}, {9, 4, 9, 12}, {9, 12, 17, 12}, {17, 12, 17, 4}, {17, 4, 20, 4}, {20, 4, 20, 12}, {20, 12, 22, 12}, {3, 23, 6, 23}, {6, 23, 6, 16}, {6, 16, 17, 16}, {17, 16, 17, 23}, {17, 23, 22, 23}, {9, 17, 9, 19}, {9, 21, 9, 23}};
    static int[][] onoffdelay = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 17, 4}, {17, 4, 17, 12}, {17, 12, 22, 12}, {9, 6, 9, 8}, {9, 10, 9, 12}, {3, 23, 9, 23}, {9, 23, 9, 16}, {9, 16, 20, 16}, {20, 16, 20, 23}, {20, 23, 22, 23}};
    static int[][] message = new int[][]{{4, 12, 6, 12}, {8, 12, 10, 12}, {15, 12, 17, 12}, {19, 12, 21, 12}, {4, 23, 6, 23}, {8, 23, 10, 23}, {15, 23, 17, 23}, {19, 23, 21, 23}};
    static int[][] random = new int[][]{{3, 12, 6, 12}, {6, 12, 6, 4}, {6, 4, 18, 4}, {18, 4, 18, 12}, {18, 12, 22, 12}, {3, 23, 9, 23}, {9, 23, 9, 15}, {9, 15, 20, 15}, {20, 15, 20, 23}, {20, 23, 22, 23}};
    static int[][] pecand = new int[][]{{16, 10, 18, 8}, {18, 8, 20, 10}, {18, 9, 18, 14}};
    static int[][] pecnand = new int[][]{{16, 12, 18, 14}, {18, 14, 20, 12}, {18, 14, 18, 8}};
    static int[][] softkey = new int[][]{{4, 23, 15, 15}, {15, 23, 22, 23}};
    static int[][] ladderDiagramCoil = new int[][]{{0, 15, 4, 15}};
    static int[][] ladderDiagramNegativCoil = new int[][]{{0, 15, 4, 15}, {10, 25, 13, 7}};
    static int[][] ladderDiagramContact = new int[][]{{0, 15, 7, 15}, {16, 15, 25, 15}, {7, 3, 7, 29}, {16, 3, 16, 29}};
    static int[][] ladderDiagramAnalogContact = new int[][]{{0, 15, 7, 15}, {16, 15, 25, 15}, {7, 3, 7, 29}, {16, 3, 16, 29}};
    static int[][] ladderDiagramNegativContact = new int[][]{{0, 15, 7, 15}, {16, 15, 25, 15}, {7, 3, 7, 29}, {16, 3, 16, 29}, {9, 29, 14, 3}};
    int[] fOval = null;
    int[][] fArcs = null;
    int[][] fLines = null;
    String fText = null;
    int fTextX;
    int fTextY;
    String fText2 = null;
    int fTextX2;
    int fTextY2;
    static Font fFont = new Font("Courier", 0, 12);
    public static final String NO_STRING = "KeinText";

    public PrintImageFigure() {
    }

    public PrintImageFigure(Image image, String fileName, Point origin) {
        super(image, fileName, origin);
    }

    public boolean canConnect() {
        return false;
    }

    public void determinFigureDrawingData(Block block) {
        String blockName = block.getName();
        this.fArcs = null;
        this.fLines = null;
        this.fOval = null;
        if (blockName.equals("YearClock")) {
            this.fText = "MM";
            this.fTextX = 5;
            this.fTextY = 12;
            this.fText2 = "DD";
            this.fTextX2 = 5;
            this.fTextY2 = 23;
        } else if (blockName.equals("Clock")) {
            this.fLines = clock;
            this.fOval = new int[]{this.fLines[0][0] - 6, this.fLines[0][1] - 7, 13, 13};
        } else if (blockName.equals("HoursCounter")) {
            this.fLines = hourcounter;
        } else if (blockName.equals("Counter")) {
            this.fLines = counter;
        } else if (blockName.equals("RetentiveOnDelay")) {
            this.fLines = retentiveondelay;
        } else if (blockName.equals("OnDelay")) {
            this.fLines = ondelay;
        } else if (blockName.equals("OffDelay")) {
            this.fLines = offdelay;
        } else if (blockName.equals("PulseRelay")) {
            this.fLines = pulserelay;
            this.fText = null;
            if (block.getHardware() != null && block.getHardware().supports("pulseRelayWithSetInput")) {
                this.fText = "RS";
                this.fTextX = 4;
                this.fTextY = 35;
            }
        } else if (blockName.equals("AsymPulseGenerator")) {
            this.fLines = asympulsegenerator;
        } else if (blockName.equals("SymPulseGenerator")) {
            this.fLines = sympulsegenerator;
        } else if (blockName.equals("Trigger")) {
            this.fLines = trigger;
        } else if (blockName.equals("WipingRelay")) {
            this.fLines = wipingrelay;
        } else if (blockName.equals("AnalogInput")) {
            this.fText = "AI";
            this.fTextX = 8;
            this.fTextY = 14;
        } else if (blockName.equals("AnalogOutput")) {
            this.fText = "AQ";
            this.fTextX = 8;
            this.fTextY = 14;
        } else if (blockName.equals("AsiInput")) {
            this.fText = "Ia";
            this.fTextX = 8;
            this.fTextY = 14;
        } else if (blockName.equals("Input")) {
            this.fText = "I";
            this.fTextX = 10;
            this.fTextY = 14;
        } else if (blockName.equals("ShiftRegisterInput")) {
            this.fText = "S";
            this.fTextX = 10;
            this.fTextY = 14;
        } else if (blockName.equals("KeyInput")) {
            this.fText = "C";
            this.fTextX = 10;
            this.fTextY = 14;
        } else if (blockName.equals("TDFunctionKeyInput")) {
            this.fText = "F";
            this.fTextX = 10;
            this.fTextY = 14;
        } else if (blockName.equals("AsiOutput")) {
            this.fText = "Qa";
            this.fTextX = 6;
            this.fTextY = 14;
        } else if (blockName.equals("Output")) {
            this.fText = "Q";
            this.fTextX = 9;
            this.fTextY = 14;
        } else if (blockName.equals("Marker")) {
            this.fText = "M";
            this.fTextX = 8;
            this.fTextY = 14;
        } else if (blockName.equals("VirtualOutput")) {
            this.fText = "X";
            this.fTextX = 8;
            this.fTextY = 14;
        } else if (blockName.equals("AnalogMarker")) {
            this.fText = "AM";
            this.fTextX = 8;
            this.fTextY = 14;
        } else if (blockName.equals("High")) {
            this.fText = "hi";
            this.fTextX = 7;
            this.fTextY = 14;
        } else if (blockName.equals("Low")) {
            this.fText = "lo";
            this.fTextX = 7;
            this.fTextY = 14;
        } else if (blockName.equals("LatchingRelay")) {
            this.fText = "RS";
            this.fTextX = 5;
            this.fTextY = 14;
        } else if (blockName.equals("Nand")) {
            this.fText = "&";
            this.fTextX = 10;
            this.fTextY = 14;
        } else if (blockName.equals("And")) {
            this.fText = "&";
            this.fTextX = 10;
            this.fTextY = 14;
        } else if (blockName.equals("Nor")) {
            this.fText = ">1";
            this.fTextX = 6;
            this.fTextY = 13;
            this.fLines = nor;
        } else if (blockName.equals("Xor")) {
            this.fText = "=1";
            this.fTextX = 6;
            this.fTextY = 13;
        } else if (blockName.equals("Or")) {
            this.fText = ">1";
            this.fTextX = 6;
            this.fTextY = 13;
            this.fLines = or;
        } else if (blockName.equals("Not")) {
            this.fText = "1";
            this.fTextX = 13;
            this.fTextY = 13;
        } else if (blockName.equals("OnOffDelay")) {
            this.fLines = onoffdelay;
        } else if (blockName.equals("AnalogComparator")) {
            this.fText = "A";
            this.fTextX = 15;
            this.fTextY = 11;
            this.fLines = analogcomparator;
        } else if (blockName.equals("AnalogMaths")) {
            this.fText = "A";
            this.fTextX = 4;
            this.fTextY = 24;
            this.fLines = analogMaths;
        } else if (blockName.equals("MathDetection")) {
            this.fText = "E";
            this.fTextX = 4;
            this.fTextY = 24;
            this.fLines = mathDetection;
        } else if (blockName.equals("AnalogWatchdog")) {
            this.fText = "A";
            this.fTextX = 15;
            this.fTextY = 11;
            this.fLines = analogWatchdog;
        } else if (blockName.equals("PWM")) {
            this.fText = "~";
            this.fTextX = 5;
            this.fTextY = 12;
            this.fLines = PWM;
        } else if (blockName.equals("AnalogDeltaTrigger")) {
            this.fText = "A";
            this.fTextX = 15;
            this.fTextY = 11;
            this.fLines = analogDeltaTrigger;
        } else if (blockName.equals("Amplifier")) {
            this.fText = "A";
            this.fTextX = 5;
            this.fTextY = 15;
            this.fLines = amplifier;
        } else if (blockName.equals("ShiftRegister")) {
            this.fText = ">>";
            this.fTextX = 5;
            this.fTextY = 20;
        } else if (blockName.equals("AnalogTrigger")) {
            this.fText = "A";
            this.fTextX = 15;
            this.fTextY = 11;
            this.fLines = analogtrigger;
        } else if (blockName.equals("Random")) {
            this.fLines = random;
        } else if (blockName.equals("Message")) {
            this.fLines = message;
        } else if (blockName.equals("ComfortSwitch")) {
            this.fLines = comfortswitch;
        } else if (blockName.equals("StairsSwitch")) {
            this.fLines = stairsswitch;
        } else if (blockName.equals("PecAnd")) {
            this.fText = "&";
            this.fTextX = 8;
            this.fTextY = 14;
            this.fLines = pecand;
        } else if (blockName.equals("PecNand")) {
            this.fText = "&";
            this.fTextX = 8;
            this.fTextY = 14;
            this.fLines = pecnand;
        } else if (blockName.equals("WipingRelayPEC")) {
            this.fLines = wipingrelaypec;
        } else if (blockName.equals("Softkey")) {
            this.fLines = softkey;
        } else if (blockName.equals("Contact")) {
            this.fLines = ladderDiagramContact;
        } else if (blockName.equals("NegativContact")) {
            this.fLines = ladderDiagramNegativContact;
        } else if (blockName.equals("Coil")) {
            this.fLines = ladderDiagramCoil;
            this.fArcs = new int[][]{{4, 3, 17, 26, 120, 120}, {2, 3, 17, 26, 300, 120}};
        } else if (blockName.equals("AnalogCoil")) {
            this.fLines = ladderDiagramCoil;
            this.fArcs = new int[][]{{4, 3, 17, 26, 120, 120}, {2, 3, 17, 26, 300, 120}, {18, 1, 5, 5, 0, 360}};
        } else if (blockName.equals("NegativCoil")) {
            this.fLines = ladderDiagramNegativCoil;
            this.fArcs = new int[][]{{4, 3, 17, 26, 120, 120}, {2, 3, 17, 26, 300, 120}};
        } else if (blockName.equals("AnalogContact")) {
            this.fLines = ladderDiagramAnalogContact;
            this.fArcs = new int[][]{{18, 1, 5, 5, 0, 360}};
        } else if (blockName.equals("PID")) {
            this.fText = "A";
            this.fTextX = 5;
            this.fTextY = 24;
            this.fLines = pid;
        } else if (blockName.equals("RampControl")) {
            this.fText = "A";
            this.fTextX = 5;
            this.fTextY = 24;
            this.fLines = rampControl;
        } else if (blockName.equals("AnalogMux")) {
            this.fText = "A";
            this.fTextX = 4;
            this.fTextY = 24;
            this.fLines = analogMux;
        }
    }

    public void draw(Graphics g) {
        super.draw(g);
    }

    public void draw(Graphics g, FigureDrawInfo fdi) {
        super.draw(g);
    }

    public void draw(Graphics g, FigureDrawInfo fdi, BlockFigure blockFigure) {
        if (fdi.isGhostPrintingEnabled()) {
            this.drawGhost(g, blockFigure);
        } else {
            super.draw(g);
        }
    }

    protected void drawGhost(Graphics g, BlockFigure blockFigure) {
        this.determinFigureDrawingData(blockFigure.getBlock());
        Rectangle rect = this.displayBox();
        g.setColor(Util.getColor("fb.background.color", fImageColor));
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(Color.black);
        if (this.fLines != null) {
            this.drawLines(g, rect.x, rect.y);
        }
        if (this.fArcs != null) {
            this.drawArcs(g, rect.x, rect.y);
        }
        if (this.fText != null) {
            this.drawText(g, rect.x, rect.y);
        }
    }

    protected void drawLines(Graphics g, int x, int y) {
        for (int i = 0; i < this.fLines.length; ++i) {
            g.drawLine(x + this.fLines[i][0], y + this.fLines[i][1], x + this.fLines[i][2], y + this.fLines[i][3]);
        }
        if (this.fOval != null) {
            g.drawOval(x + this.fOval[0], y + this.fOval[1], this.fOval[2], this.fOval[3]);
        }
    }

    protected void drawArcs(Graphics g, int x, int y) {
        g.setColor(Color.black);
        for (int i = 0; i < this.fArcs.length; ++i) {
            g.drawArc(x + this.fArcs[i][0], y + this.fArcs[i][1], this.fArcs[i][2], this.fArcs[i][3], this.fArcs[i][4], this.fArcs[i][5]);
        }
    }

    protected void drawText(Graphics g, int x, int y) {
        Font f = g.getFont();
        g.setFont(fFont);
        g.drawString(this.fText, x + this.fTextX, y + this.fTextY);
        if (this.fText2 != null) {
            g.drawString(this.fText2, x + this.fTextX2, y + this.fTextY2);
            g.setFont(f);
        }
        g.setFont(f);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fText = dr.readString();
        if (this.fText.equals(NO_STRING)) {
            this.fText = null;
        }
        this.fTextX = dr.readInt();
        this.fTextY = dr.readInt();
        this.fText2 = dr.readString();
        if (this.fText2.equals(NO_STRING)) {
            this.fText2 = null;
        }
        this.fTextX2 = dr.readInt();
        this.fTextY2 = dr.readInt();
        int count = dr.readInt();
        if (count > 0) {
            this.fLines = new int[count][4];
            for (int i = 0; i < count; ++i) {
                this.fLines[i][0] = dr.readInt();
                this.fLines[i][1] = dr.readInt();
                this.fLines[i][2] = dr.readInt();
                this.fLines[i][3] = dr.readInt();
            }
        }
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        if (this.fText != null) {
            dw.writeString(this.fText);
        } else {
            dw.writeString(NO_STRING);
        }
        dw.writeInt(this.fTextX);
        dw.writeInt(this.fTextY);
        if (this.fText2 != null) {
            dw.writeString(this.fText2);
        } else {
            dw.writeString(NO_STRING);
        }
        dw.writeInt(this.fTextX2);
        dw.writeInt(this.fTextY2);
        if (this.fLines != null) {
            int count = this.fLines.length;
            dw.writeInt(count);
            for (int i = 0; i < count; ++i) {
                dw.writeInt(this.fLines[i][0]);
                dw.writeInt(this.fLines[i][1]);
                dw.writeInt(this.fLines[i][2]);
                dw.writeInt(this.fLines[i][3]);
            }
        } else {
            dw.writeInt(0);
        }
    }
}

