/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import com.sun.jimi.core.Jimi;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.text.DateFormat;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public abstract class LogoPrintable
implements Printable {
    protected LogoDrawing fDrawing;
    protected transient Image fPrintFooterImage = null;
    protected int fFirstPageNumber;
    protected int fPageNumberOffset;

    public LogoPrintable(LogoDrawing logoDrawing) {
        this.fDrawing = logoDrawing;
    }

    public String cutString(String origin, FontMetrics metric, int leftPos, int rightPos) {
        String retString = origin;
        int diff = rightPos - leftPos;
        if (metric.stringWidth(origin) <= diff) {
            return origin;
        }
        try {
            int length = origin.length();
            while (length > 0) {
                if (metric.stringWidth(retString = retString.substring(0, length - 2)) <= diff) {
                    int lastBlankPosition = retString.lastIndexOf(" ");
                    if (lastBlankPosition != -1) {
                        retString = retString.substring(0, lastBlankPosition + 1);
                    }
                    return retString;
                }
                length = retString.length();
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    public LogoDrawing getDrawing() {
        return this.fDrawing;
    }

    public int getFirstPageNumber() {
        return this.fFirstPageNumber;
    }

    public abstract int getPageCount(PageFormat var1, Graphics var2);

    protected void loadFooterImage(String companyIcon) {
        if (companyIcon == null || companyIcon.equals("") || !new File(companyIcon).exists()) {
            this.fPrintFooterImage = null;
            return;
        }
        this.fPrintFooterImage = Jimi.getImage((String)companyIcon);
        this.fPrintFooterImage = new ImageIcon(this.fPrintFooterImage).getImage();
    }

    protected Dimension printFooter(Graphics g, PageFormat pageFormat, int actPage, int maxPage) {
        int index;
        g = g.create();
        Dimension dimension = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        if (System.getProperty("os.name").equals("Mac OS X")) {
            // empty if block
        }
        Font ft = new Font("Dialog", 0, 6);
        g.setFont(ft);
        g.setColor(Color.black);
        LogoDrawing drawing = this.fDrawing;
        DrawingProperties properties = drawing.getWiringDiagram().getDrawingProperties();
        g.setClip(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        Dimension dim = new Dimension(dimension);
        float[] verticalPos = new float[]{0.12f, 0.35f, 0.48f, 0.57f, 0.74f, 0.83f};
        int[] vPos = new int[verticalPos.length];
        int distance = 0;
        float flWidth = dim.width - 2 * distance;
        for (int i = 0; i < verticalPos.length; ++i) {
            float fPos = flWidth * verticalPos[i];
            vPos[i] = (int)fPos + distance;
        }
        Font font = g.getFont();
        FontMetrics metric = g.getFontMetrics();
        int height = 9;
        int descent = 2;
        g.drawRect(distance, distance, dim.width - 2 * distance, dim.height - 2 * distance);
        dim.height -= distance + 1;
        g.drawLine(distance, dim.height - height, vPos[1], dim.height - height);
        g.drawLine(vPos[2], dim.height - height, dim.width - distance, dim.height - height);
        g.drawLine(distance, dim.height - height * 2, vPos[1], dim.height - height * 2);
        g.drawLine(vPos[2], dim.height - height * 2, dim.width - distance, dim.height - height * 2);
        g.drawLine(distance, dim.height - height * 3, dim.width - distance, dim.height - height * 3);
        for (int i = 0; i < vPos.length; ++i) {
            g.drawLine(vPos[i], dim.height - height * 3, vPos[i], dim.height + 1);
        }
        g.drawString(Language.getString("print.creator", "Creator:"), distance + 2, dim.height - 2 * height - descent);
        if (properties.getCreator().length() > 0) {
            g.drawString(this.cutString(properties.getCreator(), metric, vPos[0], vPos[1]), vPos[0] + 2, dim.height - 2 * height - descent);
        }
        g.drawString(Language.getString("print.checked", "Checked:"), distance + 2, dim.height - height - descent);
        if (properties.getChecked().length() > 0) {
            g.drawString(this.cutString(properties.getChecked(), metric, vPos[0], vPos[1]), vPos[0] + 2, dim.height - height - descent);
        }
        g.drawString(Language.getString("print.date", "Date:"), distance + 2, dim.height - descent);
        DateFormat df = DateFormat.getDateInstance(3, Language.getLocale());
        DateFormat tf = DateFormat.getTimeInstance(3, Language.getLocale());
        g.drawString(this.cutString(df.format(properties.getCreated()) + " " + tf.format(properties.getCreated()) + "/" + df.format(properties.getChanged()) + " " + tf.format(properties.getChanged()), metric, vPos[0], vPos[1]), vPos[0] + 2, dim.height - descent);
        g.drawString(Language.getString("print.projekt", "Project:"), vPos[2] + 2, dim.height - 2 * height - descent);
        if (properties.getProjectname().length() > 0) {
            g.drawString(this.cutString(properties.getProjectname(), metric, vPos[3], vPos[4]), vPos[3] + 2, dim.height - 2 * height - descent);
        }
        g.drawString(Language.getString("print.installation", "Installation:"), vPos[2] + 2, dim.height - height - descent);
        if (properties.getInstallationname().length() > 0) {
            g.drawString(this.cutString(properties.getInstallationname(), metric, vPos[3], vPos[4]), vPos[3] + 2, dim.height - height - descent);
        }
        g.drawString(Language.getString("print.file", "File:"), vPos[2] + 2, dim.height - descent);
        String file = drawing.getFile().getPath();
        if (file != null && (index = file.lastIndexOf(92)) != -1) {
            file = file.substring(index + 1);
            g.drawString(this.cutString(file, metric, vPos[3], vPos[4]), vPos[3] + 2, dim.height - descent);
        }
        g.drawString(Language.getString("print.customer", "Customer:"), vPos[4] + 2, dim.height - 2 * height - descent);
        if (properties.getCustomer().length() > 0) {
            g.drawString(this.cutString(properties.getCustomer(), metric, vPos[5], dim.width), vPos[5] + 2, dim.height - 2 * height - descent);
        }
        g.drawString(Language.getString("print.diagramnr", "Diagramnumber:"), vPos[4] + 2, dim.height - height - descent);
        if (properties.getDiagramnr().length() > 0) {
            g.drawString(this.cutString(properties.getDiagramnr(), metric, vPos[5], dim.width), vPos[5] + 2, dim.height - height - descent);
        }
        g.drawString(Language.getString("print.page", "Page:"), vPos[4] + 2, dim.height - descent);
        if (actPage > 0) {
            if (maxPage > 0) {
                g.drawString(this.cutString(actPage + " / " + maxPage, metric, vPos[5], dim.width), vPos[5] + 2, dim.height - descent);
            } else {
                g.drawString(this.cutString("" + actPage, metric, vPos[5], dim.width), vPos[5] + 2, dim.height - descent);
            }
        }
        this.loadFooterImage(properties.getCompany());
        if (this.fPrintFooterImage != null) {
            int imageWidth = this.fPrintFooterImage.getWidth(null);
            int imageHeight = this.fPrintFooterImage.getHeight(null);
            int maxImageWidth = vPos[2] - vPos[1] - 4;
            int maxImageHeight = height * 3 - 2;
            double zoomx = (double)maxImageWidth / (double)imageWidth;
            double zoomy = (double)maxImageHeight / (double)imageHeight;
            double zoom = Math.min(zoomx, zoomy);
            int centerOffset = Math.max((maxImageWidth - imageWidth) / 2, 0);
            g.drawImage(this.fPrintFooterImage.getScaledInstance((int)((double)imageWidth * zoom * 10.0), (int)((double)imageHeight * zoom * 10.0), 1), vPos[1] + 2 + centerOffset, dim.height - height * 3 + 1, (int)((double)imageWidth * zoom), (int)((double)imageHeight * zoom), null);
        } else {
            String company = properties.getCompany();
            if (company != null && company.length() > 0) {
                g.drawString(company, vPos[1] + 2, dim.height - height - descent);
            }
        }
        return new Dimension(dim.width - 2 * distance - 2, dim.height - 2 * distance - 3 * height - 2);
    }

    protected void setClip(Graphics g, Rectangle r, PageFormat pageFormat, boolean firstTime) {
        g.setClip(r.x, r.y, r.width, r.height);
    }

    public void setDrawing(LogoDrawing newDrawing) {
        this.fDrawing = newDrawing;
    }

    public void setFirstPageNumber(int newFirstPageNumber) {
        this.fFirstPageNumber = newFirstPageNumber;
    }

    public String wordWrap(String origin, FontMetrics metric, int width) {
        if (SwingUtilities.computeStringWidth(metric, origin) <= width) {
            return origin;
        }
        StringBuffer wordWrappedString = new StringBuffer();
        StringTokenizer st = new StringTokenizer(origin, "\n");
        while (st.hasMoreTokens()) {
            String originalString = st.nextToken();
            String cuttedString = "";
            boolean firstLoop = true;
            do {
                if (!firstLoop) {
                    wordWrappedString.append("\n");
                }
                originalString = originalString.substring(cuttedString.length());
                cuttedString = this.cutString(originalString, metric, 0, width);
                wordWrappedString.append(cuttedString);
                firstLoop = false;
            } while (!cuttedString.equals(originalString));
            wordWrappedString.append("\n");
        }
        return wordWrappedString.toString();
    }

    public int getPageNumberOffset() {
        return this.fPageNumberOffset;
    }

    public void setPageNumberOffset(int pageNumberOffset) {
        this.fPageNumberOffset = pageNumberOffset;
    }
}

