/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.pdraw.app.print.LogoPrintable;
import DE.siemens.ad.pdraw.standard.FupFigureDrawInfo;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;

public class DrawingPrinter
extends LogoPrintable {
    protected FupFigureDrawInfo fPrinterDrawInfo;
    protected List fPagesWithContent;
    protected boolean fSuppressEmptyPages;

    public DrawingPrinter(LogoDrawing logoDrawing, boolean suppressEmptyPages) {
        super(logoDrawing);
        this.fSuppressEmptyPages = suppressEmptyPages;
    }

    public int getPageCount(PageFormat pf, Graphics g) {
        DrawingProperties properties = this.fDrawing.getWiringDiagram().getDrawingProperties();
        Dimension pageDimension = this.fDrawing.getPageDimension();
        if (this.fSuppressEmptyPages) {
            if (this.fPagesWithContent == null) {
                this.fPagesWithContent = new ArrayList();
                int overallPageNumber = 0;
                for (int y = 0; y < properties.getPagesVertical(); ++y) {
                    for (int x = 0; x < properties.getPagesHorizontal(); ++x) {
                        if (!this.fDrawing.isPageEmpty(x, y)) {
                            this.fPagesWithContent.add(new Integer(overallPageNumber));
                        }
                        ++overallPageNumber;
                    }
                }
            }
            return this.fPagesWithContent.size();
        }
        return this.getOverallPageCount(pf);
    }

    public int getOverallPageCount(PageFormat pageFormat) {
        DrawingProperties properties = this.fDrawing.getWiringDiagram().getDrawingProperties();
        return properties.getPagesHorizontal() * properties.getPagesVertical();
    }

    private boolean isPageEmpty(int pageNr) {
        Dimension pageDimension;
        DrawingProperties properties = this.fDrawing.getWiringDiagram().getDrawingProperties();
        int y = pageNr / properties.getPagesHorizontal();
        int x = pageNr % properties.getPagesHorizontal();
        Rectangle pageRectangle = new Rectangle(new Point(x * pageDimension.width, y * pageDimension.height), pageDimension = this.fDrawing.getPageDimension());
        return this.fDrawing.findFigure(pageRectangle) == null;
    }

    private FupFigureDrawInfo getPrinterDrawInfo() {
        if (this.fPrinterDrawInfo == null) {
            this.fPrinterDrawInfo = new FupFigureDrawInfo();
            this.fPrinterDrawInfo.setDestinationDevice(1);
        }
        this.fPrinterDrawInfo.init();
        return this.fPrinterDrawInfo;
    }

    public int print(Graphics printerGraphics, PageFormat pf, int pi) throws PrinterException {
        LogoDrawing drawing = this.fDrawing;
        int pagesHorizontal = drawing.getWiringDiagram().getDrawingProperties().getPagesHorizontal();
        int pagesVertical = drawing.getWiringDiagram().getDrawingProperties().getPagesVertical();
        if ((pi -= this.fFirstPageNumber) >= this.getPageCount(pf, printerGraphics)) {
            return 1;
        }
        if (this.fSuppressEmptyPages) {
            pi = (Integer)this.fPagesWithContent.get(pi);
        }
        printerGraphics.setColor(Color.black);
        printerGraphics.setClip(0, 0, 32000, 32000);
        printerGraphics.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        try {
            Dimension printArea = drawing.getPageDimension();
            Graphics drawingPageGraphics = printerGraphics.create();
            double printZoom = drawing.getPrintZoom();
            ((Graphics2D)drawingPageGraphics).scale(printZoom, printZoom);
            this.setClip(drawingPageGraphics, new Rectangle(1, 1, (int)((double)printArea.width / printZoom), (int)((double)printArea.height / printZoom)), pf, false);
            drawingPageGraphics.translate(-((int)((double)printArea.width / printZoom * (double)(pi % pagesHorizontal))), -((int)((double)printArea.height / printZoom * (double)(pi / pagesHorizontal))));
            this.fDrawing.draw(drawingPageGraphics, this.getPrinterDrawInfo());
            this.printFooter(printerGraphics, pf, pi + 1, this.getOverallPageCount(pf));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }
}

