/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import DE.siemens.ad.logo.model.InputNamesManager;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.print.LogoPrintable;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConnectorNamesPrinter
extends LogoPrintable
implements Printable {
    protected int fCurrentIndex = 0;
    protected Vector fConnectorBlockNames;
    protected Vector fConnectorLabels;
    int[] fIndexArr;
    int fPages = -1;

    public ConnectorNamesPrinter(LogoDrawing logoDrawing) {
        super(logoDrawing);
    }

    protected void fillConnectorVectors() {
        InputNamesManager inputNamesManager = this.fDrawing.getInputNamesManager();
        this.fConnectorBlockNames = new Vector();
        this.fConnectorLabels = new Vector();
        String[] inputNames = inputNamesManager.getInputNames();
        for (int i = 0; i < inputNames.length; ++i) {
            this.fConnectorBlockNames.add(inputNames[i]);
            this.fConnectorLabels.add(inputNamesManager.getInputName(inputNames[i]));
        }
        String[] outputNames = inputNamesManager.getOutputNames();
        for (int i = 0; i < outputNames.length; ++i) {
            this.fConnectorBlockNames.add(outputNames[i]);
            this.fConnectorLabels.add(inputNamesManager.getInputName(outputNames[i]));
        }
        this.fIndexArr = new int[this.fConnectorBlockNames.size() + 1];
    }

    public void fillIndexArray(Graphics g, PageFormat pf) throws PrinterException {
        this.fPages = 0;
        this.fCurrentIndex = 0;
        this.fillConnectorVectors();
        while (this.fCurrentIndex < this.fConnectorBlockNames.size()) {
            this.fIndexArr[this.fPages] = this.fCurrentIndex;
            this.fCurrentIndex = this.printConnectorPage(g, pf, this.fCurrentIndex);
            ++this.fPages;
        }
        this.fIndexArr[this.fPages] = -1;
    }

    public int getPageCount(PageFormat pf, Graphics g) {
        try {
            this.fillIndexArray(g, pf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fPages;
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if ((pi -= this.fFirstPageNumber) >= this.fPages) {
            return 1;
        }
        this.fCurrentIndex = this.fIndexArr[pi];
        g.setColor(Color.black);
        g.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        Dimension printArea = this.printFooter(g, pf, pi + this.fFirstPageNumber + 1 + this.getPageNumberOffset(), 0);
        this.setClip(g, new Rectangle(1, 1, printArea.width, printArea.height), pf, false);
        this.fCurrentIndex = this.printConnectorPage(g, pf, this.fCurrentIndex);
        g.translate(-((int)pf.getImageableX()), -((int)pf.getImageableY()));
        return 0;
    }

    protected int printConnectorPage(Graphics g, PageFormat pf, int startIndex) {
        Dimension printArea = this.printFooter(g, pf, 0, 0);
        return this.printConnectors(g, startIndex, printArea);
    }

    protected int printConnectors(Graphics pg, int index, Dimension usableDimension) {
        pg.setColor(Color.black);
        int lineDiff = 15;
        int xPosBlock = 20;
        int xPosParameter = 100;
        int yPos = lineDiff;
        boolean pageFull = false;
        int currentIndex = index;
        FontMetrics metrics = pg.getFontMetrics();
        int textHeight = metrics.getHeight();
        Font ft = new Font("Dialog", 1, 8);
        pg.setFont(ft);
        metrics = pg.getFontMetrics();
        textHeight = metrics.getHeight();
        pg.drawString(Language.getString("print.connector", "Connector"), xPosBlock, yPos);
        pg.drawString(Language.getString("print.connectorLabel", "Label"), xPosParameter, yPos);
        pg.drawLine(0, yPos + lineDiff, usableDimension.width, yPos + lineDiff);
        pg.drawLine(0, yPos + lineDiff + 1, usableDimension.width, yPos + lineDiff + 1);
        yPos += lineDiff * 2;
        ft = new Font("Dialog", 0, 8);
        pg.setFont(ft);
        metrics = pg.getFontMetrics();
        textHeight = metrics.getHeight();
        while (this.fConnectorBlockNames.size() > currentIndex && !pageFull) {
            String blockName = (String)this.fConnectorBlockNames.elementAt(currentIndex);
            String connectorName = this.wordWrap((String)this.fConnectorLabels.elementAt(currentIndex), metrics, usableDimension.width - xPosParameter);
            StringTokenizer tokenizer = new StringTokenizer(connectorName, "\n");
            if (yPos + tokenizer.countTokens() * textHeight + lineDiff > usableDimension.height) {
                pageFull = true;
            }
            if (!pageFull) {
                pg.drawString(blockName, xPosBlock, yPos);
                boolean firstLoop = true;
                while (tokenizer.hasMoreTokens()) {
                    if (!firstLoop) {
                        yPos += textHeight;
                    }
                    firstLoop = false;
                    String line = tokenizer.nextToken();
                    pg.drawString(line, xPosParameter, yPos);
                }
                yPos -= textHeight;
            }
            if (!pageFull) {
                pg.drawLine(0, yPos + lineDiff, usableDimension.width, yPos + lineDiff);
                yPos += lineDiff * 2;
                ++currentIndex;
            }
            pg.drawLine(xPosParameter - lineDiff, 0, xPosParameter - lineDiff, yPos - lineDiff);
        }
        return currentIndex;
    }
}

