/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.action.CompositeUndoableAction;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.pdraw.action.ChangeConnectionAction;
import DE.siemens.ad.pdraw.action.DeleteFigureAction;
import DE.siemens.ad.pdraw.action.InsertBlockAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import DE.siemens.ad.pdraw.figures.InputIfcFigure;
import DE.siemens.ad.pdraw.figures.OutputIfcFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.ConnectorConstraint;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.util.Iterator;
import java.util.Vector;

public class SubstituteBlockAction
extends CompositeUndoableAction {
    protected Vector fConnectedOutBlockConnectors;
    protected Vector fConnectedInBlockConnectors;
    public Block fNewBlock;
    protected BlockFigure fOldBlockFigure;
    protected LogoDrawing fOldDrawing;
    protected BlockFigure fInsertedFigure;

    public SubstituteBlockAction() {
        this.putValue("Name", "substitueBlock");
        this.putValue("textKey", "substitue.block");
    }

    public boolean doIt() {
        this.getDrawingView().clearSelection();
        return super.doIt();
    }

    public BlockFigure getNewBlockFigure() {
        return this.fInsertedFigure;
    }

    public boolean prepareAction() {
        ChangeConnectionAction cca;
        FixedElbowConnection fec;
        Iterator connections;
        int i;
        LogoComfort comfort = (LogoComfort)this.getOwner();
        LogoDrawingView drawingView = (LogoDrawingView)comfort.view();
        LogoDrawing drawing = (LogoDrawing)drawingView.drawing();
        Block oldBlock = this.fOldBlockFigure.getBlock();
        if (oldBlock.getClass() == this.fNewBlock.getClass()) {
            return false;
        }
        if (oldBlock == null || this.fNewBlock == null) {
            return false;
        }
        this.fInsertedFigure = new BlockFigure(this.fNewBlock, this.fOldBlockFigure.getImageFigure().displayBox().getLocation());
        InsertBlockAction insertAction = new InsertBlockAction();
        insertAction.setOwner(this.getOwner());
        insertAction.setBlockFigure(this.fInsertedFigure);
        Vector<ChangeConnectionAction> changeConnectionActions = new Vector<ChangeConnectionAction>();
        for (i = 0; i < oldBlock.getInConnectorCount(); ++i) {
            InputIfcFigure oldInputIfcFigure = this.fOldBlockFigure.getInputIfcFigure(oldBlock.getInConnector(i));
            connections = ((ConnectorConstraint)oldInputIfcFigure.getConstraint()).getConnectionLineConstraints().iterator();
            while (connections.hasNext()) {
                fec = (FixedElbowConnection)((ConnectionLineConstraint)connections.next()).getFigure();
                cca = new ChangeConnectionAction();
                cca.setOwner(this.getOwner());
                cca.setConnectionFigure(fec);
                cca.setOriginalStartConnector(fec.start());
                cca.setStartConnector(fec.start());
                cca.setEndConnector(this.fInsertedFigure.getInputIfcFigure(this.fNewBlock.getInConnector(i)).connectorAt(0, 0));
                cca.setOriginalEndConnector(fec.end());
                changeConnectionActions.add(cca);
            }
        }
        for (i = 0; i < oldBlock.getOutConnectorCount(); ++i) {
            OutputIfcFigure oldOutputIfcFigure = this.fOldBlockFigure.getOutputIfcFigure(oldBlock.getOutConnector(i));
            connections = ((ConnectorConstraint)oldOutputIfcFigure.getConstraint()).getConnectionLineConstraints().iterator();
            while (connections.hasNext()) {
                fec = (FixedElbowConnection)((ConnectionLineConstraint)connections.next()).getFigure();
                cca = new ChangeConnectionAction();
                cca.setOwner(this.getOwner());
                cca.setConnectionFigure(fec);
                cca.setOriginalStartConnector(fec.start());
                cca.setStartConnector(this.fInsertedFigure.getOutputIfcFigure(this.fNewBlock.getOutConnector(i)).connectorAt(0, 0));
                cca.setEndConnector(fec.end());
                cca.setOriginalEndConnector(fec.end());
                changeConnectionActions.add(cca);
            }
        }
        DeleteFigureAction deleteAction = new DeleteFigureAction();
        deleteAction.setOwner(this.getOwner());
        deleteAction.setConstraint(this.fOldBlockFigure.getConstraint());
        this.children.removeAllElements();
        this.children.add(insertAction);
        this.children.addAll(changeConnectionActions);
        this.children.add(deleteAction);
        return true;
    }

    public void setNewBlock(Block block) {
        this.fNewBlock = block;
    }

    public void setOldBlockFigure(BlockFigure figure) {
        this.fOldBlockFigure = figure;
    }
}

