/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.model.DrawingProperties;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.app.print.LogoPrinter;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Dimension;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;

public class SetupPageAction
extends UndoableAction {
    private PageFormat fOldPageFormat;
    private PageFormat fNewPageFormat;
    private Dimension fOldDrawingDimension;
    private Dimension fNewDrawingDimension;

    public SetupPageAction() {
        this.putValue("Name", "Seite einrichten");
        this.putValue("textKey", "file.setuppage");
        this.putValue("SmallIcon", this.getPlaceholder());
        this.putValue("ShortDescription", Language.getStringNoTilde("file.setuppage", "Page setup"));
    }

    public boolean prepareAction() {
        LogoDrawing logoDrawing = (LogoDrawing)this.getDrawingView().drawing();
        DrawingProperties drawingProperties = logoDrawing.getWiringDiagram().getDrawingProperties();
        this.fOldPageFormat = logoDrawing.getPageFormat();
        this.fOldDrawingDimension = new Dimension(drawingProperties.getPagesHorizontal(), drawingProperties.getPagesVertical());
        this.fNewPageFormat = this.editPageFormat(this.fOldPageFormat);
        if (this.fNewPageFormat != this.fOldPageFormat) {
            Dimension minDrawingDimension = this.getMinDrawingDimension(this.fNewPageFormat);
            this.fNewDrawingDimension = new Dimension(Math.max(minDrawingDimension.width, this.fOldDrawingDimension.width), Math.max(minDrawingDimension.height, this.fOldDrawingDimension.height));
            return true;
        }
        return false;
    }

    public boolean doIt() {
        this.setPageFormatInDrawing(this.fNewPageFormat, this.fNewDrawingDimension);
        return true;
    }

    private PageFormat editPageFormat(PageFormat pageFormat) {
        PrinterJob printerJob = LogoPrinter.getPrinterJob();
        printerJob.cancel();
        PageFormat newPageFormat = printerJob.pageDialog(pageFormat);
        return newPageFormat;
    }

    private void setPageFormatInDrawing(PageFormat newPageFormat, Dimension drawingDimension) {
        LogoDrawing drawing = (LogoDrawing)this.getDrawingView().drawing();
        drawing.setModified(true);
        this.getOwner().getWindow().toFront();
        drawing.setPageFormat(newPageFormat);
        Paper paper = newPageFormat.getPaper();
        LogoProperties props = LogoProperties.instance();
        props.setProperty("pageFormat.margin.left", "" + paper.getImageableX());
        props.setProperty("pageFormat.margin.top", "" + paper.getImageableY());
        props.setProperty("pageFormat.imagesize.width", "" + paper.getImageableWidth());
        props.setProperty("pageFormat.imagesize.height", "" + paper.getImageableHeight());
        props.setProperty("pageFormat.paper.height", "" + paper.getHeight());
        props.setProperty("pageFormat.paper.width", "" + paper.getWidth());
        props.setProperty("pageFormat.orientation", "" + newPageFormat.getOrientation());
        drawing.getWiringDiagram().getDrawingProperties().setPagesHorizontal(drawingDimension.width);
        drawing.getWiringDiagram().getDrawingProperties().setPagesVertical(drawingDimension.height);
    }

    private Dimension getMinDrawingDimension(PageFormat pageFormat) {
        LogoDrawing drawing = (LogoDrawing)this.getDrawingView().drawing();
        Dimension pageSize = drawing.computeImageableArea(pageFormat);
        Dimension minSize = drawing.getMinimumSize();
        int horizontalPages = minSize.width / pageSize.width + 1;
        int verticalPages = minSize.height / pageSize.height + 1;
        return new Dimension(horizontalPages, verticalPages);
    }

    public void undoIt() {
        this.setPageFormatInDrawing(this.fOldPageFormat, this.fOldDrawingDimension);
    }
}

