/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.util.Clipboard;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.ProgrammingLanguage;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.action.SubstituteBlockAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionConstraint;
import DE.siemens.ad.pdraw.figures.constraints.ConnectionLineConstraint;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.figures.constraints.MultiHeadConstraint;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.LogoGridConstrainer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class PasteAction
extends UndoableAction {
    protected ArrayList fBlockFigures;
    public Point pastePosition;
    public HashSet insertedConstraints;
    protected Vector fClipboardFigures = null;
    protected ProgramException fMessages;

    public PasteAction() {
        this.putValue("Name", "Einf\u00fcgen");
        this.putValue("textKey", "edit.paste");
        this.putValue("SmallIcon", Global.getIcon("Paste.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.paste", "paste"));
        this.disabledContextVector = new Vector(2);
        this.disabledContextVector.add(SimulationTool.class);
        this.disabledContextVector.add(OnlineTestTool.class);
    }

    protected void addError(String text) {
        if (this.fMessages == null) {
            this.fMessages = new ProgramException();
        }
        this.fMessages.setUser(text);
    }

    protected void addWarning(String text) {
        if (this.fMessages == null) {
            this.fMessages = new ProgramException();
        }
        this.fMessages.setLog(text);
    }

    protected Rectangle bounds(Enumeration k) {
        if (!k.hasMoreElements()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = ((Figure)k.nextElement()).displayBox();
        while (k.hasMoreElements()) {
            r.add(((Figure)k.nextElement()).displayBox());
        }
        return r;
    }

    public void deleteMessages() {
        if (this.fMessages != null) {
            this.fMessages = null;
        }
    }

    public void displayMessages() {
        if (this.fMessages != null) {
            Log.printStartSequence("msg.pasteAction", "Paste");
            this.fMessages.display(((LogoComfort)this.getOwner()).getApplicationSurface().getWindow(), null);
        }
    }

    public boolean doIt() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        this.insertFigures(this.insertedConstraints);
        this.moveToPastePosition(this.insertedConstraints);
        view.clearSelection();
        this.selectFigures(this.insertedConstraints);
        super.doIt();
        return true;
    }

    public Block[] getBlockArray() {
        ArrayList figures = this.getBlockFigures();
        int nrOfBlocks = figures.size();
        Block[] blocks = new Block[nrOfBlocks];
        for (int i = 0; i < nrOfBlocks; ++i) {
            blocks[i] = ((BlockFigure)figures.get(i)).getBlock();
        }
        return blocks;
    }

    public BlockFigure getBlockFigure(Block block) {
        ArrayList figures = this.getBlockFigures();
        int figureSize = figures.size();
        for (int j = 0; j < figureSize; ++j) {
            BlockFigure figure = (BlockFigure)figures.get(j);
            if (figure.getBlock() != block) continue;
            return figure;
        }
        return null;
    }

    private BlockFigure getBlockFigure(Vector blockFigures, String blockNumber) {
        Enumeration e = blockFigures.elements();
        BlockFigure blockFigure = null;
        while (e.hasMoreElements()) {
            blockFigure = (BlockFigure)e.nextElement();
            if (!blockFigure.getBlock().getNumberString().equals(blockNumber)) continue;
            return blockFigure;
        }
        return null;
    }

    public ArrayList getBlockFigures() {
        if (this.fBlockFigures == null) {
            this.fBlockFigures = new ArrayList();
            for (Figure f : this.fClipboardFigures) {
                if (!(f instanceof BlockFigure)) continue;
                this.fBlockFigures.add(f);
            }
        }
        return this.fBlockFigures;
    }

    public ArrayList getBlockFigures(ArrayList blockList) {
        ArrayList<BlockFigure> figures = new ArrayList<BlockFigure>();
        int size = blockList.size();
        for (int i = 0; i < size; ++i) {
            BlockFigure blockFigure = this.getBlockFigure((Block)blockList.get(i));
            if (blockFigure == null) continue;
            figures.add(blockFigure);
        }
        return figures;
    }

    public HashSet getConstraintsForFigures(Collection figures) {
        HashSet<FigureConstraint> constraints = new HashSet<FigureConstraint>(30);
        for (Figure figure : figures) {
            constraints.add(figure.getConstraint().getTopLevelConstraint());
            if (!(figure instanceof BlockFigure) || ((BlockFigure)figure).getCommentFigure() == null) continue;
            constraints.add(((BlockFigure)figure).getCommentFigure().getConstraint());
        }
        return constraints;
    }

    protected Vector getFiguresForConstraints(HashSet constraints) {
        Iterator i = constraints.iterator();
        Vector<Figure> figures = new Vector<Figure>();
        while (i.hasNext()) {
            FigureConstraint fc = (FigureConstraint)i.next();
            if (fc instanceof MultiHeadConstraint) {
                ((MultiHeadConstraint)fc).getFigures(figures);
                continue;
            }
            figures.add(fc.getFigure());
        }
        return figures;
    }

    public void insertFigures(HashSet constraints) {
        Drawing drawing = ((LogoComfort)this.getOwner()).drawing();
        Iterator i = constraints.iterator();
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            constraint = (FigureConstraint)i.next();
            constraint.insert(drawing);
        }
    }

    public void moveToPastePosition(HashSet constraints) {
        boolean viewToSmall;
        Rectangle bounds = this.bounds(this.getFiguresForConstraints(constraints).elements());
        LogoDrawingView view = (LogoDrawingView)((LogoComfort)this.getOwner()).view();
        LogoDrawing logoDrawing = (LogoDrawing)view.drawing();
        int moveLeft = 0;
        int moveUp = 0;
        Dimension viewDimension = logoDrawing.getViewSize100();
        if (this.pastePosition.x + bounds.width > viewDimension.width) {
            moveLeft = this.pastePosition.x + bounds.width - viewDimension.width;
        }
        if (this.pastePosition.y + bounds.height > viewDimension.height) {
            moveUp = this.pastePosition.y + bounds.height - viewDimension.height;
        }
        boolean bl = viewToSmall = moveLeft > this.pastePosition.x || moveUp > this.pastePosition.y;
        if (viewToSmall) {
            Dimension pageSize = logoDrawing.getPageDimension();
            Dimension minSize = logoDrawing.getMinimumSize();
            Object[] pageCount = new Object[]{new Integer(minSize.width / pageSize.width + 1), new Integer(minSize.height / pageSize.height + 1)};
            JOptionPane.showMessageDialog(view.getViewComponent(), Language.getString("error.dialog.tooLessPages", "Too less pages to see whole drawing. You need at least % horizontal and % vertical.", pageCount), Language.getStringNoTilde("edit.paste", "Paste"), 1);
        }
        moveUp = Math.min(moveUp, this.pastePosition.y);
        moveLeft = Math.min(moveLeft, this.pastePosition.x);
        Dimension moveVektor = new Dimension(this.pastePosition.x - bounds.x - moveLeft, this.pastePosition.y - bounds.y - moveUp);
        if (!this.fBlockFigures.isEmpty()) {
            Figure firstFigure = (Figure)this.fBlockFigures.get(0);
            firstFigure.getConstraint().doMove(moveVektor);
            Dimension correction = view.getSnapVector(firstFigure);
            firstFigure.getConstraint().doMove(new Dimension(-moveVektor.width, -moveVektor.height));
            moveVektor.width += correction.width;
            moveVektor.height += correction.height;
        }
        Iterator i = this.getFiguresForConstraints(constraints).iterator();
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            constraint = ((Figure)i.next()).getConstraint();
            if (constraint instanceof ConnectionLineConstraint) continue;
            constraint.doMove(moveVektor);
        }
        i = this.getFiguresForConstraints(constraints).iterator();
        while (i.hasNext()) {
            constraint = ((Figure)i.next()).getConstraint();
            if (!(constraint instanceof ConnectionLineConstraint)) continue;
            constraint.doMove(moveVektor);
        }
    }

    public Vector getClipboardFigures(FigureSelection figureSelection) {
        return (Vector)figureSelection.getData("CH.ifa.draw.Figures");
    }

    public boolean prepareAction() {
        Block[] blockArray;
        List unavailableBlocks;
        this.deleteMessages();
        FigureSelection figureSelection = (FigureSelection)Clipboard.getClipboard().getContents();
        if (figureSelection == null) {
            return false;
        }
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        WiringDiagram wd = ((LogoDrawing)view.drawing()).getWiringDiagram();
        this.fClipboardFigures = this.getClipboardFigures(figureSelection);
        this.fBlockFigures = null;
        this.pastePosition = view.lastClick();
        if (view.getConstrainer() instanceof LogoGridConstrainer) {
            this.pastePosition = ((LogoGridConstrainer)view.getConstrainer()).constrainPoint(this.pastePosition);
        }
        if (!(unavailableBlocks = this.getUnavailableBlocks(blockArray = this.getBlockArray(), wd)).isEmpty()) {
            String messageHeader = Language.getString("msg.paste.blockNotAvailable", "Could not insert.\nThe following blocks are not available in the\ncurrent hardware or programming language:");
            StringBuffer message = new StringBuffer(messageHeader);
            message.append("\n");
            Iterator i = unavailableBlocks.iterator();
            while (i.hasNext()) {
                message.append("\n- ");
                message.append(((Block)i.next()).getLocalizedName(true));
            }
            String infoTitle = Language.getStringNoTilde("edit.paste", "Paste");
            JOptionPane.showMessageDialog(this.getOwner().getWindow(), message.toString(), infoTitle, 1);
            return false;
        }
        this.connectBlocksOnModelSide(this.getConstraintsForFigures(this.fClipboardFigures), blockArray);
        HashMap dict = new HashMap();
        Hardware hardware = wd.getHardware();
        for (int i = 0; i < blockArray.length; ++i) {
            blockArray[i].deleteReferences(dict);
        }
        boolean insertError = wd.insert(blockArray, dict);
        if (dict.get("err") != null) {
            String error = (String)dict.get("err");
            if (error.equals("noResource")) {
                this.addError(Language.getString("msg.noresources", "There are not enough resources to insert the blocks"));
            } else {
                this.addError(Language.getString(error, error));
            }
            ArrayList errorList = (ArrayList)dict.get("errDescription");
            if (errorList != null) {
                for (ErrorInfo entry : errorList) {
                    ArrayList list = entry.getAdditionalInfo();
                    String leading = "";
                    if (list.size() > 0) {
                        if (list.get(0) instanceof Hardware) {
                            leading = ((Hardware)list.get(0)).getLocalizedName(true);
                        } else {
                            System.err.println("wiringDiagram.isBlockAvailable(Block,Hardware): Unknown additional Parameter");
                        }
                    }
                    this.addError(leading + ":\t" + entry.getSource().getLocalizedName(true) + "\t" + entry.getMessage());
                }
            }
            this.displayMessages();
            return false;
        }
        ArrayList list = (ArrayList)dict.get("propChanged");
        if (list != null) {
            this.updateBlockProperty(this.getBlockFigures(list), (ArrayList)dict.get("propChangedString"));
        }
        if ((list = (ArrayList)dict.get("substitute")) != null) {
            this.replaceFigures(list);
        }
        HashSet constraints = this.getConstraintsForFigures(this.fClipboardFigures);
        this.fBlockFigures = null;
        blockArray = this.getBlockArray();
        this.insertedConstraints = this.removeOpenConnections(constraints, blockArray);
        if (constraints.size() != this.insertedConstraints.size()) {
            this.addWarning(Language.getString("msg.notComplete", "Insert not complete.Open Connections!"));
        }
        this.displayMessages();
        return true;
    }

    public HashSet removeOpenConnections(HashSet constraints, Block[] blockArray) {
        Vector<Block> blocks = new Vector<Block>();
        for (int i = 0; i < blockArray.length; ++i) {
            blocks.add(blockArray[i]);
        }
        HashSet<FigureConstraint> constraintsWithoutOpenConnectoins = new HashSet<FigureConstraint>(30);
        Iterator i = constraints.iterator();
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            constraint = (FigureConstraint)i.next();
            if (constraint instanceof ConnectionConstraint) {
                ConnectionConstraint connectionConstraint = (ConnectionConstraint)((Object)constraint);
                if (connectionConstraint.getInBlockConnector() != null && connectionConstraint.getOutBlockConnector() != null && blocks.contains(connectionConstraint.getInBlockConnector().getOwner()) && blocks.contains(connectionConstraint.getOutBlockConnector().getOwner())) {
                    constraintsWithoutOpenConnectoins.add(constraint);
                    connectionConstraint.connectInModel();
                    continue;
                }
                constraint.delete();
                continue;
            }
            constraintsWithoutOpenConnectoins.add(constraint);
        }
        return constraintsWithoutOpenConnectoins;
    }

    private void connectBlocksOnModelSide(HashSet constraints, Block[] blockArray) {
        Vector<Block> blocks = new Vector<Block>();
        for (int i = 0; i < blockArray.length; ++i) {
            blocks.add(blockArray[i]);
        }
        Iterator i = constraints.iterator();
        FigureConstraint constraint = null;
        while (i.hasNext()) {
            ConnectionConstraint connectionConstraint;
            constraint = (FigureConstraint)i.next();
            if (!(constraint instanceof ConnectionConstraint) || (connectionConstraint = (ConnectionConstraint)((Object)constraint)).getInBlockConnector() == null || connectionConstraint.getOutBlockConnector() == null || !blocks.contains(connectionConstraint.getInBlockConnector().getOwner()) || !blocks.contains(connectionConstraint.getOutBlockConnector().getOwner())) continue;
            connectionConstraint.connectInModel();
        }
    }

    protected boolean replaceFigures(AbstractList list) {
        SubstituteBlockAction substitueBlockAction = new SubstituteBlockAction();
        LogoDrawingView view = this.getDrawingView();
        substitueBlockAction.setOwner((Editor)((Object)view.editor()));
        Iterator itr = list.iterator();
        this.addWarning(Language.getString("msg.blockSubstitute", "Blocks substituted"));
        try {
            while (itr.hasNext()) {
                Block oldBlock = (Block)itr.next();
                Block newBlock = (Block)itr.next();
                StringBuffer buffer = new StringBuffer();
                buffer.append(oldBlock.getLocalizedName(true));
                buffer.append("\t-->\t");
                buffer.append(newBlock.getLocalizedName(true));
                this.addWarning(buffer.toString());
                BlockFigure oldBlockFigure = this.getBlockFigure(oldBlock);
                substitueBlockAction.setOldBlockFigure(oldBlockFigure);
                substitueBlockAction.setNewBlock(newBlock);
                substitueBlockAction.prepareAction();
                substitueBlockAction.doIt();
                this.fClipboardFigures.remove(oldBlockFigure);
                this.fClipboardFigures.add(substitueBlockAction.getNewBlockFigure());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void selectFigures(HashSet insertedConstraints) {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        Vector figures = this.getFiguresForConstraints(insertedConstraints);
        Iterator i = figures.iterator();
        while (i.hasNext()) {
            view.addToSelection((Figure)i.next());
        }
    }

    public void undoIt() {
        LogoComfort logoComfort = (LogoComfort)this.getOwner();
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        WiringDiagram wiringDiagram = ((LogoDrawing)logoComfort.drawing()).getWiringDiagram();
        view.clearSelection();
        Iterator i = this.insertedConstraints.iterator();
        while (i.hasNext()) {
            ((FigureConstraint)i.next()).delete();
        }
        view.checkDamage();
    }

    public void updateBlockProperty(ArrayList blockList) {
        Iterator itr = blockList.iterator();
        Object dict = null;
        BlockFigure blockFigure = null;
        Block block = null;
        this.addWarning(Language.getString("msg.blockPropertyChanged", "Blockproperty changed:"));
        while (itr.hasNext()) {
            blockFigure = (BlockFigure)itr.next();
            block = blockFigure.getBlock();
            this.addWarning(block.getLocalizedName(true));
            blockFigure.getBlockTextFigure().setText(block.getNumberString());
            if (block.getParameter() == null) continue;
            BlockParameter param = block.getParameter();
            blockFigure.parameterSet(param, param.getParameterText());
        }
    }

    public void updateBlockProperty(ArrayList blockList, ArrayList changes) {
        Object dict = null;
        BlockFigure blockFigure = null;
        Block block = null;
        this.addWarning(Language.getString("msg.blockPropertyChanged", "Blockproperty changed:"));
        int size = blockList.size();
        for (int i = 0; i < size; ++i) {
            blockFigure = (BlockFigure)blockList.get(i);
            block = blockFigure.getBlock();
            try {
                this.addWarning(block.getLocalizedName(true) + ": " + (String)changes.get(i));
            }
            catch (Exception e) {
                System.out.println("Zu wenig Beschreibungen");
                e.printStackTrace();
            }
            blockFigure.getBlockTextFigure().setText(block.getNumberString());
            if (block.getParameter() == null) continue;
            BlockParameter param = block.getParameter();
            blockFigure.parameterSet(param, param.getParameterText());
        }
    }

    protected List getUnavailableBlocks(Block[] blocks, WiringDiagram wiringDiagram) {
        ArrayList<Block> notAvailableBlocks = new ArrayList<Block>();
        ProgrammingLanguage programmingLanguage = wiringDiagram.getProgrammingLanguage();
        Hardware hardware = wiringDiagram.getHardware();
        for (int i = 0; i < blocks.length; ++i) {
            if (programmingLanguage.isBlockAvailable(blocks[i], hardware)) continue;
            notAvailableBlocks.add(blocks[i]);
        }
        return notAvailableBlocks;
    }
}

