/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.figures.BlockIfcFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.util.Vector;

public class NegateConnectorAction
extends UndoableAction {
    protected BlockIfcFigure fBlockIfcFigure;

    public NegateConnectorAction() {
        this.putValue("Name", "edit.negateConnector");
        this.putValue("textKey", "edit.negateConnector");
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.negateConnector", "Negate connector"));
    }

    public boolean doIt() {
        BlockConnector blockConnector = this.fBlockIfcFigure.getBlockConnector();
        this.fBlockIfcFigure.willChange();
        blockConnector.setNegated(!blockConnector.isNegated());
        this.fBlockIfcFigure.changed();
        ((LogoDrawing)this.getDrawingView().drawing()).setModified(true);
        return super.doIt();
    }

    public boolean prepareAction() {
        LogoDrawing logoDrawing = (LogoDrawing)this.getDrawingView().drawing();
        Vector selection = this.getDrawingView().selection();
        if (selection.isEmpty() || selection.size() > 1 || !(selection.elementAt(0) instanceof BlockIfcFigure)) {
            return false;
        }
        this.fBlockIfcFigure = (BlockIfcFigure)selection.elementAt(0);
        BlockConnector blockConnector = this.fBlockIfcFigure.getBlockConnector();
        if (!blockConnector.isNegatable()) {
            return false;
        }
        this.getDrawingView().clearSelection();
        return true;
    }

    public void undoIt() {
        BlockConnector blockConnector = this.fBlockIfcFigure.getBlockConnector();
        this.fBlockIfcFigure.willChange();
        blockConnector.setNegated(!blockConnector.isNegated());
        this.fBlockIfcFigure.changed();
        super.undoIt();
    }

    public BlockIfcFigure getBlockIfcFigure() {
        return this.fBlockIfcFigure;
    }

    public void setBlockIfcFigure(BlockIfcFigure figure) {
        this.fBlockIfcFigure = figure;
    }
}

