/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.ReverseFigureEnumerator;
import DE.siemens.ad.logo.app.action.UndoableAction;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.util.Enumeration;
import java.util.Vector;

public class MarkedToFrontAction
extends UndoableAction {
    protected Vector selectedFigures = new Vector();
    protected Vector indicesOfFigures = new Vector();

    public MarkedToFrontAction() {
        this.putValue("Name", "Marked to front");
        this.putValue("textKey", "edit.marktofront");
        this.putValue("SmallIcon", this.getPlaceholder());
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.marktofront", "markedToBack"));
    }

    public boolean doIt() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        Figure f = null;
        this.indicesOfFigures.removeAllElements();
        Enumeration selectedFiguresEnumeration = this.selectedFigures.elements();
        while (selectedFiguresEnumeration.hasMoreElements()) {
            f = (Figure)selectedFiguresEnumeration.nextElement();
            this.indicesOfFigures.add(new Integer(drawing.getIndexOfFigure(f)));
            drawing.bringToFront(f);
        }
        super.doIt();
        return true;
    }

    public boolean prepareAction() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        ReverseFigureEnumerator k = new ReverseFigureEnumerator(view.selectionZOrdered());
        this.selectedFigures.removeAllElements();
        while (k.hasMoreElements()) {
            this.selectedFigures.add(k.nextElement());
        }
        return true;
    }

    public void undoIt() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        for (int i = this.selectedFigures.size() - 1; i >= 0; --i) {
            drawing.setIndexOfFigure((Figure)this.selectedFigures.elementAt(i), (Integer)this.indicesOfFigures.elementAt(i));
        }
        view.checkDamage();
    }
}

