/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.action.CompositeUndoableAction;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.DeleteFigureAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.constraints.FigureConstraint;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DeleteFiguresAction
extends CompositeUndoableAction {
    protected Point moveAmount;
    protected Vector selectedFigures;

    public DeleteFiguresAction() {
        this.putValue("Name", "L\u00f6schen");
        this.putValue("textKey", "edit.delete");
        this.putValue("SmallIcon", Global.getIcon("Delete.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("edit.delete", "delete"));
        this.disabledContextVector = new Vector(1);
        this.disabledContextVector.add(SimulationTool.class);
    }

    public boolean doIt() {
        LogoComfort logoComfort = (LogoComfort)this.getOwner();
        logoComfort.view().clearSelection();
        if (!super.doIt()) {
            return false;
        }
        ((LogoDrawing)logoComfort.drawing()).getWiringDiagram().verifyMessageLineParameterReferences();
        return true;
    }

    public boolean prepareAction() {
        this.children.removeAllElements();
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        LogoDrawing drawing = (LogoDrawing)view.drawing();
        WiringDiagram wd = drawing.getWiringDiagram();
        this.selectedFigures = (Vector)view.selection().clone();
        List constraintsToDelete = this.getConstraintsToDelete(this.selectedFigures, drawing);
        Iterator i = constraintsToDelete.iterator();
        while (i.hasNext()) {
            DeleteFigureAction deleteFigureAction = new DeleteFigureAction();
            deleteFigureAction.setOwner(this.getOwner());
            deleteFigureAction.setConstraint((FigureConstraint)i.next());
            this.children.add(deleteFigureAction);
        }
        return true;
    }

    public List getConstraintsToDelete(Vector selectedFigures, Drawing drawing) {
        ArrayList<FigureConstraint> constraints = new ArrayList<FigureConstraint>(30);
        Iterator i = selectedFigures.iterator();
        FigureConstraint fc = null;
        while (i.hasNext()) {
            fc = ((Figure)i.next()).getConstraint().getTopLevelConstraint();
            if (constraints.contains(fc)) continue;
            constraints.add(fc);
        }
        return constraints;
    }

    public void undoIt() {
        super.undoIt();
        ((LogoDrawing)((LogoComfort)this.getOwner()).drawing()).updateConnections();
    }
}

