/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import java.awt.Window;
import java.util.Collections;
import javax.swing.JOptionPane;

public class ClearProgAction
extends LogoAction {
    private static final long serialVersionUID = 8662953106878382294L;
    public static final String SUP_CLEAR_PROG = "supportClearUserProgram";

    public ClearProgAction() {
        this.putValue("Name", "clearProg");
        this.putValue("textKey", "extra.clearProg");
        this.putValue("SmallIcon", this.getPlaceholder());
        this.disabledContextVector = Collections.singletonList(OnlineTestTool.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIt() {
        Window window = ((LogoComfort)this.getOwner()).getApplicationSurface().getWindow();
        boolean result = false;
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            Hardware hw = dt.getHardware();
            if (hw.supports(SUP_CLEAR_PROG)) {
                if (dt.isTransmissionPossible(window)) {
                    result = this.clearProg(window, dt);
                }
            } else {
                JOptionPane.showMessageDialog(window, Language.getString("extra.clearProg.notAvailable", "Function not available", hw.getLocalizedName(false)));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (dt != null) {
                dt.closePort();
            }
        }
        if (result) {
            new LogoError(window, "extra.clearProg.succeed", "Clear user program ok.", 1).display();
        }
        return result;
    }

    private boolean clearProg(Window window, DataTransfer dt) throws TransmissionFailedException {
        LogoError dlg = new LogoError(null, "extra.clearProg.comfirm", "Are you sure?", 2, 2);
        dlg.setHelpKey("extra.clearProg");
        int rv = dlg.display();
        if (rv == 2) {
            boolean ret = dt.sendCommand(32);
            dt.waitUntilDeviceReady(5, 2, false);
            return ret;
        }
        return false;
    }

    public boolean needsWaitCursor() {
        return false;
    }

    public synchronized void setEnabled(boolean newValue) {
        if (Version.getCurrentVersion().isDemoVersion()) {
            super.setEnabled(false);
        } else {
            super.setEnabled(newValue);
        }
    }
}

