/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.action.CompositeUndoableAction;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.MoveFigureAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.util.FigureXPositionComparator;
import DE.siemens.ad.pdraw.util.FigureYPositionComparator;
import java.awt.Dimension;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class AlignBlocksAutomaticallyAction
extends CompositeUndoableAction {
    public static final int X_TOLERANCE = 30;
    public static final int Y_TOLERANCE = 50;

    public AlignBlocksAutomaticallyAction() {
        this.putValue("Name", "align automatically");
        this.putValue("textKey", "format.align.automatically");
        this.putValue("SmallIcon", Global.getIcon("AlignAuto.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("format.align.automatically", "align automatically"));
    }

    public Vector getFiguresInColumn(Figure anchorFigure, Vector figures) {
        Vector<Figure> figuresInColumn = new Vector<Figure>();
        Enumeration e = figures.elements();
        Figure f = null;
        while (e.hasMoreElements()) {
            f = (Figure)e.nextElement();
            if (Math.abs(f.displayBox().x + f.displayBox().width - (anchorFigure.displayBox().x + anchorFigure.displayBox().width)) >= 30) continue;
            figuresInColumn.add(f);
        }
        return figuresInColumn;
    }

    public Vector getFiguresInRow(Figure anchorFigure, Vector figures) {
        Vector<Figure> figuresInRow = new Vector<Figure>();
        Enumeration e = figures.elements();
        Figure f = null;
        while (e.hasMoreElements()) {
            f = (Figure)e.nextElement();
            if (!(Math.abs(f.displayBox().getY() - anchorFigure.displayBox().getY()) < 50.0)) continue;
            figuresInRow.add(f);
        }
        return figuresInRow;
    }

    public void moveToXPosition(Vector figures, int position) {
        Enumeration e = figures.elements();
        Figure f = null;
        MoveFigureAction moveAction = null;
        while (e.hasMoreElements()) {
            f = (Figure)e.nextElement();
            moveAction = new MoveFigureAction();
            moveAction.setOwner(this.getOwner());
            moveAction.setFigure(f);
            moveAction.setMoveVector(new Dimension(position - (f.displayBox().x + f.displayBox().width), 0));
            this.children.add(moveAction);
        }
    }

    public void moveToYPosition(Vector figures, int position) {
        Enumeration e = figures.elements();
        Figure f = null;
        MoveFigureAction moveAction = null;
        while (e.hasMoreElements()) {
            f = (Figure)e.nextElement();
            moveAction = new MoveFigureAction();
            moveAction.setOwner(this.getOwner());
            moveAction.setFigure(f);
            moveAction.setMoveVector(new Dimension(0, position - f.displayBox().y));
            this.children.add(moveAction);
        }
    }

    public boolean prepareAction() {
        this.children.removeAllElements();
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        Vector<Figure> selectedBlockFigures = new Vector<Figure>();
        Enumeration selectedFigures = view.selection().elements();
        Figure f = null;
        while (selectedFigures.hasMoreElements()) {
            f = (Figure)selectedFigures.nextElement();
            if (!(f instanceof BlockFigure)) continue;
            selectedBlockFigures.add(f);
        }
        if (selectedBlockFigures.isEmpty()) {
            return false;
        }
        Vector alignX = (Vector)selectedBlockFigures.clone();
        Collections.sort(alignX, new FigureXPositionComparator());
        while (!alignX.isEmpty()) {
            BlockFigure leftMostFigure = (BlockFigure)alignX.elementAt(0);
            Vector columnFigures = this.getFiguresInColumn(leftMostFigure, alignX);
            Collections.sort(columnFigures, new FigureYPositionComparator());
            BlockFigure anchorFigure = (BlockFigure)columnFigures.elementAt(0);
            columnFigures = this.getFiguresInColumn(anchorFigure, alignX);
            this.moveToXPosition(columnFigures, anchorFigure.displayBox().x + anchorFigure.displayBox().width);
            alignX.removeAll(columnFigures);
        }
        Vector alignY = (Vector)selectedBlockFigures.clone();
        Collections.sort(alignY, new FigureYPositionComparator());
        while (!alignY.isEmpty()) {
            BlockFigure upMostFigure = (BlockFigure)alignY.elementAt(0);
            Vector rowFigures = this.getFiguresInRow(upMostFigure, alignY);
            Collections.sort(rowFigures, new FigureXPositionComparator());
            BlockFigure anchorFigure = (BlockFigure)rowFigures.elementAt(0);
            rowFigures = this.getFiguresInRow(anchorFigure, alignY);
            this.moveToYPosition(rowFigures, anchorFigure.displayBox().y);
            alignY.removeAll(rowFigures);
        }
        return super.prepareAction();
    }
}

