/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.action.CompositeUndoableAction;
import DE.siemens.ad.logo.model.block.VirtualOutputBlock;
import DE.siemens.ad.pdraw.action.MoveFigureAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.FixedElbowConnection;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;

public class AlignAction
extends CompositeUndoableAction {
    public static final int LEFTS = 0;
    public static final int RIGHTS = 1;
    public static final int BOTTOMS = 2;
    public static final int TOPS = 3;
    public static final int CENTERS = 4;
    public static final int MIDDLES = 5;
    protected int orientation = 0;

    public boolean prepareAction() {
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        this.children.removeAllElements();
        Enumeration selection = this.prepareSelection(view.selection()).elements();
        Point anchorPoint = null;
        Rectangle anchorRect = null;
        while (selection.hasMoreElements()) {
            Figure anchorFigure = (Figure)selection.nextElement();
            if (anchorFigure instanceof FixedElbowConnection) continue;
            anchorRect = this.getRectangle(anchorFigure);
            anchorPoint = anchorFigure.getAlignmentAnchor();
            break;
        }
        Figure figure = null;
        Dimension moveVector = null;
        MoveFigureAction moveAction = null;
        while (selection.hasMoreElements()) {
            figure = (Figure)selection.nextElement();
            if (figure instanceof FixedElbowConnection) continue;
            Rectangle rr = this.getRectangle(figure);
            Point currentAnchorPoint = figure.getAlignmentAnchor();
            switch (this.orientation) {
                case 0: {
                    moveVector = new Dimension(anchorRect.x - rr.x, 0);
                    break;
                }
                case 4: {
                    moveVector = new Dimension(anchorRect.x + anchorRect.width / 2 - (rr.x + rr.width / 2), 0);
                    break;
                }
                case 1: {
                    moveVector = new Dimension(anchorPoint.x - currentAnchorPoint.x, 0);
                    break;
                }
                case 3: {
                    moveVector = new Dimension(0, anchorRect.y - rr.y);
                    break;
                }
                case 5: {
                    moveVector = new Dimension(0, anchorRect.y + anchorRect.height / 2 - (rr.y + rr.height / 2));
                    break;
                }
                case 2: {
                    moveVector = new Dimension(0, anchorRect.y + anchorRect.height - (rr.y + rr.height));
                }
            }
            moveAction = new MoveFigureAction();
            moveAction.setOwner(this.getOwner());
            moveAction.setFigure(figure);
            moveAction.setMoveVector(moveVector);
            this.children.add(moveAction);
        }
        return super.prepareAction();
    }

    private Rectangle getRectangle(Figure figure) {
        Rectangle rect = figure.displayBox();
        if (figure instanceof BlockFigure && ((BlockFigure)figure).getBlock() instanceof VirtualOutputBlock) {
            rect.width += 6;
        }
        return rect;
    }

    public void setOrientation(int newOrientation) {
        this.orientation = newOrientation;
    }
}

