/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.Configuration;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;
import java.util.StringTokenizer;

public class Version
implements Comparable,
Serializable {
    static final long serialVersionUID = -2499518721308927695L;
    private int serializedDataVersion = 2;
    private static final int MAJOR_VERSION = 6;
    private static final int MINOR_VERSION = 1;
    private static final int BUILD_VERSION = 16;
    private static final String BUILD_TIME = "2010-04-15 09-37";
    private static final String VERSION_ADDON = "";
    private int majorVersion;
    private int minorVersion;
    private int buildVersion;
    private String buildTime;
    private Configuration fConfiguration;
    private String fApplicationFileName;
    private static Version cCurrentVersion;
    private String fVersionAddon = "";

    public Version() {
        this(6, 1, 16);
        this.buildTime = BUILD_TIME;
        this.fVersionAddon = VERSION_ADDON;
    }

    public Configuration getConfiguration() {
        if (this.fConfiguration == null) {
            this.fConfiguration = Configuration.getCurrentConfiguration();
        }
        return this.fConfiguration;
    }

    public Version(int majorVersion, int minorVersion, int buildVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.buildVersion = buildVersion;
    }

    public Version(String versionString) {
        this.parseVersion(versionString);
    }

    public int compareTo(Object comparedObject) {
        Version comparedVersion = (Version)comparedObject;
        if (this.majorVersion < comparedVersion.getMajorVersion()) {
            return -1;
        }
        if (this.majorVersion > comparedVersion.getMajorVersion()) {
            return 1;
        }
        if (this.minorVersion < comparedVersion.getMinorVersion()) {
            return -1;
        }
        if (this.minorVersion > comparedVersion.getMinorVersion()) {
            return 1;
        }
        if (this.buildVersion < comparedVersion.getBuildVersion()) {
            return -1;
        }
        if (this.buildVersion > comparedVersion.getBuildVersion()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.compareTo(version) == 0;
    }

    public final String getApplicationExtension() {
        int configurationID = this.getConfiguration().getConfigurationID();
        if (configurationID >= 0 && configurationID < Configuration.TYPE_KEY.length) {
            String key = Configuration.TYPE_KEY[configurationID];
            return Language.getString(key, key);
        }
        return VERSION_ADDON;
    }

    public String getApplicationFileName() {
        if (this.fApplicationFileName == null) {
            Properties properties = null;
            FileInputStream appStream = null;
            String propertyFileName = "Language.properties";
            propertyFileName = LogoProperties.findFileInClassPath(propertyFileName);
            try {
                properties = new Properties();
                appStream = new FileInputStream(propertyFileName);
                properties.load(appStream);
                appStream.close();
            }
            catch (IOException ioe) {
                System.out.println("loading Language.properties failed");
            }
            String name = properties.getProperty("app.fileName");
            if (name == null) {
                System.out.println("Eintrag app.fileName in " + propertyFileName + " nicht gefunden");
                name = properties.getProperty("app.name.long", VERSION_ADDON);
            }
            this.fApplicationFileName = name;
        }
        return this.fApplicationFileName;
    }

    public int getBuildVersion() {
        return this.buildVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public final String getVersionAddon() {
        return this.fVersionAddon;
    }

    public final boolean isDemoVersion() {
        return this.getConfiguration().isDemoVersion();
    }

    public final boolean isFullVersion() {
        return this.getConfiguration().isFullVersion();
    }

    public final boolean isOEMVersion() {
        return !this.getConfiguration().getCompany().equalsIgnoreCase("Siemens");
    }

    public final boolean isTestVersion() {
        return this.getConfiguration().isTestVersion();
    }

    public boolean isValidVersion() {
        return this.majorVersion >= 0 && this.minorVersion >= 0 && this.buildVersion >= 0;
    }

    protected void parseVersion(String versionString) {
        if (versionString.toLowerCase().startsWith("v")) {
            versionString = versionString.substring(1);
        }
        StringTokenizer st = new StringTokenizer(versionString, ".");
        try {
            String s = st.nextToken();
            this.majorVersion = Integer.parseInt(s);
            s = st.nextToken();
            this.minorVersion = Integer.parseInt(s);
            s = st.nextToken();
            this.buildVersion = Integer.parseInt(s);
        }
        catch (Exception nfe) {
            nfe.printStackTrace();
            this.majorVersion = -1;
            this.minorVersion = -1;
            this.buildVersion = -1;
        }
    }

    public void setBuildVersion(int newBuildVersion) {
        this.buildVersion = newBuildVersion;
    }

    public void setMajorVersion(int newMajorVersion) {
        this.majorVersion = newMajorVersion;
    }

    public void setMinorVersion(int newMinorVersion) {
        this.minorVersion = newMinorVersion;
    }

    public void setVersion(String versionString) {
        this.parseVersion(versionString);
    }

    public String toString() {
        StringBuffer versionString = new StringBuffer();
        versionString.append('V');
        versionString.append(this.majorVersion);
        versionString.append('.');
        versionString.append(this.minorVersion);
        versionString.append('.');
        versionString.append(this.buildVersion);
        return versionString.toString();
    }

    public static Version getCurrentVersion() {
        if (cCurrentVersion == null) {
            cCurrentVersion = new Version();
        }
        return cCurrentVersion;
    }

    public String getBuildTime() {
        return this.buildTime;
    }
}

