/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.StatusLine;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ProgramException
extends Exception {
    private Hashtable hash = null;
    private Exception fOriginalException = null;
    private boolean fShowDialog = true;
    private static final String USER = "USER";
    private static final String EXPERT = "EXPERT";
    private static final String LOG = "LOG";

    public ProgramException() {
    }

    public ProgramException(String s) {
        this();
        this.setUser(s);
    }

    public void display(Window parent, StatusLine statusLine) {
        String s = this.getLog();
        if (s == null) {
            s = this.getUser();
        }
        if (s != null) {
            Log.println(s);
        }
        if (this.getExpert() != null) {
            System.out.println(this.getExpert());
        }
        if ((s = this.getUser()) != null) {
            if (statusLine != null) {
                statusLine.setText(this.getLastLine(USER));
            }
            if (this.fShowDialog) {
                new LogoError(parent, s).display();
            }
        }
    }

    public String get(String key) {
        Vector vec;
        String value = null;
        if (this.hash != null && (vec = (Vector)this.hash.get(key)) != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < vec.size(); ++i) {
                buffer.append((String)vec.elementAt(i) + "\n");
            }
            value = buffer.substring(0, buffer.length() - 1);
        }
        return value;
    }

    public String getExpert() {
        return this.get(EXPERT);
    }

    public Vector getKeys() {
        Vector ret = new Vector();
        if (this.hash != null) {
            Enumeration enumeration = this.hash.keys();
            while (enumeration.hasMoreElements()) {
                ret.add(enumeration.nextElement());
            }
        }
        return ret;
    }

    public String getLastLine(String key) {
        Vector v;
        String value = null;
        if (this.hash != null && (v = (Vector)this.hash.get(key)) != null) {
            try {
                value = (String)v.elementAt(v.size() - 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public String getLog() {
        return this.get(LOG);
    }

    public Exception getOriginalException() {
        if (this.fOriginalException != null) {
            return this.fOriginalException;
        }
        return null;
    }

    public String getUser() {
        return this.get(USER);
    }

    public boolean isKey(String key) {
        return this.hash != null && this.hash.get(key) != null;
    }

    public void newKey(String key) {
        if (this.hash == null) {
            this.hash = new Hashtable(20);
        }
        Vector vec = new Vector();
        this.hash.put(key, vec);
    }

    public void set(String exception, String key) {
        Vector<String> vec;
        if (this.hash == null) {
            this.hash = new Hashtable(20);
        }
        if ((vec = (Vector<String>)this.hash.get(key)) == null) {
            vec = new Vector<String>();
        }
        vec.add(exception);
        this.hash.put(key, vec);
    }

    public void setDialog(boolean visible) {
        this.fShowDialog = visible;
    }

    public ProgramException setExpert(String fehlerText) {
        this.set(fehlerText, EXPERT);
        return this;
    }

    public ProgramException setLog(String text) {
        this.set(text, LOG);
        return this;
    }

    public void setOriginalException(Exception exception) {
        if (this.fOriginalException == null) {
            this.fOriginalException = new Exception();
            this.fOriginalException = exception;
        }
    }

    public ProgramException setUser(String text) {
        this.set(text, USER);
        this.set(text, LOG);
        return this;
    }

    public String toString() {
        String ret = "";
        Vector keys = this.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            ret = ret + (String)keys.elementAt(i) + "\t: ";
            String value = "";
            Object element = this.hash.get(keys.elementAt(i));
            if (element instanceof Vector) {
                Vector fehlerText = (Vector)element;
                for (int d = 0; d < fehlerText.size(); ++d) {
                    String meldung = (String)fehlerText.elementAt(d);
                    value = value + meldung + " ; ";
                }
            }
            ret = ret + value + "\n";
        }
        return ret;
    }
}

