/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Memory8;

public class MessageMemory8
extends Memory8 {
    protected boolean fAllByteAtOnce = false;

    public boolean isAllByteAtOnce() {
        return this.fAllByteAtOnce;
    }

    public void setAllByteAtOnce(boolean allByteAtOnce) {
        this.fAllByteAtOnce = allByteAtOnce;
    }

    protected MessageMemory8() {
    }

    public MessageMemory8(int startAdresse, int memorySize) throws IllegalArgumentException {
        this("Meldetext", startAdresse, memorySize, 12);
    }

    public MessageMemory8(String name, int startAdresse, int memorySize) throws IllegalArgumentException {
        this(name, startAdresse, memorySize, 12);
    }

    public MessageMemory8(String name, int startAdresse, int memorySize, int blockSize) throws IllegalArgumentException {
        super(name, startAdresse, memorySize, blockSize);
    }

    public void download(DataTransfer dt) throws TransmissionFailedException {
        if (this.isAllByteAtOnce()) {
            super.download(dt);
        } else {
            int BLOCK_LEN = 16;
            int[] memory = this.asArray();
            int[] memoryBlock = new int[16];
            int endAdress = this.fTansferStartAdress + memory.length;
            int srcAdress = 0;
            for (int adress = this.fTansferStartAdress; adress < endAdress; adress += 16) {
                System.arraycopy(memory, srcAdress, memoryBlock, 0, 16);
                srcAdress += 16;
                dt.writeByteArray(adress, memoryBlock);
            }
        }
    }

    public Memory init() {
        this.init(0);
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.fMemory[i][0] = 255;
        }
        this.fBlockIndex = 0;
        this.fByteIndex = 0;
        return this;
    }

    public void upload(DataTransfer dt) throws TransmissionFailedException {
        if (this.isAllByteAtOnce()) {
            super.upload(dt);
        } else {
            int BLOCK_LEN = 16;
            int endAdress = this.fTansferStartAdress + this.size() * this.getBlockSize();
            int[] data = null;
            this.setPosition(0, 0);
            for (int adress = this.fTansferStartAdress; adress < endAdress; adress += 16) {
                data = dt.readByteArray(adress, 16);
                for (int i = 0; i < 16; ++i) {
                    this.put(data[i]);
                }
            }
        }
    }
}

