/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.SpecialCharacterDisplayElement;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.ParameterUpdateListener;
import DE.siemens.ad.logo.util.MessageLineInterface;
import DE.siemens.ad.logo.util.MessageListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class MessageLine
implements MessageLineInterface,
Serializable,
Storable,
Cloneable,
ParameterUpdateListener,
ParameterSetListener {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 2;
    protected String fText = "";
    protected BlockParameter fBlockParameter;
    protected int fParameterPosition;
    protected int fParameterNumber;
    private int fLineNumber;
    protected String fParameterItemIdentifier;
    private transient Vector fMessageChangedListeners;

    public MessageLine() {
    }

    public MessageLine(int newLineNumber) {
        this();
        this.setLineNumber(newLineNumber);
    }

    public void addAsParameterListener() {
        if (this.fBlockParameter != null) {
            this.fBlockParameter.addParameterUpdateListener(this);
            this.fBlockParameter.addParameterSetListener(this);
        }
    }

    public synchronized void addMessageChangedListener(MessageListener listener) {
        if (this.fMessageChangedListeners == null) {
            this.fMessageChangedListeners = new Vector();
        }
        if (!this.fMessageChangedListeners.contains(listener)) {
            this.fMessageChangedListeners.add(listener);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void copyFrom(MessageLineInterface sourceImp, boolean registerListeners) {
        MessageLine source = (MessageLine)sourceImp;
        if (registerListeners) {
            this.removeAsParameterListener();
        }
        this.setBlockParameter(source.getBlockParameter());
        this.setLineNumber(source.getLineNumber());
        this.setParameterPosition(source.getParameterPosition());
        this.setParameterItemIdentifier(source.getParameterItemIdentifier());
        this.setText(source.getText());
        if (registerListeners) {
            this.addAsParameterListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageChanged() {
        if (this.fMessageChangedListeners != null) {
            Vector l;
            MessageLine messageLine = this;
            synchronized (messageLine) {
                l = (Vector)this.fMessageChangedListeners.clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                ((MessageListener)l.elementAt(i)).messageChanged(this);
            }
        }
    }

    public BlockParameter getBlockParameter() {
        return this.fBlockParameter;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public Vector getMessageChangedListener() {
        return this.fMessageChangedListeners;
    }

    public int getParameterNumber() {
        if (this.fBlockParameter != null) {
            return this.fBlockParameter.getParameterItem(this.getParameterItemIdentifier()).getParameterNumber();
        }
        return -1;
    }

    public ParameterItem getParameterItem() {
        if (this.fBlockParameter != null && this.fParameterItemIdentifier != null) {
            return this.fBlockParameter.getParameterItem(this.getParameterItemIdentifier());
        }
        return null;
    }

    public String getText() {
        if (this.fText == null) {
            this.fText = " ";
        }
        return this.fText;
    }

    public boolean hasParameter() {
        return this.getBlockParameter() != null;
    }

    public boolean isEmpty() {
        return this.getText().trim().equals("");
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        this.fireMessageChanged();
    }

    public void parameterUpdated(ParameterUpdateEvent pue) {
        this.fireMessageChanged();
    }

    public void read(StorableInput dr) throws IOException {
        this.fBlockParameter = (BlockParameter)dr.readStorable();
        this.fParameterNumber = dr.readInt();
        this.fText = dr.readString();
        this.fLineNumber = dr.readInt();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        BlockParameter blockParameter = this.getBlockParameter();
        if (blockParameter != null) {
            blockParameter.addParameterSetListener(this);
            blockParameter.addParameterUpdateListener(this);
        }
        if (this.serializedDataVersion == 1) {
            this.serializedDataVersion = 2;
            if (this.fBlockParameter != null) {
                this.fText = "";
            }
        }
    }

    public void removeAsParameterListener() {
        if (this.fBlockParameter != null) {
            this.fBlockParameter.removeParameterUpdateListener(this);
            this.fBlockParameter.removeParameterSetListener(this);
        }
    }

    public void removeMessageChangedListener(MessageListener listener) {
        if (listener != null && this.fMessageChangedListeners != null) {
            this.fMessageChangedListeners.remove(listener);
        }
    }

    public void setBlockParameter(BlockParameter newBlockParameter) {
        this.fBlockParameter = newBlockParameter;
    }

    public void setLineNumber(int newLineNumber) {
        this.fLineNumber = newLineNumber;
    }

    public void setMessageChangedListener(Vector newMessageChangedListener) {
        this.fMessageChangedListeners = newMessageChangedListener;
    }

    private void setParameterNumber(int newParameterNumber) {
        this.fParameterNumber = newParameterNumber;
    }

    public void setText(BlockParameter blockParameter, int parameterNumber) {
        this.setBlockParameter(blockParameter);
        this.setParameterNumber(parameterNumber);
        this.fireMessageChanged();
    }

    public void setText(String newText) {
        this.fText = newText;
        this.fireMessageChanged();
    }

    public String toString() {
        String text = this.getText();
        return text.length() == 0 ? " " : text;
    }

    public boolean valueEquals(Object o) {
        if (!(o instanceof MessageLine) || o == null) {
            return false;
        }
        MessageLine messageLine = (MessageLine)o;
        return this.fBlockParameter == messageLine.getBlockParameter() && this.fLineNumber == messageLine.getLineNumber() && this.fParameterNumber == messageLine.getParameterNumber() && this.fText.equals(messageLine.getText());
    }

    public void write(StorableOutput dw) {
        dw.writeStorable(this.fBlockParameter);
        dw.writeInt(this.fParameterNumber);
        dw.writeString(this.fText);
        dw.writeInt(this.fLineNumber);
    }

    public int getParameterPosition() {
        return this.fParameterPosition;
    }

    public void setParameterPosition(int parameterPosition) {
        this.fParameterPosition = parameterPosition;
    }

    public String getParameterText() {
        if (this.fBlockParameter != null) {
            StringBuffer text = new StringBuffer(this.fText);
            if (this.fText.length() >= this.fParameterPosition) {
                String parameterItemName = this.fBlockParameter.getParameterItem(this.getParameterItemIdentifier()).getLocalisedName();
                if (parameterItemName.length() > 4) {
                    parameterItemName = parameterItemName.substring(0, 4);
                }
                text.insert(this.fParameterPosition, "(" + this.fBlockParameter.getBlock().getNumberString() + "-" + parameterItemName + ")");
            }
            return text.toString();
        }
        return this.fText;
    }

    public String getParameterItemIdentifier() {
        if (this.fParameterItemIdentifier == null && this.fParameterNumber != -1 && this.fBlockParameter != null) {
            this.fParameterItemIdentifier = this.fBlockParameter.getParameterItems().getParameterItem(this.fParameterNumber).getIdentifier();
        }
        return this.fParameterItemIdentifier;
    }

    public void setParameterItemIdentifier(String parameterIdentifier) {
        this.fParameterItemIdentifier = parameterIdentifier;
    }

    public int getLength() {
        int messageLineLength = 0;
        int textLength = 0;
        if (this.fText != null) {
            textLength = this.fText.length();
            for (int i = textLength - 1; i >= 0 && Character.isWhitespace(this.fText.charAt(i)); --i) {
                --textLength;
            }
        }
        messageLineLength = textLength;
        if (this.getParameterItem() != null) {
            messageLineLength = this.fParameterPosition > textLength - 1 ? this.getParameterPosition() + this.getParameterItem().getWidth() : textLength + this.getParameterItem().getWidth();
        }
        return messageLineLength;
    }

    public boolean messageLineCleared() {
        BlockParameter blockParameter = this.getBlockParameter();
        if (blockParameter != null && blockParameter.getBlock().getWiringDiagram() == null) {
            this.setBlockParameter(null);
            this.setParameterItemIdentifier(null);
            blockParameter.removeParameterSetListener(this);
            return true;
        }
        return false;
    }

    public static DisplayElement getSpecialCharacterDisplayElement(char c) {
        Integer code = new Integer(c);
        String displayedText = (String)MessageParameter.getSpecialCharactersTable().get(code);
        if (displayedText == null) {
            return new DefaultDisplayElement("?", 1, 1);
        }
        return new SpecialCharacterDisplayElement(displayedText, code, 1, 1);
    }
}

