/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class LogoPreviewPanel
implements ChangeListener,
Cloneable {
    protected JPanel fPreviewPanel = null;
    private BorderJPanel ivjBorderJPanel2 = null;
    protected JLabel fOutputLabel = null;
    protected JLabel fInputLabel = null;
    protected JLabel fconnection = null;
    protected Color fSelectedColor = null;
    protected Color fBackgroundColor = Color.WHITE;
    protected Color fFBBgColor = Color.WHITE;
    protected static final String INPUT_ICON = "InputIconPreview.gif";
    protected static final String OUTPUT_ICON = "OutputIconPreview.gif";

    protected BorderJPanel getBorderJPanel2() {
        if (this.ivjBorderJPanel2 == null) {
            try {
                this.ivjBorderJPanel2 = new BorderJPanel();
                this.ivjBorderJPanel2.setName("BorderJPanel2");
                this.ivjBorderJPanel2.setLayout(new BorderLayout());
                this.ivjBorderJPanel2.setTitle("Preview");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBorderJPanel2;
    }

    public BorderJPanel getBorderPreview() {
        BorderJPanel borderPanel = this.getBorderJPanel2();
        borderPanel.setTitle(this.getPreviewName());
        borderPanel.setLayout(new BorderLayout());
        borderPanel.removeAll();
        borderPanel.add(this.getNewPreview(this.fBackgroundColor, this.fFBBgColor));
        return borderPanel;
    }

    public final Color getColor() {
        if (this.fSelectedColor == null) {
            Color tmp = Util.getColor(this.getKey(), null);
            this.fSelectedColor = tmp == null ? this.getDefaultColor() : tmp;
        }
        return this.fSelectedColor;
    }

    protected JLabel getConnectionLabel() {
        this.fconnection = new JLabel("                    ");
        return this.fconnection;
    }

    public abstract Color getDefaultColor();

    protected JLabel getInputLabel() {
        this.fInputLabel = new JLabel(this.getFBImageIcon(INPUT_ICON, this.fFBBgColor)){

            public void paint(Graphics g) {
                super.paint(g);
                Dimension size = this.getSize();
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
        };
        return this.fInputLabel;
    }

    protected ImageIcon getFBImageIcon(String pathName, Color fbBgColor) {
        Image img = Global.getImage(pathName);
        try {
            BufferedImage tmp = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
            while (!tmp.getGraphics().drawImage(img, 0, 0, null)) {
            }
            this.replaceBufferedImageColor(tmp.getRGB(1, 1), fbBgColor.getRGB(), tmp);
            img = tmp;
        }
        catch (Exception e) {
            System.err.println("Failed to apply FB background color.");
        }
        return new ImageIcon(img);
    }

    private void replaceBufferedImageColor(int orgRGB, int newRGB, BufferedImage img) {
        for (int i = 0; i < img.getWidth(); ++i) {
            for (int j = 0; j < img.getHeight(); ++j) {
                if (img.getRGB(i, j) != orgRGB) continue;
                img.setRGB(i, j, newRGB);
            }
        }
    }

    public abstract String getKey();

    protected JLabel getOutputLabel() {
        this.fOutputLabel = new JLabel(this.getFBImageIcon(OUTPUT_ICON, this.fFBBgColor)){

            public void paint(Graphics g) {
                super.paint(g);
                Dimension size = this.getSize();
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
        };
        return this.fOutputLabel;
    }

    protected JPanel getPreviewPanel() {
        if (this.fPreviewPanel == null) {
            this.fPreviewPanel = new JPanel(){

                public void paint(Graphics g) {
                    super.paint(g);
                    Dimension size = this.getSize();
                    g.drawLine(size.width / 2 - 35, size.height / 2, size.width / 2 + 35, size.height / 2);
                }
            };
            this.fPreviewPanel.setLayout(new FlowLayout());
            this.fPreviewPanel.setBackground(this.fBackgroundColor);
        }
        return this.fPreviewPanel;
    }

    public final JPanel getCurPreview() {
        if (this.fPreviewPanel == null) {
            System.err.println("Found preview panel not inited.");
        }
        return this.getPreviewPanel();
    }

    public final JPanel getNewPreview(Color backGroundColor, Color fbBackgroundColor) {
        this.fPreviewPanel = null;
        this.fInputLabel = null;
        this.fOutputLabel = null;
        this.fBackgroundColor = backGroundColor;
        this.fFBBgColor = fbBackgroundColor;
        return this.getPreviewPanel();
    }

    public abstract String getPreviewName();

    private void handleException(Throwable exception) {
    }

    public void setColor(Color color) {
        this.fSelectedColor = color;
    }

    public abstract void stateChanged(ChangeEvent var1);
}

