/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.dialog.PortSelectionPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.pdraw.app.LogoHelp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LogoError {
    public static final int OK_PRESSED = 0;
    public static final int CANCEL_PRESSED = 1;
    public static final int YES_PRESSED = 2;
    public static final int NO_PRESSED = 3;
    public static final int CLOSE_PRESSED = 4;
    public static final int OK = 0;
    public static final int OK_CANCEL = 1;
    public static final int YES_NO = 2;
    public static final int YES_NO_CANCEL = 3;
    public static final int CANCEL = 4;
    protected boolean customizedOptions;
    protected Component parent;
    protected String errorTextKey;
    Object[] additionalInformation = null;
    protected String errorTextDefault;
    protected int messageType;
    protected int optionsType;
    protected String[] options;
    protected String fHelpKey = null;
    private String fTitle;

    public LogoError(Component parent, String errorText) {
        this(parent, errorText, errorText, 0);
    }

    public LogoError(Component parent, String errorTextKey, String errorTextDefault) {
        this(parent, errorTextKey, errorTextDefault, 0);
    }

    public LogoError(Component parent, String errorTextKey, String errorTextDefault, Object[] additionalInformation, int messageType, String[] options) {
        this(parent, errorTextKey, errorTextDefault, messageType, options);
        this.additionalInformation = additionalInformation;
    }

    public LogoError(Component parent, String errorTextKey, String errorTextDefault, Object[] additionalInformation, int messageType, int optionsType) {
        this(parent, errorTextKey, errorTextDefault, messageType, optionsType);
        this.additionalInformation = additionalInformation;
    }

    public LogoError(Component parent, String errorTextKey, String errorTextDefault, int messageType) {
        this(parent, errorTextKey, errorTextDefault, messageType, 0);
    }

    public LogoError(Component parent, String errorTextKey, String errorTextDefault, int messageType, String[] options) {
        this.parent = parent;
        this.errorTextKey = errorTextKey;
        this.errorTextDefault = errorTextDefault;
        this.messageType = messageType;
        this.options = options;
        this.customizedOptions = true;
    }

    public LogoError(Component parent, String errorTextKey, String errorTextDefault, int messageType, int optionsType) {
        this.parent = parent;
        this.errorTextKey = errorTextKey;
        this.errorTextDefault = errorTextDefault;
        this.messageType = messageType;
        this.optionsType = optionsType;
        this.customizedOptions = false;
    }

    public LogoError(String errorText) {
        this(null, errorText, errorText);
    }

    public static final boolean checkRepeatTransmission(TransmissionFailedException tfe) {
        ApplicationSurface applicationWindow = Application.getInstance().getActiveApplicationSurface();
        boolean result = false;
        int tfeError = tfe.getError();
        LogoError dlg = null;
        Log.println(Language.getString("error.com.transmissionError", "Transmissionerror: %", DataTransfer.getErrorString(tfeError)));
        String[] optionString = new String[]{Language.getString("dialog.error.yes", "Yes"), Language.getString("dialog.error.no", "No"), Language.getString("dialog.error.selectPortButton", "Select port...")};
        String[] shortOptionString = new String[2];
        System.arraycopy(optionString, 0, shortOptionString, 0, 2);
        if (tfeError == 254 || tfeError == 244 || tfeError == 255 || tfeError == 240) {
            dlg = new LogoError(null, "error.com.checkModeYesNo", "Please check \nDevice in correct mode\nThe device PC-cable is connected.\nInterface is correct\nTry again?", 3, optionString);
        } else if (tfeError == 176) {
            String portName = LogoProperties.instance().getProperty("port", "COM2");
            Object[] params = new Object[]{portName};
            dlg = new LogoError((Component)applicationWindow, "error.com.checkMode", "Port " + portName + " not available!", params, 3, optionString);
        } else {
            dlg = tfeError == 177 ? new LogoError((Component)applicationWindow, "error.com.noModem", "Modem not available!\nRetry?", 3, optionString) : (!DataTransfer.getErrorString(tfeError).equals(Language.getString("error.com.unknown", "")) ? new LogoError((Component)applicationWindow, "none key", DataTransfer.getErrorString(tfeError) + "\nRetry?", 3, optionString) : new LogoError((Component)applicationWindow, "none key", Language.getString("error.com.transmissionFailedYesNo", "") + ". Error code: 0x" + Integer.toHexString(tfeError).toUpperCase(), 3, shortOptionString));
        }
        dlg.setHelpKey("dialog.error.TransmissionError");
        int answer = dlg.display();
        if (answer == 0) {
            result = true;
        } else if (answer == 1) {
            Log.println("error.com.userAbort", "Transmission aborted by user");
        } else {
            SplittedDlg.create(Application.getInstance().getActiveApplicationSurface().getWindow(), new PortSelectionPanel(), 11).show();
            result = false;
        }
        return result;
    }

    public int display() {
        String[] optionsStrings;
        if (!this.customizedOptions) {
            switch (this.optionsType) {
                case 1: {
                    String[] newOptions = new String[]{Language.getString("dialog.error.ok", "OK"), Language.getString("dialog.error.cancel", "Cancel")};
                    optionsStrings = newOptions;
                    break;
                }
                case 2: {
                    String[] newOptions = new String[]{Language.getString("dialog.error.yes", "Yes"), Language.getString("dialog.error.no", "No")};
                    optionsStrings = newOptions;
                    break;
                }
                case 3: {
                    String[] newOptions = new String[]{Language.getString("dialog.error.yes", "Yes"), Language.getString("dialog.error.no", "No"), Language.getString("dialog.error.cancel", "Cancel")};
                    optionsStrings = newOptions;
                    break;
                }
                case 0: {
                    String[] newOptions = new String[]{Language.getString("dialog.error.ok", "OK")};
                    optionsStrings = newOptions;
                    break;
                }
                case 4: {
                    String[] newOptions = new String[]{Language.getString("dialog.error.cancel", "Cancel")};
                    optionsStrings = newOptions;
                    break;
                }
                default: {
                    String[] newOptions = new String[]{Language.getString("dialog.error.ok", "OK")};
                    optionsStrings = newOptions;
                    break;
                }
            }
        } else {
            optionsStrings = this.options;
        }
        if (this.parent == null) {
            this.parent = new JFrame();
            this.parent = Application.getInstance().getActiveApplicationSurface();
        }
        JDialog parentDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this.parent);
        if (this.fTitle == null) {
            this.fTitle = parentDialog != null ? parentDialog.getTitle() : Application.getInstance().getActiveApplicationSurface().getTitle();
        }
        Object[] buttons = new JButton[optionsStrings.length];
        if (this.fHelpKey != null) {
            Object[] s = new Object[optionsStrings.length + 1];
            System.arraycopy(optionsStrings, 0, s, 0, optionsStrings.length);
            s[s.length - 1] = new JButton(Language.getString("global.help", "Help"));
            buttons = s;
        } else {
            buttons = optionsStrings;
        }
        JOptionPane pane = new JOptionPane(this.getErrorText(), this.messageType, -1, null, buttons);
        if (this.fHelpKey != null) {
            try {
                LogoHelp.getHelpBroker().enableHelpOnButton((Component)((JButton)buttons[buttons.length - 1]), this.fHelpKey, LogoHelp.getHelpSet());
            }
            catch (ProgramException e) {
                ((JButton)buttons[buttons.length - 1]).setEnabled(false);
            }
        }
        JDialog dialog = pane.createDialog(this.parent, this.parent.getName());
        if (this.parent == null || !this.parent.isVisible()) {
            JFrame frame = new JFrame(this.fTitle);
            frame.setContentPane(dialog.getContentPane());
            frame.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = frame.getSize();
            frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            frame.show();
        } else {
            dialog.setCursor(Cursor.getPredefinedCursor(0));
            dialog.setTitle(this.fTitle);
            dialog.show();
        }
        if (parentDialog != null) {
            parentDialog.toFront();
        }
        if (pane.getValue() == null) {
            return 4;
        }
        int rw = 0;
        for (int i = 0; i < optionsStrings.length; ++i) {
            if (!optionsStrings[i].equals(pane.getValue())) continue;
            rw = i;
        }
        if (this.customizedOptions) {
            return rw;
        }
        if (this.optionsType == 0 && rw == 0) {
            return 0;
        }
        if (this.optionsType == 1 && rw == 0) {
            return 0;
        }
        if (this.optionsType == 1 && rw == 1) {
            return 1;
        }
        if (this.optionsType == 2 && rw == 0) {
            return 2;
        }
        if (this.optionsType == 2 && rw == 1) {
            return 3;
        }
        if (this.optionsType == 3 && rw == 2) {
            return 1;
        }
        if (this.optionsType == 3 && rw == 0) {
            return 2;
        }
        if (this.optionsType == 3 && rw == 1) {
            return 3;
        }
        return 1;
    }

    public String getErrorText() {
        return Language.getString(this.errorTextKey, this.errorTextDefault, this.additionalInformation);
    }

    public final void setAdditionalInformation(Object obj) {
        Object[] arr = new Object[]{obj};
        this.additionalInformation = arr;
    }

    public void setHelpKey(String newHelpKey) {
        this.fHelpKey = newHelpKey;
    }

    public void setTitle(String newTitle) {
        this.fTitle = newTitle;
    }
}

