/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.comp.DataInputPanel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoColorChooser;
import DE.siemens.ad.logo.util.LogoPreviewPanel;
import DE.siemens.ad.logo.util.ProgramException;
import java.awt.BorderLayout;
import java.awt.Color;

public class LogoColorChooserPanel
extends DataInputPanel {
    private LogoColorChooser fLogoColorChooser = null;
    private Color fCurrentColor = Color.black;
    private LogoPreviewPanel fPreview = null;

    public LogoColorChooserPanel() {
        this.initialize();
    }

    public LogoColorChooserPanel(Color color) {
        this.initialize();
        this.fCurrentColor = color;
    }

    public Color getCurrentColor() {
        return this.fCurrentColor;
    }

    private LogoColorChooser getLogoColorChooser() {
        if (this.fLogoColorChooser == null) {
            this.fLogoColorChooser = new LogoColorChooser();
            this.fLogoColorChooser.setLogoPreviewPanel(this.getPreview());
        }
        return this.fLogoColorChooser;
    }

    private LogoPreviewPanel getPreview() {
        return this.fPreview;
    }

    public String getTitle() {
        return Language.getString("dialog.options.color.colorChooser", "Colorchooser");
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setLayout(new BorderLayout());
            this.setName("LogoColorChooserDlg");
            this.setSize(430, 450);
            this.add(this.getLogoColorChooser());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void setCurrentColor(Color color) {
        this.fCurrentColor = color;
        if (this.fPreview != null) {
            this.fPreview.setColor(color);
        }
    }

    public void setLogoPreview(LogoPreviewPanel preview) {
        this.fPreview = preview;
        this.setCurrentColor(preview.getColor());
        this.fLogoColorChooser.setLogoPreviewPanel(preview);
    }

    public void storeFieldContents() {
        Color color = this.getLogoColorChooser().getSelectionModel().getSelectedColor();
        this.setCurrentColor(color);
    }

    public void loadFieldContents() throws ProgramException {
        super.loadFieldContents();
    }
}

