/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.app.comp.BorderPanelPane;
import DE.siemens.ad.logo.app.comp.RolloverButton;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.app.LogoComfort;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.help.CSH;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class Log
implements ActionListener {
    public static PrintWriter out = new PrintWriter(System.out, true);
    private static Log fInstance = new Log();
    protected JTextArea fMessageArea = null;
    protected LogoComfort fEditor;
    private ImageIcon fAlternativeIcon;
    private BorderPanelPane.BorderPanel fInfoBorderPanel;
    private int fCounter;
    private ImageIcon fDefaultBorderIcon;
    private Timer fTimer;

    private Log() {
    }

    public static void error(Exception exception, String errorText) {
        PrintWriter dest = Log.getInstance().getDestination();
        dest.println("LOGOError: " + errorText);
        exception.printStackTrace(dest);
    }

    public PrintWriter getDestination() {
        return out;
    }

    public String getDestinationName() {
        return "Systemoutput";
    }

    protected LogoComfort getEditor() {
        return this.fEditor;
    }

    public static Log getInstance() {
        return fInstance;
    }

    public JTextArea getMessageArea() {
        if (this.fMessageArea == null) {
            this.fMessageArea = new JTextArea();
            this.fMessageArea.setDragEnabled(true);
        }
        return this.fMessageArea;
    }

    public static final void print(String text) {
        JTextArea msgArea = Log.getInstance().getMessageArea();
        try {
            msgArea.append(text);
        }
        catch (OutOfMemoryError e) {
            msgArea.setText("");
        }
        msgArea.setCaretPosition(msgArea.getDocument().getLength());
        Log.getInstance().notifyUser();
    }

    private void notifyUser() {
        if (this.fInfoBorderPanel == null) {
            return;
        }
        if (this.fTimer == null) {
            this.fTimer = new Timer(200, this);
        }
        if (!this.fTimer.isRunning()) {
            this.fTimer.start();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (this.fCounter == -1) {
            this.fInfoBorderPanel.setImageIcon(this.getAlternativeBorderIcon());
            ++this.fCounter;
        } else if (this.fCounter == 19) {
            this.fInfoBorderPanel.setImageIcon(this.getDefaultBorderIcon());
            this.fCounter = -1;
            this.fTimer.stop();
        } else {
            if (this.fCounter % 2 == 0) {
                this.fInfoBorderPanel.setImageIcon(this.getAlternativeBorderIcon());
            } else {
                this.fInfoBorderPanel.setImageIcon(this.getDefaultBorderIcon());
            }
            ++this.fCounter;
        }
    }

    private ImageIcon getDefaultBorderIcon() {
        if (this.fDefaultBorderIcon == null) {
            this.fDefaultBorderIcon = Global.getIcon("New.gif");
        }
        return this.fDefaultBorderIcon;
    }

    private ImageIcon getAlternativeBorderIcon() {
        if (this.fAlternativeIcon == null) {
            this.fAlternativeIcon = Global.getIcon("Editable.gif");
        }
        return this.fAlternativeIcon;
    }

    public static void print(String key, String defaultText) {
        Log.print(Language.getString(key, defaultText));
    }

    public void print(Dictionary dict) {
        Enumeration k = dict.keys();
        while (k.hasMoreElements()) {
            String key = (String)k.nextElement();
            Log.println(Language.getString(key, key));
            Log.println(dict.get(key).toString());
        }
    }

    public static final void println(String text) {
        Log.print(text + "\n");
    }

    public static void println(String key, String defaultText) {
        Log.println(Language.getString(key, defaultText));
    }

    public static String printStartSequence(String text) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, Language.getLocale());
        StringBuffer buffer = new StringBuffer(60);
        buffer.append("\n*** ").append(dateFormat.format(new Date())).append(" ");
        try {
            LogoComfort editor = Log.getInstance().getEditor();
            if (editor != null) {
                buffer.append(editor.getView().getModel().getFile().getName());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        buffer.append("\n*** ").append(text);
        Log.println(buffer.toString());
        return text;
    }

    public static String printStartSequence(String key, String defaultText) {
        return Log.printStartSequence(Language.getString(key, defaultText));
    }

    public void setEditor(LogoComfort newEditor) {
        this.fEditor = newEditor;
    }

    public void setOutputToFile(String fileName) {
        Object[] arr = new String[]{fileName};
        try {
            out = new PrintWriter(new FileWriter(fileName));
            String s = Language.getString("log.fileLogOn", "Write to Logfile " + fileName + " started.", arr);
            Log.println(s);
        }
        catch (IOException e) {
            String errString = Language.getString("error.openFile", "ERROR: Opening file: " + fileName, arr);
            Log.println(errString);
        }
    }

    public String toString() {
        return Language.getString("util.log.LogBook", "LogBook with Outputport") + this.getDestinationName();
    }

    public void initBorderPanel(BorderPanelPane.BorderPanel infoBorderPanel) {
        this.fInfoBorderPanel = infoBorderPanel;
        infoBorderPanel.setTitle(Language.getString("dialog.messageWindow.title", "Info window"));
        infoBorderPanel.removeAll();
        CSH.setHelpIDString((Component)infoBorderPanel, (String)"window.Message");
        CSH.setHelpIDString((Component)infoBorderPanel.getTitlePanel(), (String)"window.Message");
        infoBorderPanel.add(new JScrollPane(this.getMessageArea()));
        infoBorderPanel.setImageIcon(Global.getIcon("New.gif"));
        JComponent toolbarPanel = infoBorderPanel.getToolbarPanel();
        RolloverButton copyButton = new RolloverButton(Global.getIcon("Copy.gif"));
        copyButton.setToolTipText(Language.getString("infoWindow.copy"));
        copyButton.setMargin(new Insets(0, 0, 0, 0));
        toolbarPanel.add(copyButton);
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String selection = Log.this.getMessageArea().getSelectedText();
                if (selection == null || selection.equals("")) {
                    Log.this.getMessageArea().selectAll();
                }
                Log.this.getMessageArea().copy();
            }
        });
        RolloverButton deleteButton = new RolloverButton(Global.getIcon("Clear.gif"));
        deleteButton.setToolTipText(Language.getString("infoWindow.clear"));
        deleteButton.setMargin(new Insets(0, 0, 0, 0));
        deleteButton.setVerticalAlignment(0);
        toolbarPanel.add(deleteButton);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Log.this.getMessageArea().setText("");
            }
        });
        infoBorderPanel.addBorderPanelListener(new BorderPanelPane.BorderPanelListener(){

            public void borderPanelClosed(BorderPanelPane.BorderPanel bp) {
            }

            public void borderPanelOpened(BorderPanelPane.BorderPanel bp) {
            }

            public void borderPanelMoved(BorderPanelPane.BorderPanel bp) {
                bp.getBorderPanelPane().requestFocus();
                bp.requestFocus();
            }
        });
    }
}

