/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.KeyConverter;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoProperties;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class Language {
    protected static ResourceBundle cResourceBundle = null;
    protected static Locale cLocale = null;
    public static final String KEYEVENT = "KeyEvent";
    public static final String KEYSTROKE = "KeyStroke";
    public static String BEGIN_MACRO_TAG;
    public static String END_MACRO_TAG;

    protected static String getLanguageCountryFromInstall() {
        FilenameFilter filter;
        String[] languages = new String[]{"en_US", "de_DE", "pt_PT", "es_ES", "fr_FR", "it_IT"};
        String languageCountry = "en_US";
        final int resourceBundlePrefixLength = "Language".length();
        File directory = new File(Global.PATHBASE);
        String[] properties = (directory = new File(directory.getAbsolutePath())).list(filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".properties") && name.startsWith("Language_") && name.length() == resourceBundlePrefixLength + "_xx_XX.properties".length();
            }
        });
        if (properties.length > 0) {
            int size = languages.length;
            int installedLanguages = properties.length;
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < installedLanguages; ++j) {
                    String languageKey = properties[j].substring(resourceBundlePrefixLength + 1, resourceBundlePrefixLength + 1 + "xx_XX".length());
                    if (!languages[i].equals(languageKey)) continue;
                    return languageKey;
                }
            }
            languageCountry = properties[0].substring(resourceBundlePrefixLength + 1, resourceBundlePrefixLength + 1 + "xx_XX".length());
        } else {
            System.out.println("Wrong working-directory. No property-file found in: " + directory.getAbsolutePath());
            languageCountry = "";
        }
        return languageCountry;
    }

    public static Locale getLocale() {
        return cLocale;
    }

    public static String getString(String key) {
        if (cResourceBundle == null) {
            return null;
        }
        try {
            String retValue = Language.replaceMacros(cResourceBundle.getString(key));
            return retValue;
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public static String getString(String key, String defaultValue) {
        String result = Language.getString(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public static String getString(String baseKey, String defaultValue, Object[] parameter) {
        String retValue;
        if (parameter == null) {
            parameter = new String[]{"", "", "", ""};
        }
        if ((retValue = Language.getString(baseKey, defaultValue)).length() != 0) {
            int counter = 0;
            StringTokenizer tokenizer = new StringTokenizer(retValue, "%");
            String tmpString = tokenizer.nextToken();
            StringBuffer buffer = new StringBuffer();
            if (retValue.startsWith("%") && counter < parameter.length) {
                buffer.append(parameter[counter]);
                ++counter;
            }
            buffer.append(tmpString);
            while (tokenizer.hasMoreTokens()) {
                if (counter < parameter.length) {
                    buffer.append(parameter[counter]);
                    ++counter;
                }
                tmpString = tokenizer.nextToken();
                buffer.append(tmpString);
            }
            if (retValue.endsWith("%") && counter < parameter.length) {
                buffer.append(parameter[counter]);
            }
            retValue = buffer.toString();
        }
        return retValue;
    }

    public static String getString(String key, String defaultString, int value) {
        Object[] obj = new Object[]{new Integer(value)};
        return Language.getString(key, defaultString, obj);
    }

    public static String getString(String key, String defaultString, Object value) {
        Object[] obj = new Object[]{value};
        return Language.getString(key, defaultString, obj);
    }

    public static String getStringAndAccelerator(String baseKey, String defaultValue, Hashtable ht) {
        if (cResourceBundle == null) {
            return defaultValue;
        }
        String retValue = Language.getStringAndMnemonic(baseKey, defaultValue, ht);
        try {
            String accelString = cResourceBundle.getString(baseKey + ".accel");
            ht.put(KEYSTROKE, KeyConverter.getKeyStroke(accelString));
        }
        catch (MissingResourceException mre) {
            return retValue;
        }
        return retValue;
    }

    public static String getStringWithAccelerator(String baseKey, String defaultValue, Hashtable ht) {
        if (cResourceBundle == null) {
            return defaultValue;
        }
        String retValue = Language.getStringAndMnemonic(baseKey, defaultValue, ht);
        try {
            String accelString = cResourceBundle.getString(baseKey + ".accel");
            if (accelString != null) {
                KeyStroke keyStroke = KeyConverter.getKeyStroke(accelString);
                ht.put(KEYSTROKE, keyStroke);
                StringBuffer buffer = new StringBuffer(retValue);
                buffer.append("   (").append(Language.getAcceleratorText(keyStroke)).append(")");
                retValue = buffer.toString();
            }
        }
        catch (MissingResourceException mre) {
            return retValue;
        }
        return retValue;
    }

    private static String getAcceleratorText(KeyStroke keyStroke) {
        String controlKeyStr = "";
        if (keyStroke != null) {
            int mod = keyStroke.getModifiers();
            String acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
            if (acceleratorDelimiter == null) {
                acceleratorDelimiter = "-";
            }
            controlKeyStr = KeyEvent.getKeyModifiersText(mod) + acceleratorDelimiter + KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return controlKeyStr;
    }

    private static String getStringAndMnemonic(String baseKey, String defaultValue, Hashtable ht) {
        String retValue;
        try {
            retValue = Language.replaceMacros(cResourceBundle.getString(baseKey));
        }
        catch (MissingResourceException mre) {
            retValue = defaultValue;
        }
        int index = retValue.indexOf(126);
        if (index != -1 && index != retValue.length() - 1) {
            ht.put(KEYEVENT, new Integer(KeyConverter.getKeyEvent(retValue.substring(index + 1, index + 2))));
            String temp = retValue.substring(0, index);
            retValue = temp = temp + retValue.substring(index + 1);
        }
        return retValue;
    }

    public static String getStringNoTilde(String key, String defaultValue) {
        if (cResourceBundle == null) {
            return defaultValue;
        }
        try {
            String retValue = Language.replaceMacros(cResourceBundle.getString(key));
            int index = retValue.indexOf(126);
            if (index != -1) {
                String temp = retValue.substring(0, index);
                retValue = temp = temp + retValue.substring(index + 1);
            }
            return retValue;
        }
        catch (MissingResourceException mre) {
            return defaultValue;
        }
    }

    private static void initialize() {
        String languageCountry = LogoProperties.instance().getProperty("language");
        if (languageCountry == null || languageCountry.equals("")) {
            languageCountry = Language.getLanguageCountryFromInstall();
            LogoProperties.instance().setProperty("language", languageCountry);
            LogoProperties.instance().saveProperties();
        }
        StringTokenizer tokenizer = new StringTokenizer(languageCountry, "_");
        String language = tokenizer.nextToken();
        String country = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "US";
        try {
            cLocale = new Locale(language, country);
            cResourceBundle = ResourceBundle.getBundle("Language", cLocale);
        }
        catch (MissingResourceException mre) {
            Log.println(Language.getString("log.err.languagePropertyNotFound", "Language-Property not found"));
            Log.out.println("Language not found");
            cResourceBundle = null;
        }
    }

    public static String replaceMacros(String source) {
        if (source == null) {
            return source;
        }
        int beginMacroPosition = source.indexOf(BEGIN_MACRO_TAG);
        if (beginMacroPosition == -1) {
            return source;
        }
        int endMacroPosition = source.indexOf(END_MACRO_TAG);
        if (endMacroPosition != -1 || endMacroPosition > beginMacroPosition + 1) {
            String macroName = source.substring(beginMacroPosition + 2, endMacroPosition);
            String expandedMacro = Language.getString(macroName, macroName);
            return source.substring(0, beginMacroPosition) + expandedMacro + Language.replaceMacros(source.substring(endMacroPosition + 2));
        }
        return source;
    }

    static {
        Language.initialize();
        BEGIN_MACRO_TAG = "<$";
        END_MACRO_TAG = "$>";
    }
}

