/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

public class HiResTimer {
    protected boolean fHiResTimerAvailable;
    protected long fStartAbsoluteTime;
    protected double fStartTime;

    public HiResTimer() {
        try {
            this.fHiResTimerAvailable = this.isHighResTimerAvailable();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("WARNING: Native-Bibliothek 'hirestimer' konnte nicht geladen werden. F\u00fcr alleTimer wird deshalb der Aufruf 'System.currentTimeMillis() verwendet!");
            this.fHiResTimerAvailable = false;
        }
    }

    public native boolean isHighResTimerAvailable();

    public native double startTiming();

    public native double endTiming(double var1);

    public static void main(String[] args) throws Exception {
        HiResTimer timer = new HiResTimer();
        double dStart = 0.0;
        double dEnd = 0.0;
        if (timer.isHighResTimerAvailable()) {
            System.out.println("high res timer is available");
        } else {
            System.out.println("high res timer is not available");
        }
        dStart = timer.startTiming();
        System.out.println("granularity of hi-res timer is " + timer.endTiming(dStart) + " microseconds");
        dStart = timer.startTiming();
        Thread.sleep(1000L);
        System.out.println("timer test=" + timer.endTiming(dStart) + " milliseconds (should be around 1000)");
        Thread.sleep(2000L);
        System.out.println("timer test=" + timer.endTiming(dStart) + " milliseconds (should be around 3000)");
        Thread.sleep(3000L);
        System.out.println("timer test=" + timer.endTiming(dStart) + " milliseconds (should be around 6000)");
    }

    public void start() {
        if (this.fHiResTimerAvailable) {
            this.fStartAbsoluteTime = System.currentTimeMillis();
            this.fStartTime = this.startTiming();
        }
    }

    public long getCurrentTime() {
        if (this.fHiResTimerAvailable) {
            return (long)this.endTiming(this.fStartTime) + this.fStartAbsoluteTime;
        }
        return System.currentTimeMillis();
    }

    static {
        try {
            System.loadLibrary("hirestimer");
            System.out.println("hirestimer.dll is loaded.");
        }
        catch (UnsatisfiedLinkError error) {
            System.out.println("error load hirestimer.dll.");
        }
    }
}

