/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.logo.util.Version;
import DE.siemens.ad.pdraw.figures.SelectionFigure;
import java.awt.Color;
import java.awt.Image;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public final class Global {
    public static final boolean debug = false;
    public static int latestFileCreaterVersion = 6;
    public static final boolean fun = LogoProperties.instance().getBooleanProperty("funEdition", false);
    public static String FIRST_START_HELP_SCREEN = "Start_Screen";
    public static final String PATHBASE = Global.getPathbase();
    public static final String INI_FILENAME = "Application.ini";
    public static final String UNTITLED_NAME = Language.getString("global.untitledDrawing.fup", "Drawing");
    public static final String LSC_EXTENSION = "lsc";
    public static final String LGO_EXTENSION = "lgo";
    public static final String LADDER_DIAGRAM_EXTENSION = "lld";
    public static final String BATCH_START_FILE = "Start" + Version.getCurrentVersion().getApplicationFileName() + ".bat";
    public static final String START_INI_FILE = Version.getCurrentVersion().getApplicationFileName() + "Start.ini";
    public static final String LAX_FILE = Version.getCurrentVersion().getApplicationFileName() + ".lax";
    public static final String JAR_NAME = "classes.jar";
    public static final String HARDWARE_FACTORY_NAME = "DE.siemens.ad.logo.model.LogoHardwareFactory";
    public static final String IMAGEPATH = "/DE/siemens/ad/logo/images/";
    public static final String HARDWAREPATH = "/DE/siemens/ad/logo/model/hardware/";
    public static final String PANELPATH = "/DE/siemens/ad/logo/model/panel/";
    public static final String PACKAGENAME_HARDWARE = "DE.siemens.ad.logo.model.hardware.";
    public static final String PACKAGENAME_MODEL = "DE.siemens.ad.logo.model.";
    public static final String PACKAGENAME_BLOCKS = "DE.siemens.ad.logo.model.block.";
    public static final String PACKAGENAME_PANEL = "DE.siemens.ad.logo.model.panel.";
    public static final String PACKAGENAME_LADDER_DIAGRAM_PANEL = "DE.siemens.ad.kop.model.panel.";
    public static final String PACKAGENAME_LADDER_DIAGRAM_MODEL = "DE.siemens.ad.kop.model.";
    public static final String PACKAGENAME_LADDER_DIAGRAM_BLOCKS = "DE.siemens.ad.kop.model.block.";
    public static final String PACKAGENAME_UPDATE_WIZARD = "DE.siemens.ad.logo.dialog.wizard.update.";
    public static final int MAX_PARAM_TEXTLEN = 20;
    public static final String DEFAULT_LOGO_PORT = "COM2";
    public static final int FREQ_MIN = 0;
    public static final int FREQ_MAX = 1000;
    public static final int FREQ_TRESHOLD = 1000;
    public static final int ZOOM_MIN = 25;
    public static final int ZOOM_MAX = 400;
    public static final int PAGE_COUNT_HORIZONTAL_MIN = 1;
    public static final int PAGE_COUNT_HORIZONTAL_MAX = 100;
    public static final int PAGE_COUNT_VERTICAL_MIN = 1;
    public static final int PAGE_COUNT_VERTICAL_MAX = 100;
    public static final int PAGE_COUNT_TOTALLY = 100;
    public static Color SIMULATION_COLOR_HIGH = Util.getColor("simulation.color.high", Color.red);
    public static Color SIMULATION_COLOR_LOW = Util.getColor("simulation.color.low", Color.blue);
    public static Color LOGO_DISPLAY_COLOR = new Color(85, 157, 85);
    public static Color LOGO_DISPLAY_COLOR_LED_ON = new Color(105, 217, 85);
    public static Color LOGO_DISPLAY_COLOR_SCREEN_2 = new Color(116, 170, 173);
    public static Color BACKGROUND_COLOR = Util.getColor("backColor", new Color(180, 180, 180));
    public static Color MARGIN_COLOR = Util.getComplementaryColor(BACKGROUND_COLOR);
    public static Color BACKGROUND_COLOR_APP = Color.gray;
    private static Dictionary fIconCache;
    public static final String RESOURCE_BUNDLE_NAME = "Language";

    public static ImageIcon getIcon(String iconName) {
        return Global.getIcon(iconName, "DefaultIcon.gif");
    }

    public static ImageIcon getIcon(String iconName, String defaultIconName) {
        ImageIcon icon;
        if (fIconCache == null) {
            fIconCache = new Hashtable();
        }
        if ((icon = (ImageIcon)fIconCache.get(iconName)) != null) {
            return icon;
        }
        String iconPath = iconName;
        if (iconPath.indexOf(47) == -1) {
            iconPath = IMAGEPATH + iconName;
        }
        try {
            icon = new ImageIcon(Global.class.getResource(iconPath));
        }
        catch (Exception e) {
            System.out.println(iconPath + " konnte nicht geladen werden.");
            try {
                icon = new ImageIcon(Global.class.getResource(IMAGEPATH + defaultIconName));
            }
            catch (Exception ex) {
                try {
                    icon = new ImageIcon(Global.class.getResource("/DE/siemens/ad/logo/images/DefaultIcon.gif"));
                }
                catch (Exception ex2) {
                    System.out.println("/DE/siemens/ad/logo/images/DefaultIcon.gif konnte nicht gelesen werden");
                }
            }
        }
        fIconCache.put(iconName, icon);
        return icon;
    }

    public static Image getImage(String imageName) {
        return Global.getIcon(imageName).getImage();
    }

    private static final String getPathbase() {
        String pathbase = LogoProperties.instance().getProperty("logo.pathbase", ".");
        if (!pathbase.endsWith("prog\\bin") && !pathbase.endsWith("prog/bin")) {
            String NOTFOUND = "not found";
            String pathSeparator = System.getProperty("path.separator", "not found");
            String classPath = System.getProperty("java.class.path", "not found");
            if (!pathSeparator.equals("not found") && !classPath.equals("not found")) {
                StringTokenizer tokenizer = new StringTokenizer(classPath, pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (!token.endsWith("prog\\bin") && !token.endsWith("prog/bin")) continue;
                    pathbase = token;
                    LogoProperties.instance().setProperty("logo.pathbase", pathbase);
                    break;
                }
            }
        }
        return pathbase;
    }

    private static void initialize() {
    }

    public static void refreshColors() {
        SIMULATION_COLOR_HIGH = Util.getColor("simulation.color.high", SIMULATION_COLOR_HIGH);
        SIMULATION_COLOR_LOW = Util.getColor("simulation.color.low", SIMULATION_COLOR_LOW);
        BACKGROUND_COLOR = Util.getColor("backColor", BACKGROUND_COLOR);
        MARGIN_COLOR = Util.getComplementaryColor(BACKGROUND_COLOR);
        SelectionFigure.initColors();
    }

    static {
        Global.initialize();
    }
}

