/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DifferenceTableModel
extends AbstractTableModel {
    private int MAX_LINKCOUNT = 50;
    protected ArrayList data = new ArrayList();
    protected String[] columnNames;
    protected Object[] links = new Object[this.MAX_LINKCOUNT];

    public DifferenceTableModel(String c1, String c2, String c3) {
        this.columnNames = new String[3];
        this.columnNames[0] = c1;
        this.columnNames[1] = c2;
        this.columnNames[2] = c3;
    }

    public DifferenceTableModel(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setHeader(String name, int column) {
        try {
            this.columnNames[column] = name;
            this.fireTableCellUpdated(1, column);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setHeader(String[] names) {
        this.columnNames = names;
        this.fireTableCellUpdated(0, 0);
    }

    public void add(String c1, String c2, String c3) {
        Object[] a = new String[]{c1, c2, c3};
        this.addRow(a);
    }

    private void addRow(Object[] row) {
        this.data.add(row);
        int rowCount = this.data.size();
        this.fireTableRowsInserted(rowCount - 1, rowCount);
        this.fireTableChanged(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 1));
    }

    public void add(String[] msg, Object[] link) {
        block3: {
            int pos = this.data.size() + 1;
            try {
                this.links[pos] = link;
                this.addRow(msg);
            }
            catch (IndexOutOfBoundsException e) {
                if (pos != this.MAX_LINKCOUNT) break block3;
                Object[] arr = new String[msg.length];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = "...";
                }
                this.addRow(arr);
            }
        }
    }

    public Object[] getLinks(int row) {
        Object[] result = null;
        result = row < 0 || row >= this.links.length ? null : (Object[])this.links[row];
        if (result == null) {
            result = new Object[]{null, null};
        }
        return result;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int column) {
        String result = column < this.getColumnCount() ? this.columnNames[column] : super.getColumnName(column);
        return result;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public ArrayList getRows() {
        return this.data;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public Object getValueAt(int row, int column) {
        Object[] arr = (Object[])this.data.get(row);
        return arr[column];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (String[] str : this.data) {
            for (int i = 0; i < str.length; ++i) {
                buffer.append(str[i]);
                buffer.append("\t");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

