/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.ConnectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConnectionMarkerPanel
extends ConnectionPanel {
    private int fLineNr;
    protected int fOffset;

    public ConnectionMarkerPanel(int lineNr) {
        this.fLineNr = lineNr;
        switch (lineNr) {
            case 0: {
                this.fOffset = 9;
                break;
            }
            case 1: {
                this.fOffset = 17;
                break;
            }
            case 2: {
                this.fOffset = 25;
                break;
            }
            case 3: {
                this.fOffset = 33;
                break;
            }
            case 4: {
                this.fOffset = 21;
                break;
            }
            default: {
                this.fOffset = 0;
            }
        }
    }

    public Color getDefaultColor() {
        Color[] colors = new Color[]{Color.GREEN, Color.ORANGE, Color.PINK, Color.MAGENTA, Color.RED, Color.CYAN};
        return colors[this.fLineNr];
    }

    public String getKey() {
        String key = "marker.line.color." + this.fLineNr;
        return key;
    }

    public String getPreviewName() {
        return Language.getString("dialog.options.color.marker.line", "Marker Line %", this.fLineNr + 1);
    }

    public void setConnectionColor(Color color) {
        super.setConnectionColor(color);
    }

    protected JLabel getInputLabel() {
        if (this.fInputLabel == null) {
            this.fInputLabel = new JLabel("           ");
        }
        return this.fInputLabel;
    }

    protected JLabel getOutputLabel() {
        if (this.fOutputLabel == null) {
            this.fOutputLabel = new JLabel("           ");
        }
        return this.fOutputLabel;
    }

    protected JLabel getConnectionLabel() {
        return new JLabel(this.getFBImageIcon("AndIcon.gif", this.fFBBgColor));
    }

    protected JPanel getPreviewPanel() {
        if (this.fPreviewPanel == null) {
            this.fPreviewPanel = new JPanel(){

                public void paint(Graphics g) {
                    super.paint(g);
                    Dimension size = this.getSize();
                    int yCenter = size.height / 2;
                    int xCenter = size.width / 2;
                    int figureLeftX = xCenter - 12;
                    int figureRightX = xCenter + 12;
                    if (ConnectionMarkerPanel.this.fOffset == 21) {
                        g.drawLine(figureRightX, 21, figureRightX + 50, 21);
                    } else {
                        g.drawLine(xCenter - 58, ConnectionMarkerPanel.this.fOffset, figureLeftX, ConnectionMarkerPanel.this.fOffset);
                    }
                    g.setColor(Color.BLACK);
                    g.drawRect(figureLeftX, 5, 24, 32);
                    int offset = 9;
                    g.drawLine(figureLeftX - 5, offset, figureLeftX, offset);
                    offset = 17;
                    g.drawLine(figureLeftX - 5, offset, figureLeftX, offset);
                    offset = 25;
                    g.drawLine(figureLeftX - 5, offset, figureLeftX, offset);
                    offset = 33;
                    g.drawLine(figureLeftX - 5, offset, figureLeftX, offset);
                    g.drawLine(figureRightX, yCenter, figureRightX + 5, yCenter);
                }
            };
            this.fPreviewPanel.setLayout(new FlowLayout());
            this.fPreviewPanel.setBackground(this.fBackgroundColor);
            this.fPreviewPanel.add(this.getInputLabel());
            this.fPreviewPanel.add(this.getConnectionLabel());
            this.fPreviewPanel.add(this.getOutputLabel());
            this.setConnectionColor(this.getColor());
        }
        return this.fPreviewPanel;
    }
}

