/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.BlockEnumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class BlockEnumerator
implements BlockEnumeration {
    protected static final int STACK_SIZE = 200;
    protected boolean fBlocksUnique = true;
    protected int fRow = 1;
    protected boolean fNewRow = false;
    protected int fColumn = 0;
    protected int fMaxColumn = 0;
    protected Vector fProcessedBlocks = null;
    protected int[] fProcessedBlocksStackSize = new int[200];
    protected Vector fBlocksInUse = new Vector(200);
    protected int[] fBlocksInUseInputNumber = new int[200];
    protected Block fActBlock = null;
    protected InBlockConnector fActInBlockConnector = null;
    protected InBlockConnector fNextInBlockConnector = null;

    public BlockEnumerator(Block startBlock, boolean blocksUnique) {
        this.fBlocksUnique = blocksUnique;
        this.fActBlock = startBlock;
        this.fProcessedBlocks = new Vector(200);
        this.addInternalBlock(startBlock, false);
        int length = this.fProcessedBlocksStackSize.length;
        for (int i = 0; i < length; ++i) {
            this.fProcessedBlocksStackSize[i] = 1;
        }
    }

    protected void addInternalBlock(Block block, boolean isFinal) {
        this.fBlocksInUse.addElement(block);
        int size = this.fBlocksInUse.size();
        if (size > 1) {
            Block block2 = (Block)this.fBlocksInUse.elementAt(size - 2);
            this.fNextInBlockConnector = block2.getInConnector(this.fBlocksInUseInputNumber[size - 2]);
            if (size > this.fBlocksInUseInputNumber.length) {
                int[] newIntarray = new int[size + 20];
                System.arraycopy(this.fBlocksInUseInputNumber, 0, newIntarray, 0, this.fBlocksInUseInputNumber.length);
                this.fBlocksInUseInputNumber = newIntarray;
            }
        }
        this.fBlocksInUseInputNumber[size - 1] = isFinal ? 9999 : -1;
        this.fActBlock = block;
        if (!this.fProcessedBlocks.contains(block)) {
            this.fProcessedBlocks.addElement(block);
        }
    }

    public int getColumn() {
        return this.fColumn;
    }

    public int getCurrentStackDepth() {
        return this.fProcessedBlocksStackSize[0];
    }

    public InBlockConnector getInBlockConnector() {
        return this.fActInBlockConnector;
    }

    public final int getMaxColumn() {
        return this.fMaxColumn;
    }

    public int getRow() {
        return this.fRow;
    }

    public boolean hasMoreElements() {
        return this.fActBlock != null;
    }

    protected void modifyStackSize() {
        int position = this.fBlocksInUse.size() - 1;
        boolean notFinished = true;
        while (notFinished) {
            int i;
            try {
                Block block = (Block)this.fBlocksInUse.elementAt(position);
                int index = this.fProcessedBlocks.indexOf(block);
                int stackDepth = this.fProcessedBlocksStackSize[index];
                for (i = position; i >= 0; --i) {
                    block = (Block)this.fBlocksInUse.elementAt(i);
                    index = this.fProcessedBlocks.indexOf(block);
                    if (this.fProcessedBlocksStackSize[index] < stackDepth) {
                        this.fProcessedBlocksStackSize[index] = stackDepth;
                    }
                    ++stackDepth;
                }
                notFinished = false;
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                int size = this.fProcessedBlocksStackSize.length;
                int[] newIntarray = new int[size + 20];
                for (i = 0; i < size; ++i) {
                    newIntarray[i] = this.fProcessedBlocksStackSize[i];
                }
                for (i = size; i < size + 20; ++i) {
                    newIntarray[i] = 1;
                }
                this.fProcessedBlocksStackSize = newIntarray;
            }
        }
    }

    public Block nextBlock() throws NoSuchElementException {
        return (Block)this.nextElement();
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.fActBlock == null) {
            throw new NoSuchElementException();
        }
        this.fActInBlockConnector = this.fNextInBlockConnector;
        if (this.fNewRow) {
            ++this.fRow;
            this.fNewRow = false;
        }
        this.fColumn = this.fBlocksInUse.size();
        if (this.fColumn > this.fMaxColumn) {
            this.fMaxColumn = this.fColumn;
        }
        Block retObject = this.fActBlock;
        this.nextInternalBlock();
        return retObject;
    }

    protected void nextInternalBlock() {
        this.fActBlock = null;
        int position = this.fBlocksInUse.size() - 1;
        if (position >= 0) {
            int inputPosition = this.fBlocksInUseInputNumber[position];
            Block block = (Block)this.fBlocksInUse.elementAt(position);
            while (block.getInConnectorCount() > inputPosition + 1) {
                InBlockConnector inConnector;
                OutBlockConnector outConnector;
                if ((outConnector = (inConnector = block.getInConnector(++inputPosition)).getLinkedConnector()) == null) continue;
                this.fBlocksInUseInputNumber[position] = inputPosition;
                Block outBlock = outConnector.getOwner();
                if (!this.fProcessedBlocks.contains(outBlock)) {
                    if (outBlock instanceof OutputBlock) {
                        this.addInternalBlock(outBlock, true);
                    } else {
                        this.addInternalBlock(outBlock, false);
                    }
                    return;
                }
                if (this.fBlocksUnique) continue;
                this.addInternalBlock(outBlock, true);
                return;
            }
            this.removeInternalBlock();
        }
    }

    protected void removeInternalBlock() {
        Block b2;
        int position = this.fBlocksInUse.size() - 1;
        Block b1 = (Block)this.fBlocksInUse.elementAt(position);
        if (b1.equals(b2 = (Block)this.fProcessedBlocks.elementAt(this.fProcessedBlocks.size() - 1))) {
            this.fNewRow = true;
        }
        this.modifyStackSize();
        this.fBlocksInUse.removeElementAt(position);
        this.nextInternalBlock();
    }
}

