/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.MemoryEnumeration;
import DE.siemens.ad.logo.util.ProgramMemory8;

public class AnchorMemory8
extends ProgramMemory8 {
    int fFirstOpcode = 0;

    protected AnchorMemory8() {
    }

    public AnchorMemory8(int startAdresse, int memorySize, int firstOpcode) throws IllegalArgumentException {
        super("Anker Q1...Qi", startAdresse, memorySize, 5);
        this.fBlockObjArr = new Block[memorySize * 5];
        this.fFirstOpcode = firstOpcode;
    }

    public AnchorMemory8(String name, int startAdresse, int memorySize, int firstOpcode) throws IllegalArgumentException {
        super(name, startAdresse, memorySize, 5);
        this.fBlockObjArr = new Block[memorySize * 5];
        this.fFirstOpcode = firstOpcode;
    }

    public void createBlocks(WiringDiagram wd, CompilerFromLogo compiler) {
        int blockOffset = 0;
        int blockSize = this.getBlockSize();
        int ankerNumber = 0;
        MemoryEnumeration memoryEnum = new MemoryEnumeration(this.fMemory);
        while (memoryEnum.hasMoreElements()) {
            int[] ankerLine = memoryEnum.nextBlock();
            for (int i = 1; i < blockSize; ++i) {
                try {
                    if (!CompilerFromLogo.isReference(ankerLine[i])) continue;
                    ankerNumber = blockOffset + i;
                    int opcode = this.fFirstOpcode + ankerNumber - 1;
                    this.fBlockObjArr[ankerNumber] = wd.createBlock(opcode, ((Logo)wd.getHardware()).calculateBlockNumber(opcode));
                    continue;
                }
                catch (IllegalArgumentException e) {
                    Log.println(e.getMessage());
                    new LogoError(e.getMessage()).display();
                }
            }
            blockOffset += blockSize - 1;
        }
    }

    public Block getBlock(int line, int column) throws IllegalArgumentException {
        Block retValue = null;
        try {
            retValue = this.fBlockObjArr[line * (this.getBlockSize() - 1) + column];
        }
        catch (IndexOutOfBoundsException e) {
            String err = this.fBlockObjArr.length == 0 ? Language.getString("error.util.anchorMemory.block", "No Blocks created") : Language.getString("error.util.anchorMemory.line", "LineNumber") + line + Language.getString("error.util.anchorMemory.greater", "is greater than") + this.fBlockObjArr.length;
            throw new IllegalArgumentException(err);
        }
        return retValue;
    }

    public int getInputNumber(int column) {
        return 0;
    }

    public int getInputNumber(int line, int column) {
        return line * (this.getBlockSize() - 1);
    }

    public Memory init() {
        this.init(255);
        for (int i = 0; i < this.size(); ++i) {
            this.put(i, 0, 128);
        }
        this.fBlockIndex = 0;
        this.fByteIndex = 0;
        return this;
    }
}

