/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.AmplifierParameter;
import DE.siemens.ad.logo.model.AnalogComparatorParameter;
import DE.siemens.ad.logo.model.AnalogDeltaTriggerParameter;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.AnalogWatchdogParameter;
import DE.siemens.ad.logo.model.AsymPulseGeneratorParameter;
import DE.siemens.ad.logo.model.BaseBlock;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.ComfortSwitchParameter;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.LatchingRelayParameter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.OffDelayParameter;
import DE.siemens.ad.logo.model.OnDelayParameter;
import DE.siemens.ad.logo.model.OnOffDelayParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.PulseRelayParameter;
import DE.siemens.ad.logo.model.RandomParameter;
import DE.siemens.ad.logo.model.RetentiveOnDelayParameter;
import DE.siemens.ad.logo.model.ShiftRegisterParameter;
import DE.siemens.ad.logo.model.SoftkeyParameter;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.StairsSwitchParameter;
import DE.siemens.ad.logo.model.TriggerParameter;
import DE.siemens.ad.logo.model.WipingRelayPECParameter;
import DE.siemens.ad.logo.model.WipingRelayParameter;
import DE.siemens.ad.logo.model.YearClockParameter;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo4;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageMemory8;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;

public class LinkerToLogo4
extends LinkerToLogo {
    protected CompilerToLogo4 fCompiler;
    private InBlockConnector fConnector;

    public LinkerToLogo4(Hardware hw) {
        super(hw);
    }

    public void setCompiler(CompilerToLogo4 compiler) {
        this.fCompiler = compiler;
    }

    public void init() {
        this.setMemory(((Logo)this.fHardware).getMemory("Program"));
    }

    protected void writeTimerOrReference(TimeValueProperties value) {
        if (value.isReference()) {
            int[] logoValue = value.getCurrentValue().getLogoTime();
            int refValue = this.convertToPrgLine(logoValue[1]);
            refValue = Util.makeSignedWord(logoValue[0] & 0xC0, refValue);
            this.fMemory.putWord(refValue);
        } else {
            int[] time = value.getCurrentValue().getLogoTime();
            this.fMemory.put(time[1]);
            this.fMemory.put(time[0]);
        }
    }

    protected void writeDoubleWordOrReference(IntegerOrBlockReference integerReference) {
        if (integerReference.isReference()) {
            this.fMemory.putDoubleWord(this.convertToPrgLine(integerReference.getReferenceToBlock().getNumber()));
        } else {
            this.fMemory.putDoubleWord(integerReference.getValue());
        }
    }

    public int convertToPrgLine(int blockNumber) {
        return blockNumber - 1 + 10;
    }

    public Object visit(AnalogComparatorParameter param) {
        this.fMemory.putWord(param.getOn());
        this.fMemory.putWord(param.getOff());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(AnalogTriggerParameter param) {
        this.fMemory.putWord(param.getOnTrigger());
        this.fMemory.putWord(param.getOffTrigger());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(BaseBlock block) {
        this.setReference(this.fCompiler.getProgramLineNumber(block));
        this.setReferenceHighByteToProgramLine();
        return null;
    }

    private void setReferenceHighByteToProgramLine() {
        this.setReference(this.fConnector.isNegated() ? 192 : 128);
    }

    private void setReferenceHighByteToConstant() {
        this.setReference(this.fConnector.isNegated() ? 64 : 0);
    }

    public Object visit(InBlockConnector connector) {
        this.fConnector = connector;
        Block prev = connector.getLinkedBlock();
        if (prev != null) {
            prev.acceptVisitor(this);
        } else {
            short ncCode = connector.getNotConnectedCode();
            this.setReference(ncCode);
            if (Util.getLowByte(ncCode) == 255) {
                this.fMemory.put(255);
            } else {
                this.setReferenceHighByteToConstant();
            }
        }
        return null;
    }

    public Object visit(ConstantBlock block) {
        this.setReference(block.getOpcode(this.fHardware, block.getNumber()));
        this.setReferenceHighByteToConstant();
        return null;
    }

    public Object visit(SpecialBlock block) {
        this.setReference(this.fCompiler.getProgramLineNumber(block));
        this.setReferenceHighByteToProgramLine();
        return null;
    }

    public Object visit(OnDelayParameter param) {
        this.writeTimerOrReference(param.getParamTime());
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(OffDelayParameter param) {
        this.writeTimerOrReference(param.getParamTime());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(PulseRelayParameter param) {
        this.fMemory.put(param.isSetPreferred() ? 1 : 0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(ClockParameter param) {
        int i;
        int[] days = new int[3];
        int size = param.getCamCount();
        for (i = 0; i < size; ++i) {
            int[] time;
            CamParameter cam = param.getCam(i);
            if (cam.getOnTime().isInactive()) {
                this.fMemory.put(255);
                this.fMemory.put(255);
            } else {
                time = cam.getOnTime().getLogoTime();
                this.fMemory.put(time[1]);
                this.fMemory.put(time[0]);
            }
            if (cam.getOffTime().isInactive()) {
                this.fMemory.put(255);
                this.fMemory.put(255);
            } else {
                time = cam.getOffTime().getLogoTime();
                this.fMemory.put(time[1]);
                this.fMemory.put(time[0]);
            }
            days[i] = cam.getAvailableModes()[cam.getMode()].getLogoMode();
        }
        for (i = 0; i < days.length; ++i) {
            this.fMemory.put(days[i]);
        }
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(LatchingRelayParameter param) {
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(RetentiveOnDelayParameter param) {
        this.writeTimerOrReference(param.getParamTime());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(HoursCounterParameter param) {
        this.fMemory.putDoubleWord(param.getOTStart_Minute());
        this.fMemory.putWord(param.getMI_Minute() / 60);
        this.fMemory.put(param.isOutputIndependentOfEn() ? 1 : 0);
        this.fMemory.put(0);
        this.fMemory.putDoubleWord(0);
        this.fMemory.putDoubleWord(0);
        return null;
    }

    public Object visit(WipingRelayParameter param) {
        this.writeTimerOrReference(param.getParamTime());
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(CounterParameter param) {
        this.writeDoubleWordOrReference(param.getOn());
        this.writeDoubleWordOrReference(param.getOff());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(TriggerParameter param) {
        this.fMemory.putWord(param.getOnThreshold().getCurrentValue());
        this.fMemory.putWord(param.getOffThreshold().getCurrentValue());
        this.writeTimerOrReference(param.getTimeInterval().getParamTimeProperties());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(AsymPulseGeneratorParameter param) {
        this.writeTimerOrReference(param.getHTimerParamTime());
        this.writeTimerOrReference(param.getLTimerParamTime());
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(YearClockParameter param) {
        boolean everyMonth = param.isEveryMonth();
        int[] logoValue = param.getOnTime().getLogoTime();
        this.fMemory.put(logoValue[1]);
        this.fMemory.put(everyMonth ? 255 : logoValue[0]);
        logoValue = param.getOffTime().getLogoTime();
        this.fMemory.put(logoValue[1]);
        this.fMemory.put(everyMonth ? 255 : logoValue[0]);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(OnOffDelayParameter param) {
        this.writeTimerOrReference(param.getHTimerParamTime());
        this.writeTimerOrReference(param.getLTimerParamTime());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(RandomParameter param) {
        this.writeTimerOrReference(param.getHTimerParamTime());
        this.writeTimerOrReference(param.getLTimerParamTime());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(StairsSwitchParameter param) {
        this.writeTimerOrReference(param.getParamTime());
        int[] logoValue = param.getTimeToWarning().getLogoTime();
        this.fMemory.put(logoValue[1]);
        this.fMemory.put(logoValue[0]);
        logoValue = param.getWarningTime().getLogoTime();
        this.fMemory.put(logoValue[1]);
        this.fMemory.put(logoValue[0]);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(ComfortSwitchParameter param) {
        this.writeTimerOrReference(param.getLTimerParamTime());
        this.writeTimerOrReference(param.getHTimerParamTime());
        this.writeTimerOrReference(param.getTimeToWarning());
        this.writeTimerOrReference(param.getWarningTime());
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(WipingRelayPECParameter param) {
        this.writeTimerOrReference(param.getParamTime());
        this.writeTimerOrReference(param.getBreakTime());
        this.fMemory.put(param.getCycles());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(MessageParameter param) {
        int value = param.getPriority();
        if (param.isReceipt()) {
            value |= 0x80;
        }
        this.fMemory.put(value);
        this.fMemory.put(this.putMessage(param.getMessage()));
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public int putMessage(MessageLine[] message) throws ArrayIndexOutOfBoundsException {
        MessageMemory8 msgMemory = (MessageMemory8)((Logo)this.fHardware).getMemory("Meldetext");
        int line = this.putMessageLine(msgMemory, message[0]);
        for (int i = 1; i < message.length; ++i) {
            this.putMessageLine(msgMemory, message[i]);
        }
        return line / 4;
    }

    protected int putMessageLine(MessageMemory8 msgMemory, MessageLine msgLine) throws ArrayIndexOutOfBoundsException {
        int displayWidth = (Integer)this.fHardware.getProperty("displayWidth");
        int[] line = new int[msgMemory.getBlockSize()];
        if (!msgLine.hasParameter()) {
            line[0] = 1;
            if (msgLine.getText().trim().length() > 0) {
                this.fillWithText(msgLine, line, 2, displayWidth);
            }
        } else {
            Block block = msgLine.getBlockParameter().getBlock();
            ParameterItem paraItem = msgLine.getParameterItem();
            int paraItemLength = paraItem.getWidth();
            int textWidth = displayWidth - paraItemLength;
            String paraID = msgLine.getParameterItemIdentifier();
            line[1] = msgLine.getParameterPosition();
            if (paraID.equals("Time")) {
                line[0] = 3;
                this.fillWithText(msgLine, line, 2, textWidth);
            } else if (paraID.equals("Date")) {
                line[0] = 4;
                this.fillWithText(msgLine, line, 2, textWidth);
            } else if (paraID.equals("EnableTime")) {
                line[0] = 5;
                this.fillWithText(msgLine, line, 10, textWidth);
            } else if (paraID.equals("EnableDate")) {
                line[0] = 6;
                this.fillWithText(msgLine, line, 12, textWidth);
            } else {
                line[0] = 2;
                line[2] = this.convertToPrgLine(block.getNumber());
                line[3] = (byte)block.getOpcode(this.fHardware, block.getNumber());
                line[4] = msgLine.getParameterItem().getParameterNumber();
                this.fillWithText(msgLine, line, 6, textWidth);
            }
        }
        return msgMemory.putMemoryBlock(line);
    }

    private void fillWithText(MessageLine msgLine, int[] line, int start, int textWidth) {
        String messageText = msgLine.getText();
        int length = Math.min(messageText.length(), textWidth);
        byte[] bytes = this.getMessageBytes(messageText);
        for (int pos = 0; pos < length; ++pos) {
            line[pos + start] = bytes[pos];
        }
    }

    private byte[] getMessageBytes(String string) {
        byte[] bytes = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            bytes[i] = (byte)string.charAt(i);
        }
        return bytes;
    }

    public Object visit(SoftkeyParameter param) {
        int value = param.isSwitch() ? 1 : 0;
        this.fMemory.put(value |= param.getSwitchState() ? 128 : 0);
        this.fMemory.put(param.getParCycle());
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(ShiftRegisterParameter param) {
        this.fMemory.put(1 << param.getOutputBit());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(AnalogWatchdogParameter param) {
        this.fMemory.putWord(param.getDelta());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(AnalogDeltaTriggerParameter param) {
        this.fMemory.putWord(param.getOnTrigger());
        this.fMemory.putWord(param.getOffTrigger());
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }

    public Object visit(AmplifierParameter param) {
        this.fMemory.putWord(param.getGain());
        this.fMemory.putWord(param.getOffset());
        this.fMemory.put(param.getDecimalPlace());
        this.fMemory.put(0);
        this.fMemory.put(0);
        this.fMemory.put(0);
        return null;
    }
}

