/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.AnalogComparatorParameter;
import DE.siemens.ad.logo.model.AnalogInBlockConnector;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.BaseBlock;
import DE.siemens.ad.logo.model.BinaryInBlockConnector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.ConstantBlock;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.LatchingRelayParameter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.OffDelayParameter;
import DE.siemens.ad.logo.model.PulseRelayParameter;
import DE.siemens.ad.logo.model.RetentiveOnDelayParameter;
import DE.siemens.ad.logo.model.SpecialBlock;
import DE.siemens.ad.logo.model.TimeProtectionParameter;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo;
import DE.siemens.ad.logo.model.visitor.build.LinkerToLogo;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Util;

public class LinkerToLogo0
extends LinkerToLogo {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;
    protected int fRAMIndex;
    protected int fREMIndex;
    protected int fTimerIndex;
    protected Memory fParameterMemory;

    public LinkerToLogo0(Hardware hw) {
        super(hw);
    }

    public int convertToPrgLine(int blockNumber) {
        return blockNumber + 1;
    }

    public int getFirstREMIndex() {
        return 1;
    }

    public int getFreeRAM() {
        int result = this.fRAMIndex | 0x80;
        if (this.fRAMIndex++ >= this.fHardware.getMaxResource(1)) {
            result = this.getFreeREM();
        }
        return result;
    }

    public int getFreeRAMorREM(BlockParameter param) {
        if (param.getRemanenceAvailable() && param.getRemanenceObject().getRemanence()) {
            return this.getFreeREM();
        }
        return this.getFreeRAM();
    }

    public int getFreeRAMorREMCounter(BlockParameter param) {
        if (param.getRemanenceAvailable() && param.getRemanenceObject().getRemanence()) {
            return this.getFreeREM();
        }
        return this.getFreeRAM() & 0x3F;
    }

    public int getFreeREM() {
        int result = this.fREMIndex++;
        return result | 0xB0;
    }

    public int getFreeTimer() {
        return this.getFreeTimerIdx() | 0x80;
    }

    public int getFreeTimerIdx() {
        return this.fTimerIndex++;
    }

    public void init() {
        this.fRAMIndex = 0;
        this.fREMIndex = this.getFirstREMIndex();
        this.fTimerIndex = 0;
        this.fParameterMemory = ((Logo)this.fHardware).getMemory("Parameter");
    }

    public int putParameter(int[] parameterBlock) throws ArrayIndexOutOfBoundsException {
        int blockIndex = this.fParameterMemory.putMemoryBlock(parameterBlock);
        return blockIndex | 0x40;
    }

    public Object visit(AnalogComparatorParameter param) {
        int[] eeprom = new int[]{param.getProtection() ? 240 : 241, Util.getHighByte(param.getGain()), Util.getLowByte(param.getGain())};
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[]{240, Util.getHighByte(param.getOffset()), Util.getLowByte(param.getOffset())};
        this.putParameter(eeprom);
        eeprom = new int[]{240, Util.getHighByte(param.getOn()), Util.getLowByte(param.getOff())};
        this.putParameter(eeprom);
        this.setReference(this.getFreeRAMorREM(param));
        this.getFreeRAMorREM(param);
        this.getFreeRAMorREM(param);
        this.getFreeRAMorREM(param);
        return null;
    }

    public Object visit(AnalogInBlockConnector connector) {
        Block prev = connector.getLinkedBlock();
        if (prev != null) {
            prev.acceptVisitor(this);
        } else {
            this.setReference(CompilerFromLogo.REF_NC);
        }
        return null;
    }

    public Object visit(AnalogTriggerParameter param) {
        int[] eeprom = new int[]{param.getProtection() ? 240 : 241, Util.getHighByte(param.getGain()), Util.getLowByte(param.getGain())};
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[]{240, Util.getHighByte(param.getOffset()), Util.getLowByte(param.getOffset())};
        this.putParameter(eeprom);
        eeprom = new int[]{240, Util.getHighByte(param.getOnTrigger()), Util.getLowByte(param.getOnTrigger())};
        this.putParameter(eeprom);
        eeprom = new int[]{240, Util.getHighByte(param.getOffTrigger()), Util.getLowByte(param.getOffTrigger())};
        this.putParameter(eeprom);
        this.setReference(255);
        this.setReference(this.getFreeRAMorREM(param));
        this.getFreeRAMorREM(param);
        return null;
    }

    public Object visit(BaseBlock block) {
        this.setReference(this.convertToPrgLine(block.getNumber()));
        return null;
    }

    public Object visit(BinaryInBlockConnector connector) {
        Block prev = connector.getLinkedBlock();
        if (prev != null) {
            prev.acceptVisitor(this);
        } else {
            this.setReference(CompilerFromLogo.REF_NC);
        }
        return null;
    }

    public Object visit(CamParameter param) {
        int[] eeprom = new int[3];
        int[] time = new int[2];
        if (param.getOnTime().isInactive()) {
            time[1] = 255;
            time[0] = 255;
        } else {
            time = param.getOnTime().getLogoTime();
        }
        eeprom[0] = param.getProtection() ? 240 : 241;
        eeprom[1] = time[0];
        eeprom[2] = time[1];
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[3];
        time = new int[2];
        if (param.getOffTime().isInactive()) {
            time[1] = 255;
            time[0] = 255;
        } else {
            time = param.getOffTime().getLogoTime();
        }
        eeprom[0] = param.getAvailableModes()[param.getMode()].getLogoMode();
        if (eeprom[0] == 0) {
            eeprom[0] = 128;
        }
        eeprom[1] = time[0];
        eeprom[2] = time[1];
        this.putParameter(eeprom);
        return null;
    }

    public Object visit(ClockParameter param) {
        int size = param.getCamCount();
        for (int i = 0; i < size; ++i) {
            param.getCam(i).acceptVisitor(this);
        }
        this.setReference(this.getFreeRAMorREM(param));
        this.getFreeRAMorREM(param);
        return null;
    }

    public Object visit(ConstantBlock block) {
        this.setReference(block.getOpcode(this.fHardware, block.getNumber()));
        return null;
    }

    public Object visit(CounterParameter param) {
        int[] eeprom = new int[]{param.getProtection() ? 240 : 241, (param.getLimValue() & 0xFF00) >> 8, param.getLimValue() & 0xFF};
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[3];
        eeprom[0] = 240;
        eeprom[1] = this.getFreeRAMorREMCounter(param);
        this.getFreeRAMorREMCounter(param);
        eeprom[2] = 0;
        this.putParameter(eeprom);
        return null;
    }

    public Object visit(LatchingRelayParameter param) {
        this.setReference(128);
        this.setReference(this.getFreeRAMorREM(param));
        return null;
    }

    public Object visit(OffDelayParameter param) {
        int[] eeprom = new int[3];
        int[] time = param.getTimer().getParamTime().getLogoTime();
        eeprom[0] = param.getProtection() ? 240 : 241;
        eeprom[1] = time[0];
        eeprom[2] = time[1];
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[]{240, this.getFreeTimerIdx(), 0};
        this.putParameter(eeprom);
        this.setReference(this.getFreeRAMorREM(param));
        return null;
    }

    public Object visit(PulseRelayParameter param) {
        this.setReference(128);
        this.setReference(this.getFreeRAMorREM(param));
        return null;
    }

    public Object visit(RetentiveOnDelayParameter param) {
        int[] eeprom = new int[3];
        int[] time = param.getTimer().getParamTime().getLogoTime();
        eeprom[0] = param.getProtection() ? 240 : 241;
        eeprom[1] = time[0];
        eeprom[2] = time[1];
        this.setReference(this.putParameter(eeprom));
        eeprom = new int[]{240, this.getFreeTimerIdx(), 0};
        this.putParameter(eeprom);
        this.setReference(this.getFreeRAMorREM(param));
        return null;
    }

    public Object visit(SpecialBlock block) {
        this.setReference(this.convertToPrgLine(block.getNumber()));
        return null;
    }

    public Object visit(TimeProtectionParameter param) {
        int[] eeprom = new int[3];
        int[] time = param.getTimer().getParamTime().getLogoTime();
        eeprom[0] = param.getProtection() ? 240 : 241;
        eeprom[1] = time[0];
        eeprom[2] = time[1];
        this.setReference(this.putParameter(eeprom));
        this.setReference(this.getFreeTimer());
        this.setReference(this.getFreeRAMorREM(param));
        return null;
    }
}

