/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.LatchingRelayParameter;
import DE.siemens.ad.logo.model.block.AsiOutputBlock;
import DE.siemens.ad.logo.model.block.LatchingRelayBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.block.PulseRelayBlock;
import DE.siemens.ad.logo.model.visitor.build.CompilerToLogo;
import DE.siemens.ad.logo.util.Memory;

public class CompilerToLogo0
extends CompilerToLogo {
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 1;

    public Object visit(LatchingRelayBlock block) {
        Memory memory = this.writeOpcode(block);
        this.fLinker.setMemory(memory);
        InBlockConnector[] inConnectors = block.getInConnectors();
        inConnectors[0].acceptVisitor(this.fLinker);
        inConnectors[1].acceptVisitor(this.fLinker);
        this.fLinker.setMemory(memory);
        BlockParameter param = block.getParameter();
        if (param == null) {
            param = new LatchingRelayParameter();
            param.setRemanenceAvailable(false);
        }
        param.acceptVisitor(this.fLinker);
        return null;
    }

    public Object visit(PulseRelayBlock block) {
        Memory memory = this.writeOpcode(block);
        this.fLinker.setMemory(memory);
        InBlockConnector[] inConnectors = block.getInConnectors();
        inConnectors[0].acceptVisitor(this.fLinker);
        inConnectors[1].acceptVisitor(this.fLinker);
        this.fLinker.setMemory(memory);
        BlockParameter param = block.getParameter();
        if (param == null) {
            param = new LatchingRelayParameter();
            param.setRemanenceAvailable(false);
        }
        param.acceptVisitor(this.fLinker);
        return null;
    }

    protected void setAnchor(OutputBlock block, String memoryID) {
        int anchorNumber = block.getNumber();
        int blockIndex = anchorNumber / 5;
        int byteIndex = (anchorNumber - 1) % 4 + 1;
        Memory memory = this.getMemory(memoryID);
        memory.setPosition(blockIndex, byteIndex);
        this.link(block, memory);
    }

    protected Memory writeOpcode(Block block) {
        int index = block.getNumber() - 1;
        Memory memory = this.getMemory("Program");
        memory.put(index, 0, block.getOpcode(this.fHardware, index + 1));
        return memory;
    }

    public Object visit(AsiOutputBlock block) {
        this.setAnchor(block, "ASi-Anker");
        return null;
    }
}

