/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.AnalogComparatorParameter;
import DE.siemens.ad.logo.model.AnalogMathsParameter;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.AnalogWatchdogParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.CounterParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ModeUniversal;
import DE.siemens.ad.logo.model.PWMParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterItemTable;
import DE.siemens.ad.logo.model.StairsSwitchParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.TriggerParameter;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.model.YearClockParameter;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.model.block.PWMBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.YearClockBlock;
import DE.siemens.ad.logo.model.hardware.Logo6;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo5;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.MessageGlobalInfo;
import DE.siemens.ad.logo.util.MessageLineRTF;
import DE.siemens.ad.logo.util.MessageMemoryRTF;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;

public class CompilerFromLogo6
extends CompilerFromLogo5 {
    protected void init(Hardware hw) {
        super.init(hw);
        this.fWiringDiagram.getMessageGlobalInfo().fGlobalSettingFinished = false;
        this.fWiringDiagram.getMessageGlobalInfo().setFUseNewFeature(true);
        this.fWiringDiagram.isUserProgramFromBM = true;
    }

    protected void setAnalogOutputType(Block block) {
    }

    public void compile(AnalogMathsBlock block) {
        AnalogMathsParameter param = (AnalogMathsParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        if (null == block.getParameter()) {
            System.out.println("CompilerFromLogo6::compile, block.getParameter is null!");
        }
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 0, "P1", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 1, "P2", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 2, "P3", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 3, "P4", block.getParameter());
        for (int i = 0; i < param.getOpNum(); ++i) {
            param.setOperator(i, this.fProgramMemory.nextByte());
        }
        int mode = this.fProgramMemory.nextByte();
        for (int i = 0; i < param.getOpNum(); ++i) {
            param.setOpPRI(i, 3 & mode);
            mode >>= 2;
        }
        param.setEnOutputOptionID(3 & mode);
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(MathDetectionBlock block) {
        MathDetectionParameter param = (MathDetectionParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        int progkNr = this.fProgramMemory.nextByte();
        if (progkNr != 255) {
            param.setReferencedBlockNumber(this.getBlockNumber(progkNr));
        } else {
            param.setReferencedBlockNumber(-1);
        }
        param.setAutoResetMode(this.fProgramMemory.nextByte() != 0);
        this.fProgramMemory.nextWord();
        int detectErr = this.fProgramMemory.nextByte();
        param.setDetectOverflow((detectErr & 1) > 0);
        param.setDetectZeroDivision((detectErr & 2) > 0);
    }

    public void compile(AnalogComparatorBlock block) {
        AnalogComparatorParameter param = (AnalogComparatorParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 0, "On", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 1, "Off", block.getParameter());
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(TriggerBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        TriggerParameter param = (TriggerParameter)block.getParameter();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        param.setOnThreshold(this.fProgramMemory.nextWord());
        param.setOffThreshold(this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "G_T", block.getParameter());
    }

    public void compile(AnalogTriggerBlock block) {
        AnalogTriggerParameter param = (AnalogTriggerParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 0, "On", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 1, "Off", block.getParameter());
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(StairsSwitchBlock block) {
        StairsSwitchParameter param = (StairsSwitchParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "T", block.getParameter());
        this.setTimerOrReference(opcode, 1, "T!", block.getParameter());
        this.setTimerOrReference(opcode, 2, "T!L", block.getParameter());
    }

    public void compile(HoursCounterBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        HoursCounterParameter param = (HoursCounterParameter)block.getParameter();
        param.setOperatingTimeStart(this.fProgramMemory.nextDoubleWord());
        this.setLongTimerOrReference(opcode, 0, "MI_h:m", block.getParameter(), 9999);
        this.fProgramMemory.nextByte();
        this.fProgramMemory.nextByte();
        param.setOutputSeparatedFromEn(this.fProgramMemory.nextByte() == 1);
        this.fProgramMemory.nextByte();
        this.fProgramMemory.nextDoubleWord();
        this.fProgramMemory.nextDoubleWord();
    }

    public void compile(CounterBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.setIntegerOrReference(this.fProgramMemory.nextDoubleWord(), opcode, 0, "On", block.getParameter());
        this.setIntegerOrReference(this.fProgramMemory.nextDoubleWord(), opcode, 1, "Off", block.getParameter());
        CounterParameter param = (CounterParameter)block.getParameter();
        IntValueProperties startProp = new IntValueProperties(0, 1000, 1, this.fProgramMemory.nextDoubleWord(), "error.dialog.invalidValue", "Invalid value.");
        param.setStartValue(startProp);
    }

    public void compile(ClockBlock block) {
        CamParameter camParam;
        int i;
        int opcode = this.fProgramMemory.nextWord();
        ClockParameter clockParam = (ClockParameter)block.getParameter();
        boolean protection = clockParam.getProtection();
        int nockenCount = clockParam.getCamCount();
        for (i = 0; i < nockenCount; ++i) {
            ClockHours camTime;
            camParam = clockParam.getCam(i);
            int logoTime = this.fProgramMemory.nextWord();
            if (logoTime == 65535 || logoTime == 16383) {
                camParam.getOnTime().setInactive(true);
            } else {
                camTime = (ClockHours)this.getNewTimeObject(Util.getHighByte(logoTime), Util.getLowByte(logoTime));
                camTime.setInactive(false);
                camParam.setOnTime(camTime);
            }
            logoTime = this.fProgramMemory.nextWord();
            if (logoTime == 65535 || logoTime == 16383) {
                camParam.getOffTime().setInactive(true);
            } else {
                camTime = (ClockHours)this.getNewTimeObject(Util.getHighByte(logoTime), Util.getLowByte(logoTime));
                camTime.setInactive(false);
                camParam.setOffTime(camTime);
            }
            camParam.setProtection(protection);
        }
        for (i = 0; i < nockenCount; ++i) {
            camParam = clockParam.getCam(i);
            ((ModeUniversal)camParam.getAvailableModes()[11]).setLogoMode(this.fProgramMemory.nextByte());
        }
        clockParam.setPulse(this.fProgramMemory.nextByte() > 0);
    }

    public void compile(YearClockBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        YearClockParameter param = (YearClockParameter)block.getParameter();
        int paramLowByte = this.fProgramMemory.nextByte();
        int paramHighByte = this.fProgramMemory.nextByte();
        param.getOnTime().setTime(paramHighByte, paramLowByte);
        param.setOnYear(param.getYearStart() + this.fProgramMemory.nextByte());
        paramLowByte = this.fProgramMemory.nextByte();
        paramHighByte = this.fProgramMemory.nextByte();
        param.getOffTime().setTime(paramHighByte, paramLowByte);
        param.setOffYear(param.getYearStart() + this.fProgramMemory.nextByte());
        int modeByte = this.fProgramMemory.nextByte();
        param.setPulse((modeByte & 1) > 0);
        param.setYearly((modeByte & 0x40) > 0);
        param.setEveryMonth((modeByte & 0x80) > 0);
    }

    public void compile(PWMBlock block) {
        PWMParameter param = (PWMParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "P", block.getParameter());
        int gain = this.fProgramMemory.nextSignedWord();
        int offset = this.fProgramMemory.nextSignedWord();
        param.setRangeMin(this.fProgramMemory.nextSignedWord());
        param.setRangeMax(this.fProgramMemory.nextSignedWord());
        param.setTimebase(this.fProgramMemory.nextByte());
        param.setSensorType(this.fProgramMemory.nextByte());
        param.setGain(gain);
        param.setOffset(offset);
        param.setDecimalPlace(this.fProgramMemory.nextByte());
        this.fProgramMemory.nextByte();
        this.fProgramMemory.nextWord();
        this.fProgramMemory.nextWord();
    }

    protected void setLongTimerOrReference(int opcode, int paramNumber, String parameterID, BlockParameter param, int maxValue) {
        TimeValueProperties newValue = new TimeValueProperties();
        short opcHighbyte = Util.getHighByte(opcode);
        int paramByte3 = this.fProgramMemory.nextByte();
        int paramByte2 = this.fProgramMemory.nextByte();
        int paramByte1 = this.fProgramMemory.nextByte();
        int paramByte0 = this.fProgramMemory.nextByte();
        ParameterItemList paramItemList = ((ParameterItemTable)this.fHardware.getProperty("parameterItemTable")).getParameterItems(param);
        ParameterItem paramItem = paramItemList.getParameterItem(parameterID).getInstanceForParameter(param);
        if ((opcHighbyte & 32 >> paramNumber) > 0) {
            newValue.setReference(this.getReferencedParameterItem(paramByte3));
            if ((paramByte2 & 0xC0) == 0) {
                UnlimitedHours tu = new UnlimitedHours(maxValue);
                tu.setTime(0);
                newValue.setReferenceTimeUnit(tu);
            } else {
                newValue.setReferenceTimeUnit(this.getNewReferencedTimeObject(paramByte2 & 0xC0, 0));
            }
        } else {
            newValue.setCurrentValue(this.getUnlimitedHours(maxValue, paramByte0, paramByte1, paramByte2, paramByte3));
        }
        paramItem.setValue(newValue);
    }

    protected TimeUnit getUnlimitedHours(int maxValue, int byte0, int byte1, int byte2, int byte3) {
        TimeUnit retValue = null;
        int timeBase = byte0 & 0xC0;
        if (timeBase == 0) {
            int timeValue = Util.makeSignedDoubleWord(byte0 & 0x3F, byte1, byte2, byte3);
            retValue = new UnlimitedHours(maxValue);
            retValue.setTime(timeValue);
        } else {
            retValue = super.getNewTimeObject(byte0, byte1);
        }
        return retValue;
    }

    public void compile(AnalogWatchdogBlock block) {
        AnalogWatchdogParameter param = (AnalogWatchdogParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 0, "D1", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 1, "D2", block.getParameter());
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(MessageBlock block) {
        MessageParameter param = (MessageParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        short value = (short)this.fProgramMemory.nextByte();
        param.setPriority(new Integer(value & 0x7F));
        param.setReceipt((value & 0x80) > 0);
        int msgNumber = this.fProgramMemory.nextByte();
        param.setMsgNumber(msgNumber);
        if (this.fHardware instanceof Logo6 && !((Logo6)this.fHardware).isNeedMessageInfo()) {
            return;
        }
        this.putMessageTextAndGlobalSetting(param);
    }

    private MessageMemoryRTF getMessageMemoryRTF() {
        return (MessageMemoryRTF)this.fHardware.getMemory("Message RTF");
    }

    public void putMessageTextAndGlobalSetting(MessageParameter param) {
        MessageGlobalInfo msgGlobalInfo = this.fWiringDiagram.getMessageGlobalInfo();
        MessageMemoryRTF msgMemory = this.getMessageMemoryRTF();
        if (!msgGlobalInfo.fGlobalSettingFinished) {
            msgGlobalInfo.setSelectedCharSets(msgMemory.getCharacterSets()[0], 0);
            msgGlobalInfo.setSelectedCharSets(msgMemory.getCharacterSets()[1], 1);
            msgGlobalInfo.setCurCharSet(msgMemory.getCharacterSetCur());
            msgGlobalInfo.setTickerInterval(msgMemory.getTickerInterval());
            msgGlobalInfo.setAnalogRefreshInterval(msgMemory.getAnalogRefreshInterval());
            msgGlobalInfo.fGlobalSettingFinished = true;
        }
        for (int i = 0; i < 2; ++i) {
            MessageParameter.MessageText msgText;
            int msgTextID = msgMemory.getMessageTextID(param.getMsgNumber(), i);
            param.getMessageRTFs()[i] = null;
            if (msgTextID == -1) continue;
            param.getMessageRTFs()[i] = msgText = new MessageParameter.MessageText(msgTextID, msgMemory.getCharacterSets()[i], param);
            param.setCurrentTextID(i);
            int msgInfo = msgMemory.getMsgInfo(msgTextID);
            msgText.setShowDest((msgInfo & 6) >> 1);
            msgText.setTickerType(msgInfo & 1);
            if (msgMemory.getMessageTextCharset(param.getMsgNumber(), i) != msgGlobalInfo.getSelectedCharSet(i)) {
                System.err.println("Conflict between global setting and message text!");
                continue;
            }
            MessageLineRTF[] lines = msgText.getMessageLineRTF();
            for (int j = 0; j < lines.length; ++j) {
                System.arraycopy(msgMemory.getMessageTextMemory().getMemoryBlock(msgTextID * 4 + j), 0, lines[j].getContentsBytes(), 0, 32);
                this.readAddtionalInfo(lines[j]);
                lines[j].setTickerLine(msgMemory.getMsgLineTickFlag(msgTextID, j));
            }
        }
    }

    private void readAddtionalInfo(MessageLineRTF line) {
        MessageMemoryRTF msgMemory = this.getMessageMemoryRTF();
        int[] contents = line.getContentsBytes();
        int i = 0;
        while (i < contents.length) {
            int cur = contents[i];
            if (cur == MessageLineRTF.BAR_ID) {
                int barID = contents[i + 1];
                line.getBarGraphMap().put(barID, this.getBarBytes(barID));
                i += 2;
                continue;
            }
            if (cur == MessageLineRTF.STATUS_NAME_IO_ID) {
                int nameID = contents[i + 1];
                line.getIONameMap().put(nameID, this.getNameBytes(nameID));
                i += 8;
                continue;
            }
            if (cur == MessageLineRTF.PARAMETER_ID) {
                i += 4;
                continue;
            }
            if (cur == MessageLineRTF.TIME_DATE_ID) {
                i += 2;
                continue;
            }
            if (cur == MessageLineRTF.ANALOG_INPUT_ID) {
                i += 4;
                continue;
            }
            if (line.isBiWidthCharacterset()) {
                if (cur > 128) {
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
    }

    private int[] getBarBytes(int barID) {
        MessageMemoryRTF msgMemory = this.getMessageMemoryRTF();
        int[] ret = new int[8];
        int[] barInfo = msgMemory.getBarGraphMemory().asArray();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = barInfo[barID * 8 + i];
        }
        return ret;
    }

    private int[] getNameBytes(int nameID) {
        MessageMemoryRTF msgMemory = this.getMessageMemoryRTF();
        int[] ret = new int[16];
        int[] ioNameInfo = msgMemory.getIO_StatusNameMemory().asArray();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ioNameInfo[nameID * 8 * 2 + i];
        }
        return ret;
    }
}

