/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogMuxParameter;
import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.PIDParameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterItemTable;
import DE.siemens.ad.logo.model.RampControlParameter;
import DE.siemens.ad.logo.model.block.AnalogMuxBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.block.RampControlBlock;
import DE.siemens.ad.logo.model.panel.PIDParameterset;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo4;
import DE.siemens.ad.logo.util.Util;

public class CompilerFromLogo5
extends CompilerFromLogo4 {
    public void compile(AnalogMuxBlock block) {
        AnalogMuxParameter param = (AnalogMuxParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 0, "P1", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 1, "P2", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 2, "P3", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 3, "P4", block.getParameter());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(RampControlBlock block) {
        RampControlParameter param = (RampControlParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 0, "R1", block.getParameter());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 1, "R2", block.getParameter());
        param.getMaxOutput().setCurrentValue(this.fProgramMemory.nextSignedWord());
        param.getStartStopOffset().setCurrentValue(this.fProgramMemory.nextSignedWord());
        param.getRate().setCurrentValue(this.fProgramMemory.nextWord());
        super.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    protected void setGain(Analog param) {
        param.setGain(this.fProgramMemory.nextSignedWord());
    }

    public void compile(PIDBlock block) {
        PIDParameter param = (PIDParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.setAnalogOrReference(this.fProgramMemory.nextSignedWord(), opcode, 0, "SP", block.getParameter());
        this.setIntegerOrReference(this.fProgramMemory.nextWord(), opcode, 1, "Mq", block.getParameter());
        param.getLoopGainProperties().setCurrentValue((double)this.fProgramMemory.nextSignedWord() / 100.0);
        int lowByte = this.fProgramMemory.nextByte();
        int highByte = this.fProgramMemory.nextByte();
        param.getIntegralTimer().setParamTime(this.getNewTimeObject(highByte, lowByte));
        this.fProgramMemory.nextSignedWord();
        this.fProgramMemory.nextSignedWord();
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDirection((char)this.fProgramMemory.nextByte());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
        PIDParameterset parSet = PIDParameterset.getSet(param.getLoopGainProperties().getCurrentValue(), param.getIntegralTimer().getParamTime(), param.getDirection());
        param.setParameterset(parSet == null ? PIDParameterset.INDEX_USER_DEFINED_SET : parSet.getIndex());
    }

    protected void setAnalogOrReference(int memValue, int opcode, int paramNumber, String parameterID, BlockParameter param) {
        AnalogOrBlockReference newValue = new AnalogOrBlockReference(param);
        short opcHighbyte = Util.getHighByte(opcode);
        ParameterItemList paramItemList = ((ParameterItemTable)this.fHardware.getProperty("parameterItemTable")).getParameterItems(param);
        ParameterItem paramItem = paramItemList.getParameterItem(parameterID).getInstanceForParameter(param);
        if ((opcHighbyte & 32 >> paramNumber) > 0) {
            newValue.setReference(this.getReferencedParameterItem(memValue));
        } else {
            newValue.setIntValue(memValue);
        }
        paramItem.setValue(newValue);
    }
}

