/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build;

import DE.siemens.ad.logo.model.AmplifierParameter;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.AnalogComparatorParameter;
import DE.siemens.ad.logo.model.AnalogDeltaTriggerParameter;
import DE.siemens.ad.logo.model.AnalogTriggerParameter;
import DE.siemens.ad.logo.model.AnalogWatchdogParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.ComfortSwitchParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.ModeUniversal;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterItemTable;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.PulseRelayParameter;
import DE.siemens.ad.logo.model.ShiftRegisterParameter;
import DE.siemens.ad.logo.model.SoftkeyParameter;
import DE.siemens.ad.logo.model.StairsSwitchParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.TriggerParameter;
import DE.siemens.ad.logo.model.WipingRelayPECParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.YearClockParameter;
import DE.siemens.ad.logo.model.block.AmplifierBlock;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogDeltaTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.AndBlock;
import DE.siemens.ad.logo.model.block.AsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.ClockBlock;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.LatchingRelayBlock;
import DE.siemens.ad.logo.model.block.MessageBlock;
import DE.siemens.ad.logo.model.block.NandBlock;
import DE.siemens.ad.logo.model.block.NorBlock;
import DE.siemens.ad.logo.model.block.NotBlock;
import DE.siemens.ad.logo.model.block.OffDelayBlock;
import DE.siemens.ad.logo.model.block.OnDelayBlock;
import DE.siemens.ad.logo.model.block.OnOffDelayBlock;
import DE.siemens.ad.logo.model.block.OrBlock;
import DE.siemens.ad.logo.model.block.PecAndBlock;
import DE.siemens.ad.logo.model.block.PecNandBlock;
import DE.siemens.ad.logo.model.block.PulseRelayBlock;
import DE.siemens.ad.logo.model.block.RandomBlock;
import DE.siemens.ad.logo.model.block.RetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterBlock;
import DE.siemens.ad.logo.model.block.SoftkeyBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.WipingRelayBlock;
import DE.siemens.ad.logo.model.block.WipingRelayPECBlock;
import DE.siemens.ad.logo.model.block.XorBlock;
import DE.siemens.ad.logo.model.block.YearClockBlock;
import DE.siemens.ad.logo.model.hardware.Logo4;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo;
import DE.siemens.ad.logo.util.AnchorMemory16;
import DE.siemens.ad.logo.util.AnchorMemoryEnumerator;
import DE.siemens.ad.logo.util.CodeBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.Memory;
import DE.siemens.ad.logo.util.Memory16;
import DE.siemens.ad.logo.util.MemoryEnumeration;
import DE.siemens.ad.logo.util.MessageLine;
import DE.siemens.ad.logo.util.MessageMemory8;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.ProgramMemory16;
import DE.siemens.ad.logo.util.TimeValueProperties;
import DE.siemens.ad.logo.util.Util;

public class CompilerFromLogo4
extends CompilerFromLogo {
    protected int PROGRAM_MEMORY_OFFSET = 200;
    protected Memory16 fProgramMemory;

    public WiringDiagram compile(Hardware hw) throws ProgramException {
        try {
            this.init(hw);
            Memory[] memArr = ((Logo)hw).getMemories();
            for (int i = 0; i < memArr.length; ++i) {
                if (memArr[i] instanceof AnchorMemory16) {
                    this.compileAnchors((AnchorMemory16)memArr[i]);
                    continue;
                }
                if (memArr[i].getClass() != ProgramMemory16.class) continue;
                this.compileProgramMemory((ProgramMemory16)memArr[i]);
            }
            Memory blockNameOffsetTable = ((Logo4)hw).getMemory("BlocknamenTabelle");
            Memory blockNamesTable = ((Logo4)hw).getMemory("Blocknamen");
            Memory programOffsetTable = ((Logo4)hw).getMemory("ProgOffsetTabelle");
            int index = 0;
            MemoryEnumeration offsetElements = blockNameOffsetTable.elements();
            while (offsetElements.hasMoreElements()) {
                int prgLineNr = offsetElements.nextByteAsInt();
                if (prgLineNr != 255) {
                    int blockNr = this.getBlockNumber(prgLineNr);
                    int opcode = this.fProgramMemory.get(programOffsetTable.getWord(prgLineNr * 2) - 200);
                    Block block = this.fWiringDiagram.getBlock(opcode, blockNr);
                    String name = this.getTextFromMessageLine(blockNamesTable.getMemoryBlock(index), 0);
                    block.setUserDefinedName(name);
                }
                ++index;
            }
        }
        catch (Exception e) {
            throw new ProgramException(Language.getString("error.compileError", "Compiler error"));
        }
        return this.fWiringDiagram;
    }

    public void compileAnchors(AnchorMemory16 memory) {
        if (memory.getFirstOpcode() == 144) {
            this.compileAnalogAnchors(memory);
        } else {
            this.compileBinaryAnchors(memory);
        }
    }

    public void compileAnalogAnchors(AnchorMemory16 memory) {
        AnchorMemoryEnumerator enumeration = new AnchorMemoryEnumerator(memory);
        int firstOpcode = memory.getFirstOpcode();
        int opcodeOffset = 0;
        while (enumeration.hasMoreElements()) {
            int element = enumeration.nextElement();
            if (CompilerFromLogo4.isReferenceInLogo(element)) {
                int opcode = firstOpcode + opcodeOffset;
                int anchorNumber = opcodeOffset + 1;
                if (anchorNumber > 2) {
                    anchorNumber -= 2;
                }
                opcode |= 0x1000000;
                try {
                    Block source = this.getBlock(opcode, anchorNumber);
                    this.connect(source, 0, element);
                    this.setAnalogOutputType(source);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            ++opcodeOffset;
        }
    }

    protected void setAnalogOutputType(Block block) {
    }

    public void compileBinaryAnchors(AnchorMemory16 memory) {
        AnchorMemoryEnumerator enumeration = new AnchorMemoryEnumerator(memory);
        int firstOpcode = memory.getFirstOpcode();
        int opcodeOffset = 0;
        while (enumeration.hasMoreElements()) {
            int element = enumeration.nextElement();
            if (CompilerFromLogo4.isReferenceInLogo(element)) {
                int opcode = firstOpcode + opcodeOffset;
                int anchorNumber = this.calculateAnchorNumber(firstOpcode, opcodeOffset);
                opcode |= 0x1000000;
                try {
                    Block source = this.getBlock(opcode, anchorNumber);
                    this.connect(source, 0, element);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            ++opcodeOffset;
        }
    }

    protected int calculateAnchorNumber(int firstOpcode, int offset) {
        if (firstOpcode == 104) {
            return offset + 25;
        }
        return offset + 1;
    }

    protected void compileProgramMemory(ProgramMemory16 programMemory16) throws ProgramException {
        Memory prgOffsetTab = this.fHardware.getMemory("ProgOffsetTabelle");
        prgOffsetTab.setPosition(10, 0);
        int maxBlockNumber = this.fHardware.getMaxResource(0);
        for (int blockNumber = 1; blockNumber <= maxBlockNumber; ++blockNumber) {
            int adr = prgOffsetTab.nextWord();
            if (adr == 65535) continue;
            this.fProgramMemory.setPosition(adr -= this.PROGRAM_MEMORY_OFFSET);
            int opcode = this.fProgramMemory.getWord(adr);
            Block block = this.getBlock(Util.getLowByte(opcode), blockNumber);
            BlockParameter param = block.getParameter();
            if (param != null) {
                this.compileOpcode(opcode, param);
            }
            CodeBlock codeBlock = new CodeBlock(this, "compile");
            codeBlock.addParameter(block);
            try {
                codeBlock.execMethod();
                continue;
            }
            catch (NoSuchMethodException e) {
                Exception ex = codeBlock.getInternalException();
                if (ex instanceof NoSuchMethodException) {
                    System.out.println("Methode nicht definiert:" + this.getClass().getName() + ".compile(" + block.getName() + ") ");
                    continue;
                }
                System.out.println("Exception in: " + this + ".compile(" + block.getName());
                ex.printStackTrace();
                continue;
            }
            catch (Exception generalException) {
                generalException.printStackTrace();
                throw new ProgramException(Language.getString("error.compiler", "Error compiling Block ") + blockNumber);
            }
        }
    }

    public void compile(AndBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.connect(block, 3, this.fProgramMemory.nextWord());
    }

    public void compile(OrBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.connect(block, 3, this.fProgramMemory.nextWord());
    }

    public void compile(NotBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
    }

    public void compile(NandBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.connect(block, 3, this.fProgramMemory.nextWord());
    }

    public void compile(NorBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.connect(block, 3, this.fProgramMemory.nextWord());
    }

    public void compile(XorBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
    }

    public void compile(PecAndBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.connect(block, 3, this.fProgramMemory.nextWord());
    }

    public void compile(PecNandBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.connect(block, 3, this.fProgramMemory.nextWord());
    }

    public void compile(OnDelayBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "T", block.getParameter());
    }

    public void compile(OffDelayBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "T", block.getParameter());
    }

    public void compile(PulseRelayBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        ((PulseRelayParameter)block.getParameter()).setSetPreferred(this.fProgramMemory.nextByte() == 1);
    }

    public void compile(LatchingRelayBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
    }

    public void compile(ClockBlock block) {
        CamParameter camParam;
        int i;
        int opcode = this.fProgramMemory.nextWord();
        ClockParameter clockParam = (ClockParameter)block.getParameter();
        boolean protection = clockParam.getProtection();
        int nockenCount = clockParam.getCamCount();
        for (i = 0; i < nockenCount; ++i) {
            ClockHours camTime;
            camParam = clockParam.getCam(i);
            int logoTime = this.fProgramMemory.nextWord();
            if (logoTime == 65535 || logoTime == 16383) {
                camParam.getOnTime().setInactive(true);
            } else {
                camTime = (ClockHours)this.getNewTimeObject(Util.getHighByte(logoTime), Util.getLowByte(logoTime));
                camTime.setInactive(false);
                camParam.setOnTime(camTime);
            }
            logoTime = this.fProgramMemory.nextWord();
            if (logoTime == 65535 || logoTime == 16383) {
                camParam.getOffTime().setInactive(true);
            } else {
                camTime = (ClockHours)this.getNewTimeObject(Util.getHighByte(logoTime), Util.getLowByte(logoTime));
                camTime.setInactive(false);
                camParam.setOffTime(camTime);
            }
            camParam.setProtection(protection);
        }
        for (i = 0; i < nockenCount; ++i) {
            camParam = clockParam.getCam(i);
            ((ModeUniversal)camParam.getAvailableModes()[11]).setLogoMode(this.fProgramMemory.nextByte());
        }
    }

    public void compile(RetentiveOnDelayBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "T", block.getParameter());
    }

    public void compile(HoursCounterBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        HoursCounterParameter param = (HoursCounterParameter)block.getParameter();
        param.setOperatingTimeStart(this.fProgramMemory.nextDoubleWord());
        param.setMaintenanceInterval(this.fProgramMemory.nextWord());
        param.setOutputSeparatedFromEn(this.fProgramMemory.nextByte() == 1);
    }

    public void compile(WipingRelayBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "T", block.getParameter());
    }

    public void compile(CounterBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        this.setIntegerOrReference(this.fProgramMemory.nextDoubleWord(), opcode, 0, "On", block.getParameter());
        this.setIntegerOrReference(this.fProgramMemory.nextDoubleWord(), opcode, 1, "Off", block.getParameter());
    }

    public void compile(TriggerBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        TriggerParameter param = (TriggerParameter)block.getParameter();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        param.setOnThreshold(this.fProgramMemory.nextWord());
        param.setOffThreshold(this.fProgramMemory.nextWord());
        int lowByte = this.fProgramMemory.nextByte();
        int highByte = this.fProgramMemory.nextByte();
        param.setParamInterval(this.getNewTimeObject(highByte, lowByte));
    }

    public void compile(AsymPulseGeneratorBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "TH", block.getParameter());
        this.setTimerOrReference(opcode, 1, "TL", block.getParameter());
    }

    public void compile(YearClockBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        YearClockParameter param = (YearClockParameter)block.getParameter();
        int paramLowByte = this.fProgramMemory.nextByte();
        int paramHighByte = this.fProgramMemory.nextByte();
        param.getOnTime().setTime(paramHighByte, paramLowByte);
        paramLowByte = this.fProgramMemory.nextByte();
        paramHighByte = this.fProgramMemory.nextByte();
        param.getOffTime().setTime(paramHighByte, paramLowByte);
    }

    public void compile(OnOffDelayBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "TH", block.getParameter());
        this.setTimerOrReference(opcode, 1, "TL", block.getParameter());
    }

    public void compile(RandomBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "TH", block.getParameter());
        this.setTimerOrReference(opcode, 1, "TL", block.getParameter());
    }

    public void compile(StairsSwitchBlock block) {
        StairsSwitchParameter param = (StairsSwitchParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        int lowByte = this.fProgramMemory.nextByte();
        int highByte = this.fProgramMemory.nextByte();
        param.setParamTime(new TimeValueProperties(this.getNewTimeObject(highByte, lowByte), null));
        lowByte = this.fProgramMemory.nextByte();
        highByte = this.fProgramMemory.nextByte();
        param.setTimeToWarning(this.getNewTimeObject(highByte, lowByte));
        lowByte = this.fProgramMemory.nextByte();
        highByte = this.fProgramMemory.nextByte();
        param.setWarningTime(this.getNewTimeObject(highByte, lowByte));
    }

    public void compile(ComfortSwitchBlock block) {
        ComfortSwitchParameter param = (ComfortSwitchParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 1, "TL", param);
        this.setTimerOrReference(opcode, 0, "TH", param);
        this.setTimerOrReference(opcode, 2, "T!", param);
        this.setTimerOrReference(opcode, 3, "T!L", param);
    }

    public void compile(WipingRelayPECBlock block) {
        WipingRelayPECParameter param = (WipingRelayPECParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.setTimerOrReference(opcode, 0, "TH", param);
        this.setTimerOrReference(opcode, 1, "TL", param);
        param.setCycles(this.fProgramMemory.nextByte());
    }

    public void compile(MessageBlock block) {
        MessageParameter param = (MessageParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        short value = (short)this.fProgramMemory.nextByte();
        param.setPriority(new Integer(value & 0x7F));
        param.setReceipt((value & 0x80) > 0);
        param.setMessage(this.getMessageLines(param, this.fProgramMemory.nextByte()));
    }

    protected MessageLine getMessageLine(MessageParameter param, int lineNr) {
        MessageLine result = new MessageLine();
        MessageMemory8 msgMemory = (MessageMemory8)this.fHardware.getMemory("Meldetext");
        int[] line = msgMemory.getMemoryBlock(lineNr);
        if (line[0] != 255) {
            if (line[0] == 1) {
                result.setText(this.getTextFromMessageLine(line, 2));
            } else if (line[0] == 2) {
                BlockParameter refParameter = this.getBlock(line[3], this.getBlockNumber(line[2])).getParameter();
                result.setText(refParameter, line[4]);
                result.setParameterPosition(line[1]);
                refParameter.addParameterUpdateListener(result);
                refParameter.addParameterSetListener(result);
                result.setText(this.getTextFromMessageLine(line, 6));
            } else if (line[0] == 3) {
                result.setBlockParameter(param);
                result.setParameterItemIdentifier("Time");
                result.setParameterPosition(line[1]);
                result.setText(this.getTextFromMessageLine(line, 2));
            } else if (line[0] == 4) {
                result.setBlockParameter(param);
                result.setParameterItemIdentifier("Date");
                result.setParameterPosition(line[1]);
                result.setText(this.getTextFromMessageLine(line, 2));
            } else if (line[0] == 5) {
                result.setBlockParameter(param);
                result.setParameterItemIdentifier("EnableTime");
                result.setParameterPosition(line[1]);
                result.setText(this.getTextFromMessageLine(line, 10));
            } else if (line[0] == 6) {
                result.setBlockParameter(param);
                result.setParameterItemIdentifier("EnableDate");
                result.setParameterPosition(line[1]);
                result.setText(this.getTextFromMessageLine(line, 12));
            } else {
                System.err.println("Fehler: CompilerFroimLogo4.getMessageLine() - MessagelineID " + line[0] + " unbekannt");
            }
        }
        return result;
    }

    private String getTextFromMessageLine(int[] line, int start) {
        int j;
        char[] chars = new char[line.length];
        StringBuffer buffer = new StringBuffer();
        for (j = start; j < line.length && line[j] != 0; ++j) {
            chars[j] = (char)line[j];
        }
        int nrOfBytes = j - start;
        char[] strBytes = new char[nrOfBytes];
        System.arraycopy(chars, start, strBytes, 0, nrOfBytes);
        return new String(strBytes);
    }

    public MessageLine[] getMessageLines(MessageParameter param, int msgNr) {
        int startLine = msgNr * 4;
        MessageMemory8 msgMemory = (MessageMemory8)this.fHardware.getMemory("Meldetext");
        MessageLine[] msgLines = new MessageLine[4];
        for (int i = 0; i < 4; ++i) {
            msgLines[i] = this.getMessageLine(param, startLine++);
            msgLines[i].setLineNumber(i);
        }
        return msgLines;
    }

    public void compile(AnalogTriggerBlock block) {
        AnalogTriggerParameter param = (AnalogTriggerParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        param.setOnTrigger(this.fProgramMemory.nextSignedWord());
        param.setOffTrigger(this.fProgramMemory.nextSignedWord());
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(AnalogComparatorBlock block) {
        AnalogComparatorParameter param = (AnalogComparatorParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        param.setOn(this.fProgramMemory.nextSignedWord());
        param.setOff(this.fProgramMemory.nextSignedWord());
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(SoftkeyBlock block) {
        SoftkeyParameter param = (SoftkeyParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        short value = (short)this.fProgramMemory.nextByte();
        param.setMode((value & 1) == 1);
        param.setSwitchState((value & 0x80) == 128);
        param.setParCycle(this.fProgramMemory.nextByte());
    }

    public void compile(ShiftRegisterBlock block) {
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        this.connect(block, 2, this.fProgramMemory.nextWord());
        int bitMask = this.fProgramMemory.nextByte();
        int bitNr = 0;
        for (int i = 0; i < 8 && (bitMask & 1) == 0; ++i) {
            ++bitNr;
            bitMask >>= 1;
        }
        ((ShiftRegisterParameter)block.getParameter()).setOutputBit(bitNr);
    }

    public void compile(AnalogWatchdogBlock block) {
        AnalogWatchdogParameter param = (AnalogWatchdogParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.connect(block, 1, this.fProgramMemory.nextWord());
        int delt = this.fProgramMemory.nextSignedWord();
        param.setDelta(delt);
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(AnalogDeltaTriggerBlock block) {
        AnalogDeltaTriggerParameter param = (AnalogDeltaTriggerParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        int on = this.fProgramMemory.nextSignedWord();
        int off = this.fProgramMemory.nextSignedWord();
        param.setOnTrigger(on);
        param.setDelta(off - on);
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    public void compile(AmplifierBlock block) {
        AmplifierParameter param = (AmplifierParameter)block.getParameter();
        int opcode = this.fProgramMemory.nextWord();
        this.connect(block, 0, this.fProgramMemory.nextWord());
        this.setGain(param);
        param.setOffset(this.fProgramMemory.nextSignedWord());
        param.setDecimalPlace(this.fProgramMemory.nextByte());
    }

    protected void setTimerOrReference(int opcode, int paramNumber, String parameterID, BlockParameter param) {
        TimeValueProperties newValue = new TimeValueProperties();
        short opcHighbyte = Util.getHighByte(opcode);
        int paramLowByte = this.fProgramMemory.nextByte();
        int paramHighByte = this.fProgramMemory.nextByte();
        ParameterItemList paramItemList = ((ParameterItemTable)this.fHardware.getProperty("parameterItemTable")).getParameterItems(param);
        ParameterItem paramItem = paramItemList.getParameterItem(parameterID).getInstanceForParameter(param);
        if ((opcHighbyte & 32 >> paramNumber) > 0) {
            int memValue = Util.makeSignedWord(paramHighByte, paramLowByte);
            newValue.setReference(this.getReferencedParameterItem(paramLowByte));
            newValue.setReferenceTimeUnit(this.getNewReferencedTimeObject(paramHighByte & 0xC0, 0));
        } else {
            newValue.setCurrentValue(this.getNewTimeObject(paramHighByte, paramLowByte));
        }
        paramItem.setValue(newValue);
    }

    protected void setIntegerOrReference(int memValue, int opcode, int paramNumber, String parameterID, BlockParameter param) {
        IntegerOrBlockReference newValue = new IntegerOrBlockReference(param);
        short opcHighbyte = Util.getHighByte(opcode);
        ParameterItemList paramItemList = ((ParameterItemTable)this.fHardware.getProperty("parameterItemTable")).getParameterItems(param);
        ParameterItem paramItem = paramItemList.getParameterItem(parameterID).getInstanceForParameter(param);
        if ((opcHighbyte & 32 >> paramNumber) > 0) {
            newValue.setReference(this.getReferencedParameterItem(memValue));
        } else {
            newValue.setIntValue(memValue);
        }
        paramItem.setValue(newValue);
    }

    protected ParameterItem getReferencedParameterItem(int memValue) {
        Block srcBlock = this.getBlock(this.getOpcode(memValue), this.getBlockNumber(memValue));
        ParameterItemList itemList = srcBlock.getParameter().getParameterItems().getParameterSourceItems();
        int size = itemList.size();
        if (size == 0 || size > 1) {
            InternalError e = new InternalError("Cannot connect to referencedItem because size of possible Items are more than 1");
            e.printStackTrace();
            throw e;
        }
        return ((ParameterItem)itemList.get(0)).getInstanceForParameter(srcBlock.getParameter());
    }

    protected final int getBlockNumber(int progLineNumber) {
        return progLineNumber - this.getAnchorLineCount() + 1;
    }

    private int getOpcode(int progLineNumber) {
        int prgAdresse = this.fHardware.getMemory("ProgOffsetTabelle").getWord(progLineNumber * 2);
        return Util.getLowByte(this.fProgramMemory.getWord(prgAdresse - 200));
    }

    private int getAnchorLineCount() {
        return 10;
    }

    protected void init(Hardware hw) {
        super.init(hw);
        this.fProgramMemory = (ProgramMemory16)((Logo)hw).getMemory("Program");
    }

    public static boolean isReferenceToBlock(int ref) {
        return !((ref &= 0xFF) == 252 | ref == 255);
    }

    public static boolean isReferenceInLogo(int ref) {
        return (ref &= 0xFF) != 255;
    }

    public TimeUnit getNewTimeObject(int highByte, int lowByte) {
        TimeUnit retValue = null;
        int timeValue = Util.makeSignedWord(highByte, lowByte);
        int timeBase = timeValue & 0xC000;
        timeValue &= 0x3FFF;
        if (timeBase == 16384) {
            retValue = new HighResolutionSeconds();
            ((TimeUnit)retValue).setTime(timeValue / 100, timeValue % 100);
        } else {
            retValue = super.getNewTimeObject(highByte, lowByte);
        }
        return retValue;
    }

    public TimeUnit getNewReferencedTimeObject(int highByte, int lowByte) {
        TimeUnit retValue = null;
        int timeValue = Util.makeSignedWord(highByte, lowByte);
        int timeBase = timeValue & 0xC000;
        timeValue &= 0x3FFF;
        retValue = this.getNewTimeObject(highByte, lowByte);
        return retValue;
    }

    protected Block getTarget(int reference) {
        int blockNumber;
        int opcode;
        Block result = null;
        short highByte = Util.getHighByte(reference);
        int lowByte = Util.getLowByte(reference);
        if ((highByte & 0x80) > 0) {
            int prgAdresse = this.fHardware.getMemory("ProgOffsetTabelle").getWord(lowByte * 2);
            opcode = Util.getLowByte(this.fProgramMemory.getWord(prgAdresse - 200));
            blockNumber = lowByte - (this.getAnchorLineCount() - 1);
        } else {
            opcode = lowByte;
            blockNumber = this.fHardware.calculateBlockNumber(opcode);
            opcode |= 0x1000000;
        }
        result = this.getBlock(opcode, blockNumber);
        return result;
    }

    protected Block getBlock(int opcode, int blockNumber) {
        Block result = this.fWiringDiagram.getBlock(opcode, blockNumber);
        if (result == null) {
            result = this.fWiringDiagram.createBlock(opcode, blockNumber);
        }
        return result;
    }

    protected void connect(Block source, int sourceConnectorNr, int reference) {
        InBlockConnector inConnector;
        try {
            inConnector = source.getInConnector(sourceConnectorNr);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.error(e, "No Input " + (sourceConnectorNr + 1) + "at Block " + source.toString());
            throw new IllegalArgumentException();
        }
        if ((Util.getHighByte(reference) & 0x40) > 0 && Util.getLowByte(reference) != 255) {
            inConnector.setNegated(true);
        }
        if (CompilerFromLogo4.isReferenceToBlock(reference)) {
            Block target = this.getTarget(reference);
            OutBlockConnector outConnector = target.getOutConnector(0);
            inConnector.connect(outConnector);
        } else {
            inConnector.setNotConnectedCode((short)reference);
        }
    }

    protected void compileOpcode(int opcode, BlockParameter param) {
        short highByte = Util.getHighByte(opcode);
        if ((highByte & 0x80) > 0) {
            param.getRemanenceObject().setRemanence(true);
        }
        if ((highByte & 0x40) == 0 && param instanceof ProtectionParameter) {
            ((ProtectionParameter)param).setProtection(true);
        }
    }

    protected void setGain(Analog param) {
        param.setGain(this.fProgramMemory.nextWord());
    }
}

