/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.app.comp.BorderJPanel;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.SoftkeyParameter;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SoftkeyPanel
extends AbstractProtectionPanel
implements ParameterSetListener {
    private JPanel ivjParameterPanel = null;
    private BorderJPanel ivjStateBorder = null;
    private ButtonGroup ivjStateGroup = null;
    private BorderJPanel ivjTypeBorder = null;
    private ButtonGroup ivjTypeGroup = null;
    private JRadioButton ivjMomentaryButton = null;
    private JRadioButton ivjOffButton = null;
    private JRadioButton ivjOnButton = null;
    private JRadioButton ivjSwitchButton = null;
    private JCheckBox currentValueCheckBox = null;
    private SoftkeyParameter parameter = null;

    public SoftkeyPanel() {
        this.initialize();
    }

    public SoftkeyPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.parameter = (SoftkeyParameter)parameterReference;
        this.addParameterPane(this.getParameterPanel());
        if (simulationMode) {
            this.currentParameterBorderPanel = new BorderJPanel();
            this.currentParameterBorderPanel.setAlignmentX(20.0f);
            this.currentParameterBorderPanel.setLayout(new BorderLayout());
            this.actualPane.add(this.currentParameterBorderPanel);
            this.currentParameterBorderPanel.add((Component)new JPanel(){

                public Dimension getMinimumSize() {
                    return new Dimension(20, 0);
                }
            }, "West");
            this.currentValueCheckBox = new JCheckBox(Language.getString("dialog.parameter.softkey.state", "Status"));
            this.currentValueCheckBox.setFont(new Font("Dialog", 1, 12));
            this.currentValueCheckBox.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    SoftkeyPanel.this.parameter.setSimulationSwitchState(new SoftkeyParameter.SwitchState(SoftkeyPanel.this.currentValueCheckBox.isSelected()));
                }
            });
            this.currentParameterBorderPanel.add(this.currentValueCheckBox);
            parameterReference.addParameterSetListener(this);
        }
        boolean state = this.parameter.getBlock().getWiringDiagram().getHardware().supports("softkeyProtection");
        this.setProtectionVisible(state);
    }

    public boolean checkChanged() {
        if (super.checkChanged()) {
            return true;
        }
        SoftkeyParameter model = (SoftkeyParameter)this.fParameterReference;
        if (this.getSwitchButton().isSelected() ? !model.isSwitch() : model.isSwitch()) {
            return true;
        }
        return this.getOnButton().isSelected() ? !model.isOn() : model.isOn();
    }

    public boolean checkFieldContents() {
        return true;
    }

    public void closeEvent() {
        this.getParameterReference().removeParameterSetListener(this);
    }

    private JRadioButton getMomentaryButton() {
        if (this.ivjMomentaryButton == null) {
            try {
                this.ivjMomentaryButton = new JRadioButton();
                this.ivjMomentaryButton.setName("MomentaryButton");
                this.ivjMomentaryButton.setText("Momentary");
                this.ivjMomentaryButton.setBounds(6, 42, 300, 22);
                this.ivjMomentaryButton.setActionCommand("");
                this.getTypeGroup().add(this.ivjMomentaryButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMomentaryButton;
    }

    private JRadioButton getOffButton() {
        if (this.ivjOffButton == null) {
            try {
                this.ivjOffButton = new JRadioButton();
                this.ivjOffButton.setName("OffButton");
                this.ivjOffButton.setSelected(true);
                this.ivjOffButton.setText("Off");
                this.ivjOffButton.setBounds(6, 42, 300, 22);
                this.getStateGroup().add(this.ivjOffButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOffButton;
    }

    private JRadioButton getOnButton() {
        if (this.ivjOnButton == null) {
            try {
                this.ivjOnButton = new JRadioButton();
                this.ivjOnButton.setName("OnButton");
                this.ivjOnButton.setText("On");
                this.ivjOnButton.setBounds(6, 20, 300, 22);
                this.getStateGroup().add(this.ivjOnButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOnButton;
    }

    private JPanel getParameterPanel() {
        if (this.ivjParameterPanel == null) {
            try {
                this.ivjParameterPanel = new JPanel();
                this.ivjParameterPanel.setName("ParameterPanel");
                this.ivjParameterPanel.setLayout(new GridBagLayout());
                this.ivjParameterPanel.setBounds(20, 23, 214, 188);
                GridBagConstraints constraintsTypeBorder = new GridBagConstraints();
                constraintsTypeBorder.gridx = 1;
                constraintsTypeBorder.gridy = 1;
                constraintsTypeBorder.fill = 1;
                constraintsTypeBorder.weightx = 1.0;
                constraintsTypeBorder.weighty = 1.0;
                constraintsTypeBorder.ipadx = 194;
                constraintsTypeBorder.ipady = 74;
                constraintsTypeBorder.insets = new Insets(10, 10, 10, 10);
                this.getParameterPanel().add((Component)this.getTypeBorder(), constraintsTypeBorder);
                GridBagConstraints constraintsStateBorder = new GridBagConstraints();
                constraintsStateBorder.gridx = 1;
                constraintsStateBorder.gridy = 2;
                constraintsStateBorder.fill = 1;
                constraintsStateBorder.weightx = 1.0;
                constraintsStateBorder.weighty = 1.0;
                constraintsStateBorder.ipadx = 194;
                constraintsStateBorder.ipady = 74;
                constraintsStateBorder.insets = new Insets(10, 10, 10, 10);
                this.getParameterPanel().add((Component)this.getStateBorder(), constraintsStateBorder);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjParameterPanel;
    }

    private BorderJPanel getStateBorder() {
        if (this.ivjStateBorder == null) {
            try {
                this.ivjStateBorder = new BorderJPanel();
                this.ivjStateBorder.setName("StateBorder");
                this.ivjStateBorder.setLayout(null);
                this.ivjStateBorder.setTitle("Zustand");
                this.getStateBorder().add((Component)this.getOnButton(), this.getOnButton().getName());
                this.getStateBorder().add((Component)this.getOffButton(), this.getOffButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStateBorder;
    }

    private ButtonGroup getStateGroup() {
        if (this.ivjStateGroup == null) {
            try {
                this.ivjStateGroup = new ButtonGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjStateGroup;
    }

    private JRadioButton getSwitchButton() {
        if (this.ivjSwitchButton == null) {
            try {
                this.ivjSwitchButton = new JRadioButton();
                this.ivjSwitchButton.setName("SwitchButton");
                this.ivjSwitchButton.setSelected(true);
                this.ivjSwitchButton.setText("Switch");
                this.ivjSwitchButton.setBounds(6, 20, 300, 22);
                this.getTypeGroup().add(this.ivjSwitchButton);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSwitchButton;
    }

    private BorderJPanel getTypeBorder() {
        if (this.ivjTypeBorder == null) {
            try {
                this.ivjTypeBorder = new BorderJPanel();
                this.ivjTypeBorder.setName("TypeBorder");
                this.ivjTypeBorder.setLayout(null);
                this.ivjTypeBorder.setTitle("Typ");
                this.getTypeBorder().add((Component)this.getSwitchButton(), this.getSwitchButton().getName());
                this.getTypeBorder().add((Component)this.getMomentaryButton(), this.getMomentaryButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTypeBorder;
    }

    private ButtonGroup getTypeGroup() {
        if (this.ivjTypeGroup == null) {
            try {
                this.ivjTypeGroup = new ButtonGroup();
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTypeGroup;
    }

    private void handleException(Throwable exception) {
    }

    private void initialize() {
        try {
            this.setName("SoftkeyPanel");
            this.setLayout(new FlowLayout());
            this.setSize(52, 32);
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        SoftkeyParameter model = (SoftkeyParameter)this.fParameterReference;
        if (model.isSwitch()) {
            this.getSwitchButton().setSelected(true);
        } else {
            this.getMomentaryButton().setSelected(true);
        }
        if (model.isOn()) {
            this.getOnButton().setSelected(true);
        } else {
            this.getOffButton().setSelected(true);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame();
            SoftkeyPanel aSoftkeyPanel = new SoftkeyPanel();
            aSoftkeyPanel.getParameterPanel();
            frame.setContentPane(aSoftkeyPanel);
            frame.setSize(aSoftkeyPanel.getSize());
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.show();
            Insets insets = frame.getInsets();
            frame.setSize(frame.getWidth() + insets.left + insets.right, frame.getHeight() + insets.top + insets.bottom);
            frame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of DE.siemens.ad.logo.model.panel.ParameterPanel");
            exception.printStackTrace(System.out);
        }
    }

    public void parameterSet(Parameter parameter, String newParameterText) {
        try {
            if (((SoftkeyParameter)parameter).getSwitchState()) {
                this.getOnButton().setSelected(true);
            } else {
                this.getOffButton().setSelected(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setLabels() {
        super.setLabels();
        this.getTypeBorder().setTitle(Language.getString("dialog.parameter.softkey.type", "Type"));
        this.getSwitchButton().setText(Language.getString("dialog.parameter.softkey.switch", "Switch"));
        this.getMomentaryButton().setText(Language.getString("dialog.parameter.softkey.momentary", "Momentary"));
        this.getStateBorder().setTitle(Language.getString("dialog.parameter.softkey.statusParameter", "State"));
        this.getOnButton().setText(Language.getString("dialog.parameter.softkey.on", "On"));
        this.getOffButton().setText(Language.getString("dialog.parameter.softkey.off", "Off"));
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        SoftkeyParameter model = (SoftkeyParameter)this.fParameterReference;
        if (this.getSwitchButton().isSelected()) {
            model.setMode(true);
        } else {
            model.setMode(false);
        }
        if (this.getOnButton().isSelected()) {
            model.setSwitchState(Boolean.TRUE);
        } else {
            model.setSwitchState(Boolean.FALSE);
        }
    }

    public void parameterUpdated(ParameterUpdateEvent e) {
        SoftkeyParameter parameter = (SoftkeyParameter)this.fParameterReference;
        this.currentValueCheckBox.setSelected(parameter.getSimulationSwitchState().getState());
    }
}

